/*
 * Decompiled with CFR 0.152.
 */
package Net.Calabridragon.cals_extra_gems.datagen;

import Net.Calabridragon.cals_extra_gems.block.ModBlocks;
import Net.Calabridragon.cals_extra_gems.item.ModItems;
import java.util.LinkedHashMap;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ModItemModelProvider
extends ItemModelProvider {
    private static LinkedHashMap<ResourceKey<TrimMaterial>, Float> trimMaterials = new LinkedHashMap();

    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "cals_extra_gems", existingFileHelper);
    }

    protected void registerModels() {
        this.simpleItem(ModItems.SAPPHIRE);
        this.simpleItem(ModItems.BLACK_TOURMALINE_SHARD);
        this.simpleItem(ModItems.GREEN_TOURMALINE_SHARD);
        this.simpleItem(ModItems.BLUE_TOURMALINE_SHARD);
        this.simpleItem(ModItems.ORANGE_TOURMALINE_SHARD);
        this.simpleItem(ModItems.PINK_TOURMALINE_SHARD);
        this.simpleItem(ModItems.WATERMELON_TOURMALINE_SHARD);
        this.simpleItem(ModItems.AQUAMARINE);
        this.simpleItem(ModItems.BLUE_BERYL);
        this.simpleItem(ModItems.GOLDEN_BERYL);
        this.simpleItem(ModItems.PINK_BERYL);
        this.simpleItem(ModItems.RED_BERYL);
        this.simpleItem(ModItems.BLUE_QUARTZ);
        this.simpleItem(ModItems.ROSE_QUARTZ);
        this.simpleItem(ModItems.SMOKY_QUARTZ);
        this.simpleItem(ModItems.OPAL);
        this.wallItem(ModBlocks.OPAL_WALL, ModBlocks.OPAL_BLOCK);
        this.wallItem(ModBlocks.EMERALD_WALL, ModBlocks.EMERALD_WALL);
        this.wallItem(ModBlocks.SAPPHIRE_WALL, ModBlocks.SAPPHIRE_BLOCK);
        this.wallItem(ModBlocks.TOPAZ_WALL, ModBlocks.TOPAZ_BLOCK);
        this.wallItem(ModBlocks.PINK_TOPAZ_WALL, ModBlocks.PINK_TOPAZ_BLOCK);
        this.wallItem(ModBlocks.BLUE_TOPAZ_WALL, ModBlocks.BLUE_TOPAZ_BLOCK);
        this.wallItem(ModBlocks.PURPLE_TOPAZ_WALL, ModBlocks.PURPLE_TOPAZ_BLOCK);
        this.wallItem(ModBlocks.AQUAMARINE_WALL, ModBlocks.AQUAMARINE_BLOCK);
        this.wallItem(ModBlocks.BLUE_BERYL_WALL, ModBlocks.BLUE_BERYL_BLOCK);
        this.wallItem(ModBlocks.GOLDEN_BERYL_WALL, ModBlocks.GOLDEN_BERYL_BLOCK);
        this.wallItem(ModBlocks.PINK_BERYL_WALL, ModBlocks.PINK_BERYL_BLOCK);
        this.wallItem(ModBlocks.RED_BERYL_WALL, ModBlocks.RED_BERYL_BLOCK);
        this.evenSimplerBlockItem(ModBlocks.SAPPHIRE_SLAB);
        this.evenSimplerBlockItem(ModBlocks.SAPPHIRE_STAIRS);
        this.handheldItem(ModItems.SAPPHIRE_SWORD);
        this.handheldItem(ModItems.SAPPHIRE_PICKAXE);
        this.handheldItem(ModItems.SAPPHIRE_AXE);
        this.handheldItem(ModItems.SAPPHIRE_SHOVEL);
        this.handheldItem(ModItems.SAPPHIRE_HOE);
        this.evenSimplerBlockItem(ModBlocks.OPAL_SLAB);
        this.evenSimplerBlockItem(ModBlocks.OPAL_STAIRS);
        this.handheldItem(ModItems.OPAL_SWORD);
        this.handheldItem(ModItems.OPAL_PICKAXE);
        this.handheldItem(ModItems.OPAL_AXE);
        this.handheldItem(ModItems.OPAL_SHOVEL);
        this.handheldItem(ModItems.OPAL_HOE);
        this.evenSimplerBlockItem(ModBlocks.BLUE_QUARTZ_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.BLUE_QUARTZ_SLAB);
        this.evenSimplerBlockItem(ModBlocks.SMOOTH_BLUE_QUARTZ_SLAB);
        this.evenSimplerBlockItem(ModBlocks.SMOOTH_BLUE_QUARTZ_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.ROSE_QUARTZ_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.SMOOTH_ROSE_QUARTZ_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.ROSE_QUARTZ_SLAB);
        this.evenSimplerBlockItem(ModBlocks.SMOOTH_ROSE_QUARTZ_SLAB);
        this.evenSimplerBlockItem(ModBlocks.SMOKY_QUARTZ_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.SMOOTH_SMOKY_QUARTZ_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.SMOKY_QUARTZ_SLAB);
        this.evenSimplerBlockItem(ModBlocks.SMOOTH_SMOKY_QUARTZ_SLAB);
        this.evenSimplerBlockItem(ModBlocks.EMERALD_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.EMERALD_SLAB);
        this.evenSimplerBlockItem(ModBlocks.AQUAMARINE_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.AQUAMARINE_SLAB);
        this.evenSimplerBlockItem(ModBlocks.BLUE_BERYL_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.BLUE_BERYL_SLAB);
        this.evenSimplerBlockItem(ModBlocks.GOLDEN_BERYL_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.GOLDEN_BERYL_SLAB);
        this.evenSimplerBlockItem(ModBlocks.PINK_BERYL_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.PINK_BERYL_SLAB);
        this.evenSimplerBlockItem(ModBlocks.RED_BERYL_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.RED_BERYL_SLAB);
        this.evenSimplerBlockItem(ModBlocks.TOPAZ_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.TOPAZ_SLAB);
        this.evenSimplerBlockItem(ModBlocks.PINK_TOPAZ_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.PINK_TOPAZ_SLAB);
        this.evenSimplerBlockItem(ModBlocks.BLUE_TOPAZ_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.BLUE_TOPAZ_SLAB);
        this.evenSimplerBlockItem(ModBlocks.PURPLE_TOPAZ_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.PURPLE_TOPAZ_SLAB);
        this.simpleItem(ModItems.TOPAZ);
        this.simpleItem(ModItems.PINK_TOPAZ);
        this.simpleItem(ModItems.BLUE_TOPAZ);
        this.simpleItem(ModItems.PURPLE_TOPAZ);
        this.trimmedArmorItem(ModItems.SAPPHIRE_HELMET);
        this.trimmedArmorItem(ModItems.SAPPHIRE_CHESTPLATE);
        this.trimmedArmorItem(ModItems.SAPPHIRE_LEGGINGS);
        this.trimmedArmorItem(ModItems.SAPPHIRE_BOOTS);
        this.trimmedArmorItem(ModItems.OPAL_HELMET);
        this.trimmedArmorItem(ModItems.OPAL_CHESTPLATE);
        this.trimmedArmorItem(ModItems.OPAL_LEGGINGS);
        this.trimmedArmorItem(ModItems.OPAL_BOOTS);
    }

    private void trimmedArmorItem(RegistryObject<Item> itemRegistryObject) {
        String MOD_ID = "cals_extra_gems";
        Object object = itemRegistryObject.get();
        if (object instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)object;
            trimMaterials.entrySet().forEach(entry -> {
                ResourceKey trimMaterial = (ResourceKey)entry.getKey();
                float trimValue = ((Float)entry.getValue()).floatValue();
                String armorType = switch (armorItem.m_40402_()) {
                    case EquipmentSlot.HEAD -> "helmet";
                    case EquipmentSlot.CHEST -> "chestplate";
                    case EquipmentSlot.LEGS -> "leggings";
                    case EquipmentSlot.FEET -> "boots";
                    default -> "";
                };
                String armorItemPath = "item/" + armorItem;
                String trimPath = "trims/items/" + armorType + "_trim_" + trimMaterial.m_135782_().m_135815_();
                String currentTrimName = armorItemPath + "_" + trimMaterial.m_135782_().m_135815_() + "_trim";
                ResourceLocation armorItemResLoc = new ResourceLocation("cals_extra_gems", armorItemPath);
                ResourceLocation trimResLoc = new ResourceLocation(trimPath);
                ResourceLocation trimNameResLoc = new ResourceLocation("cals_extra_gems", currentTrimName);
                this.existingFileHelper.trackGenerated(trimResLoc, PackType.CLIENT_RESOURCES, ".png", "textures");
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(currentTrimName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"){})).texture("layer0", armorItemResLoc)).texture("layer1", trimResLoc);
                ((ItemModelBuilder)this.withExistingParent(itemRegistryObject.getId().m_135815_(), this.mcLoc("item/generated"))).override().model((ModelFile)new ModelFile.UncheckedModelFile(trimNameResLoc)).predicate(this.mcLoc("trim_type"), trimValue).end().texture("layer0", new ResourceLocation("cals_extra_gems", "item/" + itemRegistryObject.getId().m_135815_()));
            });
        }
    }

    private ItemModelBuilder simpleItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("cals_extra_gems", "item/" + item.getId().m_135815_()));
    }

    public void evenSimplerBlockItem(RegistryObject<Block> block) {
        this.withExistingParent("cals_extra_gems:" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_()));
    }

    public void wallItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.mcLoc("block/wall_inventory"))).texture("wall", new ResourceLocation("cals_extra_gems", "block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).m_135815_()));
    }

    private ItemModelBuilder handheldItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/handheld"))).texture("layer0", new ResourceLocation("cals_extra_gems", "item/" + item.getId().m_135815_()));
    }

    static {
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265905_, Float.valueOf(0.1f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266000_, Float.valueOf(0.2f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265896_, Float.valueOf(0.3f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265870_, Float.valueOf(0.4f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265969_, Float.valueOf(0.5f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265937_, Float.valueOf(0.6f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266071_, Float.valueOf(0.7f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266027_, Float.valueOf(0.8f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265981_, Float.valueOf(0.9f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265872_, Float.valueOf(1.0f));
    }
}

