/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.eventwrapper.event.entity;

import io.github.lounode.eventwrapper.event.entity.EntityEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.Cancelable;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1676;
import net.minecraft.class_239;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

@Cancelable
public class ProjectileImpactEventWrapper
extends EntityEventWrapper {
    private final class_239 ray;
    private final class_1676 projectile;
    private ImpactResult result = ImpactResult.DEFAULT;

    public ProjectileImpactEventWrapper(class_1676 projectile, class_239 ray) {
        super((class_1297)projectile);
        this.ray = ray;
        this.projectile = projectile;
    }

    public ProjectileImpactEventWrapper(ProjectileImpactEvent event) {
        this(event.getProjectile(), event.getRayTraceResult());
    }

    @Override
    @Deprecated(forRemoval=true, since="1.20.1")
    public void setCanceled(boolean cancel) {
        super.setCanceled(cancel);
    }

    public class_239 getRayTraceResult() {
        return this.ray;
    }

    public class_1676 getProjectile() {
        return this.projectile;
    }

    public void setImpactResult(@NotNull ImpactResult newResult) {
        this.result = Objects.requireNonNull(newResult, "ImpactResult cannot be null");
    }

    public ImpactResult getImpactResult() {
        return this.result;
    }

    public static Class<? extends Event> getForgeClass() {
        return ProjectileImpactEvent.class;
    }

    @Override
    public Object toForgeEvent() {
        return new ProjectileImpactEvent(this.getProjectile(), this.getRayTraceResult());
    }

    public static enum ImpactResult {
        DEFAULT,
        SKIP_ENTITY,
        STOP_AT_CURRENT,
        STOP_AT_CURRENT_NO_DAMAGE;

    }
}

