/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.eventwrapper.event.entity.living;

import io.github.lounode.eventwrapper.event.entity.EntityEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.Cancelable;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public abstract class LivingEventWrapper
extends EntityEventWrapper {
    private final class_1309 livingEntity;

    public LivingEventWrapper(class_1309 entity) {
        super((class_1297)entity);
        this.livingEntity = entity;
    }

    public LivingEventWrapper(LivingEvent event) {
        this(event.getEntity());
    }

    public class_1309 getEntity() {
        return this.livingEntity;
    }

    public static Class<? extends Event> getForgeClass() {
        return LivingEvent.class;
    }

    public static class LivingVisibilityEvent
    extends LivingEventWrapper {
        private double visibilityModifier;
        @Nullable
        private final class_1297 lookingEntity;

        public LivingVisibilityEvent(class_1309 livingEntity, @Nullable class_1297 lookingEntity, double originalMultiplier) {
            super(livingEntity);
            this.visibilityModifier = originalMultiplier;
            this.lookingEntity = lookingEntity;
        }

        public LivingVisibilityEvent(LivingEvent.LivingVisibilityEvent event) {
            this(event.getEntity(), event.getLookingEntity(), event.getVisibilityModifier());
        }

        public void modifyVisibility(double mod) {
            this.visibilityModifier *= mod;
        }

        public double getVisibilityModifier() {
            return this.visibilityModifier;
        }

        @Nullable
        public class_1297 getLookingEntity() {
            return this.lookingEntity;
        }

        public static Class<? extends Event> getForgeClass() {
            return LivingEvent.LivingVisibilityEvent.class;
        }
    }

    public static class LivingJumpEvent
    extends LivingEventWrapper {
        public LivingJumpEvent(class_1309 e) {
            super(e);
        }

        public LivingJumpEvent(LivingEvent.LivingJumpEvent event) {
            this(event.getEntity());
        }

        public static Class<? extends Event> getForgeClass() {
            return LivingEvent.LivingJumpEvent.class;
        }
    }

    @Cancelable
    public static class LivingTickEvent
    extends LivingEventWrapper {
        public LivingTickEvent(class_1309 e) {
            super(e);
        }

        public LivingTickEvent(LivingEvent.LivingTickEvent event) {
            this(event.getEntity());
        }

        public static Class<? extends Event> getForgeClass() {
            return LivingEvent.LivingTickEvent.class;
        }
    }
}

