/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.eventwrapper.event.entity.player;

import io.github.lounode.eventwrapper.event.entity.living.LivingEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.Cancelable;
import java.io.File;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_5321;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PlayerEventWrapper
extends LivingEventWrapper {
    private final class_1657 player;

    public PlayerEventWrapper(class_1657 player) {
        super((class_1309)player);
        this.player = player;
    }

    public PlayerEventWrapper(PlayerEvent event) {
        this(event.getEntity());
    }

    public class_1657 getEntity() {
        return this.player;
    }

    public static Class<? extends Event> getForgeClass() {
        return PlayerEvent.class;
    }

    @Cancelable
    public static class PlayerChangeGameModeEvent
    extends PlayerEventWrapper {
        private final class_1934 currentGameMode;
        private class_1934 newGameMode;

        public PlayerChangeGameModeEvent(class_1657 player, class_1934 currentGameMode, class_1934 newGameMode) {
            super(player);
            this.currentGameMode = currentGameMode;
            this.newGameMode = newGameMode;
        }

        public PlayerChangeGameModeEvent(PlayerEvent.PlayerChangeGameModeEvent event) {
            this(event.getEntity(), event.getCurrentGameMode(), event.getNewGameMode());
        }

        public class_1934 getCurrentGameMode() {
            return this.currentGameMode;
        }

        public class_1934 getNewGameMode() {
            return this.newGameMode;
        }

        public void setNewGameMode(class_1934 newGameMode) {
            this.newGameMode = newGameMode;
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.PlayerChangeGameModeEvent.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.PlayerChangeGameModeEvent(this.getEntity(), this.getCurrentGameMode(), this.getNewGameMode());
        }
    }

    public static class PlayerChangedDimensionEvent
    extends PlayerEventWrapper {
        private final class_5321<class_1937> fromDim;
        private final class_5321<class_1937> toDim;

        public PlayerChangedDimensionEvent(class_1657 player, class_5321<class_1937> fromDim, class_5321<class_1937> toDim) {
            super(player);
            this.fromDim = fromDim;
            this.toDim = toDim;
        }

        public PlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
            this(event.getEntity(), (class_5321<class_1937>)event.getFrom(), (class_5321<class_1937>)event.getTo());
        }

        public class_5321<class_1937> getFrom() {
            return this.fromDim;
        }

        public class_5321<class_1937> getTo() {
            return this.toDim;
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.PlayerChangedDimensionEvent.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.PlayerChangedDimensionEvent(this.getEntity(), this.getFrom(), this.getTo());
        }
    }

    public static class PlayerRespawnEvent
    extends PlayerEventWrapper {
        private final boolean endConquered;

        public PlayerRespawnEvent(class_1657 player, boolean endConquered) {
            super(player);
            this.endConquered = endConquered;
        }

        public PlayerRespawnEvent(PlayerEvent.PlayerRespawnEvent event) {
            this(event.getEntity(), event.isEndConquered());
        }

        public boolean isEndConquered() {
            return this.endConquered;
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.PlayerRespawnEvent.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.PlayerRespawnEvent(this.getEntity(), this.isEndConquered());
        }
    }

    public static class PlayerLoggedOutEvent
    extends PlayerEventWrapper {
        public PlayerLoggedOutEvent(class_1657 player) {
            super(player);
        }

        public PlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
            this(event.getEntity());
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.PlayerLoggedOutEvent.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.PlayerLoggedOutEvent(this.getEntity());
        }
    }

    public static class PlayerLoggedInEvent
    extends PlayerEventWrapper {
        public PlayerLoggedInEvent(class_1657 player) {
            super(player);
        }

        public PlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
            this(event.getEntity());
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.PlayerLoggedInEvent.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.PlayerLoggedInEvent(this.getEntity());
        }
    }

    public static class ItemSmeltedEvent
    extends PlayerEventWrapper {
        @NotNull
        private final class_1799 smelting;

        public ItemSmeltedEvent(class_1657 player, @NotNull class_1799 crafting) {
            super(player);
            this.smelting = crafting;
        }

        public ItemSmeltedEvent(PlayerEvent.ItemSmeltedEvent event) {
            this(event.getEntity(), event.getSmelting());
        }

        @NotNull
        public class_1799 getSmelting() {
            return this.smelting;
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.ItemSmeltedEvent.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.ItemSmeltedEvent(this.getEntity(), this.getSmelting());
        }
    }

    public static class ItemCraftedEvent
    extends PlayerEventWrapper {
        @NotNull
        private final class_1799 crafting;
        private final class_1263 craftMatrix;

        public ItemCraftedEvent(class_1657 player, @NotNull class_1799 crafting, class_1263 craftMatrix) {
            super(player);
            this.crafting = crafting;
            this.craftMatrix = craftMatrix;
        }

        public ItemCraftedEvent(PlayerEvent.ItemCraftedEvent event) {
            this(event.getEntity(), event.getCrafting(), event.getInventory());
        }

        @NotNull
        public class_1799 getCrafting() {
            return this.crafting;
        }

        public class_1263 getInventory() {
            return this.craftMatrix;
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.ItemCraftedEvent.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.ItemCraftedEvent(this.getEntity(), this.getCrafting(), this.getInventory());
        }
    }

    public static class ItemPickupEvent
    extends PlayerEventWrapper {
        private final class_1542 originalEntity;
        private final class_1799 stack;

        public ItemPickupEvent(class_1657 player, class_1542 entPickedUp, class_1799 stack) {
            super(player);
            this.originalEntity = entPickedUp;
            this.stack = stack;
        }

        public ItemPickupEvent(PlayerEvent.ItemPickupEvent event) {
            this(event.getEntity(), event.getOriginalEntity(), event.getStack());
        }

        public class_1799 getStack() {
            return this.stack;
        }

        public class_1542 getOriginalEntity() {
            return this.originalEntity;
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.ItemPickupEvent.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.ItemPickupEvent(this.getEntity(), this.getOriginalEntity(), this.getStack());
        }
    }

    public static class SaveToFile
    extends PlayerEventWrapper {
        private final File playerDirectory;
        private final String playerUUID;

        public SaveToFile(class_1657 player, File originDirectory, String playerUUID) {
            super(player);
            this.playerDirectory = originDirectory;
            this.playerUUID = playerUUID;
        }

        public SaveToFile(PlayerEvent.SaveToFile event) {
            this(event.getEntity(), event.getPlayerDirectory(), event.getPlayerUUID());
        }

        public File getPlayerFile(String suffix) {
            if ("dat".equals(suffix)) {
                throw new IllegalArgumentException("The suffix 'dat' is reserved");
            }
            return new File(this.getPlayerDirectory(), this.getPlayerUUID() + "." + suffix);
        }

        public File getPlayerDirectory() {
            return this.playerDirectory;
        }

        public String getPlayerUUID() {
            return this.playerUUID;
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.SaveToFile.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.SaveToFile(this.getEntity(), this.getPlayerDirectory(), this.getPlayerUUID());
        }
    }

    public static class LoadFromFile
    extends PlayerEventWrapper {
        private final File playerDirectory;
        private final String playerUUID;

        public LoadFromFile(class_1657 player, File originDirectory, String playerUUID) {
            super(player);
            this.playerDirectory = originDirectory;
            this.playerUUID = playerUUID;
        }

        public LoadFromFile(PlayerEvent.LoadFromFile event) {
            this(event.getEntity(), event.getPlayerDirectory(), event.getPlayerUUID());
        }

        public File getPlayerFile(String suffix) {
            if ("dat".equals(suffix)) {
                throw new IllegalArgumentException("The suffix 'dat' is reserved");
            }
            return new File(this.getPlayerDirectory(), this.getPlayerUUID() + "." + suffix);
        }

        public File getPlayerDirectory() {
            return this.playerDirectory;
        }

        public String getPlayerUUID() {
            return this.playerUUID;
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.LoadFromFile.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.LoadFromFile(this.getEntity(), this.getPlayerDirectory(), this.getPlayerUUID());
        }
    }

    public static class StopTracking
    extends PlayerEventWrapper {
        private final class_1297 target;

        public StopTracking(class_1657 player, class_1297 target) {
            super(player);
            this.target = target;
        }

        public StopTracking(PlayerEvent.StopTracking event) {
            this(event.getEntity(), event.getTarget());
        }

        public class_1297 getTarget() {
            return this.target;
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.StopTracking.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.StopTracking(this.getEntity(), this.getTarget());
        }
    }

    public static class StartTracking
    extends PlayerEventWrapper {
        private final class_1297 target;

        public StartTracking(class_1657 player, class_1297 target) {
            super(player);
            this.target = target;
        }

        public StartTracking(PlayerEvent.StartTracking event) {
            this(event.getEntity(), event.getTarget());
        }

        public class_1297 getTarget() {
            return this.target;
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.StartTracking.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.StartTracking(this.getEntity(), this.getTarget());
        }
    }

    public static class Clone
    extends PlayerEventWrapper {
        private final class_1657 original;
        private final boolean wasDeath;

        public Clone(class_1657 _new, class_1657 oldPlayer, boolean wasDeath) {
            super(_new);
            this.original = oldPlayer;
            this.wasDeath = wasDeath;
        }

        public Clone(PlayerEvent.Clone event) {
            this(event.getEntity(), event.getOriginal(), event.isWasDeath());
        }

        public class_1657 getOriginal() {
            return this.original;
        }

        public boolean isWasDeath() {
            return this.wasDeath;
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.Clone.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.Clone(this.getEntity(), this.getOriginal(), this.isWasDeath());
        }
    }

    public static class TabListNameFormat
    extends PlayerEventWrapper {
        @Nullable
        private class_2561 displayName;

        public TabListNameFormat(class_1657 player) {
            super(player);
        }

        public TabListNameFormat(PlayerEvent.TabListNameFormat event) {
            this(event.getEntity());
        }

        @Nullable
        public class_2561 getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(@Nullable class_2561 displayName) {
            this.displayName = displayName;
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.TabListNameFormat.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.TabListNameFormat(this.getEntity());
        }
    }

    public static class NameFormat
    extends PlayerEventWrapper {
        private final class_2561 username;
        private class_2561 displayname;

        public NameFormat(class_1657 player, class_2561 username) {
            super(player);
            this.username = username;
            this.setDisplayname(username);
        }

        public NameFormat(PlayerEvent.NameFormat event) {
            this(event.getEntity(), event.getUsername());
        }

        public class_2561 getUsername() {
            return this.username;
        }

        public class_2561 getDisplayname() {
            return this.displayname;
        }

        public void setDisplayname(class_2561 displayname) {
            this.displayname = displayname;
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.NameFormat.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.NameFormat(this.getEntity(), this.getUsername());
        }
    }

    @Cancelable
    public static class BreakSpeed
    extends PlayerEventWrapper {
        private static final class_2338 LEGACY_UNKNOWN = new class_2338(0, -114514, 0);
        private final class_2680 state;
        private final float originalSpeed;
        private float newSpeed = 0.0f;
        private final Optional<class_2338> pos;

        public BreakSpeed(class_1657 player, class_2680 state, float original, @Nullable class_2338 pos) {
            super(player);
            this.state = state;
            this.originalSpeed = original;
            this.setNewSpeed(original);
            this.pos = Optional.ofNullable(pos);
        }

        public BreakSpeed(PlayerEvent.BreakSpeed event) {
            this(event.getEntity(), event.getState(), event.getOriginalSpeed(), event.getPosition().isPresent() ? (class_2338)event.getPosition().get() : null);
            this.setNewSpeed(event.getNewSpeed());
        }

        public class_2680 getState() {
            return this.state;
        }

        public float getOriginalSpeed() {
            return this.originalSpeed;
        }

        public float getNewSpeed() {
            return this.newSpeed;
        }

        public void setNewSpeed(float newSpeed) {
            this.newSpeed = newSpeed;
        }

        public Optional<class_2338> getPosition() {
            return this.pos;
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.BreakSpeed.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.BreakSpeed(this.getEntity(), this.getState(), this.getOriginalSpeed(), this.getPosition().isPresent() ? this.getPosition().get() : null);
        }
    }

    public static class HarvestCheck
    extends PlayerEventWrapper {
        private final class_2680 state;
        private boolean success;

        public HarvestCheck(class_1657 player, class_2680 state, boolean success) {
            super(player);
            this.state = state;
            this.success = success;
        }

        public HarvestCheck(PlayerEvent.HarvestCheck event) {
            this(event.getEntity(), event.getTargetBlock(), event.canHarvest());
        }

        public class_2680 getTargetBlock() {
            return this.state;
        }

        public boolean canHarvest() {
            return this.success;
        }

        public void setCanHarvest(boolean success) {
            this.success = success;
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.HarvestCheck.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.HarvestCheck(this.getEntity(), this.getTargetBlock(), this.canHarvest());
        }
    }
}

