/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.eventwrapper.event.entity.player;

import com.google.common.base.Preconditions;
import io.github.lounode.eventwrapper.event.entity.player.PlayerEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.Cancelable;
import io.github.lounode.eventwrapper.eventbus.api.EventWrapper;
import io.github.lounode.eventwrapper.utils.LogicalSide;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2846;
import net.minecraft.class_3965;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerInteractEventWrapper
extends PlayerEventWrapper {
    private final class_1268 hand;
    private final class_2338 pos;
    @Nullable
    private final class_2350 face;
    private class_1269 cancellationResult = class_1269.field_5811;

    private PlayerInteractEventWrapper(class_1657 player, class_1268 hand, class_2338 pos, @Nullable class_2350 face) {
        super((class_1657)Preconditions.checkNotNull((Object)player, (Object)"Null player in PlayerInteractEvent!"));
        this.hand = (class_1268)Preconditions.checkNotNull((Object)hand, (Object)"Null hand in PlayerInteractEvent!");
        this.pos = (class_2338)Preconditions.checkNotNull((Object)pos, (Object)"Null position in PlayerInteractEvent!");
        this.face = face;
    }

    @NotNull
    public class_1268 getHand() {
        return this.hand;
    }

    @NotNull
    public class_1799 getItemStack() {
        return this.getEntity().method_5998(this.hand);
    }

    @NotNull
    public class_2338 getPos() {
        return this.pos;
    }

    @Nullable
    public class_2350 getFace() {
        return this.face;
    }

    public class_1937 getLevel() {
        return this.getEntity().method_37908();
    }

    public LogicalSide getSide() {
        return this.getLevel().field_9236 ? LogicalSide.CLIENT : LogicalSide.SERVER;
    }

    public class_1269 getCancellationResult() {
        return this.cancellationResult;
    }

    public void setCancellationResult(class_1269 result) {
        this.cancellationResult = result;
    }

    public static Class<? extends Event> getForgeClass() {
        return PlayerInteractEvent.class;
    }

    public PlayerInteractEventWrapper(PlayerInteractEvent event) {
        this(event.getEntity(), event.getHand(), event.getPos(), event.getFace());
    }

    public static class LeftClickEmpty
    extends PlayerInteractEventWrapper {
        public LeftClickEmpty(class_1657 player) {
            super(player, class_1268.field_5808, player.method_24515(), null);
        }

        public LeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
            super(event.getEntity(), event.getHand(), event.getPos(), event.getFace());
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerInteractEvent.LeftClickEmpty.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerInteractEvent.LeftClickEmpty(this.getEntity());
        }
    }

    @Cancelable
    public static class LeftClickBlock
    extends PlayerInteractEventWrapper {
        private EventWrapper.Result useBlock = EventWrapper.Result.DEFAULT;
        private EventWrapper.Result useItem = EventWrapper.Result.DEFAULT;

        public LeftClickBlock(class_1657 player, class_2338 pos, class_2350 face) {
            super(player, class_1268.field_5808, pos, face);
        }

        public EventWrapper.Result getUseBlock() {
            return this.useBlock;
        }

        public EventWrapper.Result getUseItem() {
            return this.useItem;
        }

        public void setUseBlock(EventWrapper.Result triggerBlock) {
            this.useBlock = triggerBlock;
        }

        public void setUseItem(EventWrapper.Result triggerItem) {
            this.useItem = triggerItem;
        }

        @Override
        public void setCanceled(boolean canceled) {
            super.setCanceled(canceled);
            if (canceled) {
                this.useBlock = EventWrapper.Result.DENY;
                this.useItem = EventWrapper.Result.DENY;
            }
        }

        public LeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
            this(event.getEntity(), event.getPos(), event.getFace());
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerInteractEvent.LeftClickBlock.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerInteractEvent.LeftClickBlock(this.getEntity(), this.getPos(), this.getFace());
        }

        public static enum Action {
            START,
            STOP,
            ABORT,
            CLIENT_HOLD;


            public static Action convert(class_2846.class_2847 action) {
                return switch (action) {
                    default -> START;
                    case class_2846.class_2847.field_12968 -> START;
                    case class_2846.class_2847.field_12973 -> STOP;
                    case class_2846.class_2847.field_12971 -> ABORT;
                };
            }
        }
    }

    public static class RightClickEmpty
    extends PlayerInteractEventWrapper {
        public RightClickEmpty(class_1657 player, class_1268 hand) {
            super(player, hand, player.method_24515(), null);
        }

        public RightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
            this(event.getEntity(), event.getHand());
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerInteractEvent.RightClickEmpty.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerInteractEvent.RightClickEmpty(this.getEntity(), this.getHand());
        }
    }

    @Cancelable
    public static class RightClickItem
    extends PlayerInteractEventWrapper {
        public RightClickItem(class_1657 player, class_1268 hand) {
            super(player, hand, player.method_24515(), null);
        }

        public RightClickItem(PlayerInteractEvent.RightClickItem event) {
            this(event.getEntity(), event.getHand());
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerInteractEvent.RightClickItem.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerInteractEvent.RightClickItem(this.getEntity(), this.getHand());
        }
    }

    @Cancelable
    public static class RightClickBlock
    extends PlayerInteractEventWrapper {
        private EventWrapper.Result useBlock = EventWrapper.Result.DEFAULT;
        private EventWrapper.Result useItem = EventWrapper.Result.DEFAULT;
        private class_3965 hitVec;

        public RightClickBlock(class_1657 player, class_1268 hand, class_2338 pos, class_3965 hitVec) {
            super(player, hand, pos, hitVec.method_17780());
            this.hitVec = hitVec;
        }

        public EventWrapper.Result getUseBlock() {
            return this.useBlock;
        }

        public EventWrapper.Result getUseItem() {
            return this.useItem;
        }

        public class_3965 getHitVec() {
            return this.hitVec;
        }

        public void setUseBlock(EventWrapper.Result triggerBlock) {
            this.useBlock = triggerBlock;
        }

        public void setUseItem(EventWrapper.Result triggerItem) {
            this.useItem = triggerItem;
        }

        @Override
        public void setCanceled(boolean canceled) {
            super.setCanceled(canceled);
            if (canceled) {
                this.useBlock = EventWrapper.Result.DENY;
                this.useItem = EventWrapper.Result.DENY;
            }
        }

        public RightClickBlock(PlayerInteractEvent.RightClickBlock event) {
            this(event.getEntity(), event.getHand(), event.getPos(), event.getHitVec());
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerInteractEvent.RightClickBlock.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerInteractEvent.RightClickBlock(this.getEntity(), this.getHand(), this.getPos(), this.getHitVec());
        }
    }

    @Cancelable
    public static class EntityInteract
    extends PlayerInteractEventWrapper {
        private final class_1297 target;

        public EntityInteract(class_1657 player, class_1268 hand, class_1297 target) {
            super(player, hand, target.method_24515(), null);
            this.target = target;
        }

        public class_1297 getTarget() {
            return this.target;
        }

        public EntityInteract(PlayerInteractEvent.EntityInteract event) {
            this(event.getEntity(), event.getHand(), event.getTarget());
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerInteractEvent.EntityInteract.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerInteractEvent.EntityInteract(this.getEntity(), this.getHand(), this.getTarget());
        }
    }

    @Cancelable
    public static class EntityInteractSpecific
    extends PlayerInteractEventWrapper {
        private final class_243 localPos;
        private final class_1297 target;

        public EntityInteractSpecific(class_1657 player, class_1268 hand, class_1297 target, class_243 localPos) {
            super(player, hand, target.method_24515(), null);
            this.localPos = localPos;
            this.target = target;
        }

        public class_243 getLocalPos() {
            return this.localPos;
        }

        public class_1297 getTarget() {
            return this.target;
        }

        public EntityInteractSpecific(PlayerInteractEvent.EntityInteractSpecific event) {
            this(event.getEntity(), event.getHand(), event.getTarget(), event.getLocalPos());
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerInteractEvent.EntityInteractSpecific.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerInteractEvent.EntityInteractSpecific(this.getEntity(), this.getHand(), this.getTarget(), this.getLocalPos());
        }
    }
}

