/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.eventwrapper.event.level;

import com.google.common.collect.ImmutableList;
import io.github.lounode.eventwrapper.EventsWrapper;
import io.github.lounode.eventwrapper.eventbus.api.Cancelable;
import io.github.lounode.eventwrapper.eventbus.api.EventWrapper;
import io.github.lounode.eventwrapper.utils.BlockSnapshot;
import io.github.lounode.eventwrapper.utils.ToolAction;
import io.github.lounode.xplatform.platform.support.CrossPlatform;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2424;
import net.minecraft.class_2680;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CrossPlatform
public class BlockEventWrapper
extends EventWrapper {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugBlockEvent", "false"));
    private final class_1936 level;
    private final class_2338 pos;
    private final class_2680 state;

    public BlockEventWrapper(class_1936 level, class_2338 pos, class_2680 state) {
        this.pos = pos;
        this.level = level;
        this.state = state;
    }

    public class_1936 getLevel() {
        return this.level;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public class_2680 getState() {
        return this.state;
    }

    public BlockEventWrapper(BlockEvent event) {
        this(event.getLevel(), event.getPos(), event.getState());
    }

    public static Class<? extends Event> getForgeClass() {
        return BlockEvent.class;
    }

    @Override
    public Object toForgeEvent() {
        return new BlockEvent(this.getLevel(), this.getPos(), this.getState());
    }

    @CrossPlatform
    @Cancelable
    public static class BlockToolModificationEvent
    extends BlockEventWrapper {
        private final class_1838 context;
        private final ToolAction toolAction;
        private final boolean simulate;
        private class_2680 state;

        public BlockToolModificationEvent(class_2680 originalState, @NotNull class_1838 context, ToolAction toolAction, boolean simulate) {
            super((class_1936)context.method_8045(), context.method_8037(), originalState);
            this.context = context;
            this.state = originalState;
            this.toolAction = toolAction;
            this.simulate = simulate;
        }

        @Nullable
        public class_1657 getPlayer() {
            return this.context.method_8036();
        }

        public class_1799 getHeldItemStack() {
            return this.context.method_8041();
        }

        public ToolAction getToolAction() {
            return this.toolAction;
        }

        public boolean isSimulated() {
            return this.simulate;
        }

        @NotNull
        public class_1838 getContext() {
            return this.context;
        }

        public void setFinalState(@Nullable class_2680 finalState) {
            this.state = finalState;
        }

        public class_2680 getFinalState() {
            return this.state;
        }
    }

    @CrossPlatform
    @Cancelable
    public static class PortalSpawnEvent
    extends BlockEventWrapper {
        private final class_2424 size;

        public PortalSpawnEvent(class_1936 level, class_2338 pos, class_2680 state, class_2424 size) {
            super(level, pos, state);
            this.size = size;
        }

        public class_2424 getPortalSize() {
            return this.size;
        }
    }

    @CrossPlatform
    @Cancelable
    public static class FarmlandTrampleEvent
    extends BlockEventWrapper {
        private final class_1297 entity;
        private final float fallDistance;

        public FarmlandTrampleEvent(class_1937 level, class_2338 pos, class_2680 state, float fallDistance, class_1297 entity) {
            super((class_1936)level, pos, state);
            this.entity = entity;
            this.fallDistance = fallDistance;
        }

        public class_1297 getEntity() {
            return this.entity;
        }

        public float getFallDistance() {
            return this.fallDistance;
        }
    }

    @CrossPlatform
    public static class CropGrowEvent
    extends BlockEventWrapper {
        public CropGrowEvent(class_1937 level, class_2338 pos, class_2680 state) {
            super((class_1936)level, pos, state);
        }

        @CrossPlatform
        public static class Post
        extends CropGrowEvent {
            private final class_2680 originalState;

            public Post(class_1937 level, class_2338 pos, class_2680 original, class_2680 state) {
                super(level, pos, state);
                this.originalState = original;
            }

            public class_2680 getOriginalState() {
                return this.originalState;
            }
        }

        @CrossPlatform
        @EventWrapper.HasResult
        public static class Pre
        extends CropGrowEvent {
            public Pre(class_1937 level, class_2338 pos, class_2680 state) {
                super(level, pos, state);
            }
        }
    }

    @CrossPlatform
    @Cancelable
    public static class FluidPlaceBlockEvent
    extends BlockEventWrapper {
        private final class_2338 liquidPos;
        private class_2680 newState;
        private class_2680 origState;

        public FluidPlaceBlockEvent(class_1936 level, class_2338 pos, class_2338 liquidPos, class_2680 state) {
            super(level, pos, state);
            this.liquidPos = liquidPos;
            this.newState = state;
            this.origState = level.method_8320(pos);
        }

        public class_2338 getLiquidPos() {
            return this.liquidPos;
        }

        public class_2680 getNewState() {
            return this.newState;
        }

        public void setNewState(class_2680 state) {
            this.newState = state;
        }

        public class_2680 getOriginalState() {
            return this.origState;
        }
    }

    @CrossPlatform
    @EventWrapper.HasResult
    public static class CreateFluidSourceEvent
    extends EventWrapper {
        private final class_1937 level;
        private final class_2338 pos;
        private final class_2680 state;

        public CreateFluidSourceEvent(class_1937 level, class_2338 pos, class_2680 state) {
            this.level = level;
            this.pos = pos;
            this.state = state;
        }

        public class_1937 getLevel() {
            return this.level;
        }

        public class_2338 getPos() {
            return this.pos;
        }

        public class_2680 getState() {
            return this.state;
        }
    }

    @CrossPlatform
    @Cancelable
    public static class NeighborNotifyEvent
    extends BlockEventWrapper {
        private final EnumSet<class_2350> notifiedSides;
        private final boolean forceRedstoneUpdate;

        public NeighborNotifyEvent(class_1937 level, class_2338 pos, class_2680 state, EnumSet<class_2350> notifiedSides, boolean forceRedstoneUpdate) {
            super((class_1936)level, pos, state);
            this.notifiedSides = notifiedSides;
            this.forceRedstoneUpdate = forceRedstoneUpdate;
        }

        public EnumSet<class_2350> getNotifiedSides() {
            return this.notifiedSides;
        }

        public boolean getForceRedstoneUpdate() {
            return this.forceRedstoneUpdate;
        }
    }

    @CrossPlatform
    @Cancelable
    public static class EntityMultiPlaceEvent
    extends EntityPlaceEvent {
        private final List<BlockSnapshot> blockSnapshots;

        public EntityMultiPlaceEvent(@NotNull List<BlockSnapshot> blockSnapshots, @NotNull class_2680 placedAgainst, @Nullable class_1297 entity) {
            super(blockSnapshots.get(0), placedAgainst, entity);
            this.blockSnapshots = ImmutableList.copyOf(blockSnapshots);
        }

        public List<BlockSnapshot> getReplacedBlockSnapshots() {
            return this.blockSnapshots;
        }
    }

    @CrossPlatform
    @Cancelable
    public static class EntityPlaceEvent
    extends BlockEventWrapper {
        private final class_1297 entity;
        private final BlockSnapshot blockSnapshot;
        private final class_2680 placedBlock;
        private final class_2680 placedAgainst;

        public EntityPlaceEvent(@NotNull BlockSnapshot blockSnapshot, @NotNull class_2680 placedAgainst, @Nullable class_1297 entity) {
            super(blockSnapshot.getLevel(), blockSnapshot.getPos(), !(entity instanceof class_1657) ? blockSnapshot.getReplacedBlock() : blockSnapshot.getCurrentBlock());
            this.entity = entity;
            this.blockSnapshot = blockSnapshot;
            this.placedBlock = !(entity instanceof class_1657) ? blockSnapshot.getReplacedBlock() : blockSnapshot.getCurrentBlock();
            this.placedAgainst = placedAgainst;
        }

        @Nullable
        public class_1297 getEntity() {
            return this.entity;
        }

        public BlockSnapshot getBlockSnapshot() {
            return this.blockSnapshot;
        }

        public class_2680 getPlacedBlock() {
            return this.placedBlock;
        }

        public class_2680 getPlacedAgainst() {
            return this.placedAgainst;
        }
    }

    @CrossPlatform
    @Cancelable
    public static class BreakEvent
    extends BlockEventWrapper {
        private final class_1657 player;
        private int exp;

        public BreakEvent(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
            super((class_1936)level, pos, state);
            this.player = player;
            if (state == null || !EventsWrapper.getInstance().getHelper().isCorrectToolForDrops(state, player)) {
                this.exp = 0;
            } else {
                class_1799 stack = player.method_6047();
                int fortuneLevel = class_1890.method_8225((class_1887)class_1893.field_9130, (class_1799)stack);
                int n = class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)stack);
            }
        }

        public class_1657 getPlayer() {
            return this.player;
        }

        public int getExpToDrop() {
            return this.isCanceled() ? 0 : this.exp;
        }

        public void setExpToDrop(int exp) {
            this.exp = exp;
        }
    }
}

