/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.eventwrapper.eventbus.api;

import io.github.lounode.eventwrapper.eventbus.api.EventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.ServiceUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_2680;

public interface IPlatformEventHelper {
    public static final Map<Class<?>, Field[]> NON_FINAL_FIELD_CACHE = new ConcurrentHashMap();
    public static final String forgePackageNamePrefix = "net.minecraftforge";
    public static final IPlatformEventHelper INSTANCE = ServiceUtil.findService(IPlatformEventHelper.class, null);

    public void register(Object var1);

    public void unregister(Object var1);

    default public boolean isForge() {
        return false;
    }

    default public boolean isFabric() {
        return false;
    }

    public static void syncEventData(Object from, Object to) {
        if (from == null || to == null) {
            return;
        }
        Class<?> fromClass = from.getClass();
        Class<?> toClass = to.getClass();
        Field[] fromFields = IPlatformEventHelper.getFieldsWithoutFinal(fromClass);
        Field[] toFields = IPlatformEventHelper.getFieldsWithoutFinal(toClass);
        block2: for (Field fromField : fromFields) {
            String name = fromField.getName();
            Class<?> type = fromField.getType();
            try {
                for (Field toField : toFields) {
                    if (toField.getType() != type || !toField.getName().equals(name)) continue;
                    Object value = fromField.get(from);
                    toField.set(to, value);
                    continue block2;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static Field[] getFields(Class<?> clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>(16);
        while (clazz != null) {
            fieldList.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return fieldList.toArray(new Field[0]);
    }

    public static Field[] getFieldsWithoutFinal(Class<?> clazz) {
        return NON_FINAL_FIELD_CACHE.computeIfAbsent(clazz, c -> {
            ArrayList<Field> fieldList = new ArrayList<Field>(16);
            while (c != null) {
                for (Field field : c.getDeclaredFields()) {
                    if (Modifier.isFinal(field.getModifiers())) continue;
                    field.setAccessible(true);
                    fieldList.add(field);
                }
                c = c.getSuperclass();
            }
            return fieldList.toArray(new Field[0]);
        });
    }

    public <T extends EventWrapper> T post(T var1);

    default public boolean isCorrectToolForDrops(class_2680 state, class_1657 player) {
        return false;
    }
}

