/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.eventwrapper.eventbus.api;

import io.github.lounode.eventwrapper.eventbus.EventListenerFactory;
import io.github.lounode.eventwrapper.eventbus.IWrapperListener;
import io.github.lounode.eventwrapper.eventbus.api.EventListener;
import io.github.lounode.eventwrapper.eventbus.api.EventPriority;
import io.github.lounode.eventwrapper.eventbus.api.EventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.SubscribeEventWrapper;
import java.lang.reflect.Method;
import org.objectweb.asm.Type;

public final class SubscribeEventListener
extends EventListener
implements IWrapperListener {
    private final EventListener handler;
    private final SubscribeEventWrapper subInfo;
    private String readable;

    public SubscribeEventListener(Object target, Method method) {
        this.handler = EventListenerFactory.create(method, target);
        this.subInfo = method.getAnnotation(SubscribeEventWrapper.class);
        this.readable = "@SubscribeEvent: " + String.valueOf(target) + " " + method.getName() + Type.getMethodDescriptor((Method)method);
    }

    @Override
    public void invoke(EventWrapper event) {
        if (this.handler != null && (this.subInfo.receiveCanceled() || !event.isCanceled())) {
            this.handler.invoke(event);
        }
    }

    public EventPriority getPriority() {
        return this.subInfo.priority();
    }

    public String toString() {
        return this.readable;
    }

    @Override
    public EventListener getWithoutCheck() {
        return this.handler;
    }
}

