/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.eventwrapper.fabric;

import io.github.lounode.eventwrapper.EventsWrapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.impl.ModContainerImpl;
import net.fabricmc.loader.impl.util.log.Log;
import net.fabricmc.loader.impl.util.log.LogCategory;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class AutoEventSubscriberRegistryFabric {
    public static final LogCategory CATEGORY = LogCategory.create((String[])new String[]{"Event Wrapper"});
    public static final boolean ENABLED = System.getProperty("fabric-api.gametest") != null;
    private static final String testPackage = "io.github.lounode.eventwrapper.test";

    public static void register(ModContainerImpl container) {
        final ArrayList annotatedClasses = new ArrayList();
        List rootPaths = container.getRootPaths();
        String modId = container.getMetadata().getId();
        for (Path rootPath : rootPaths) {
            try {
                Files.walk(rootPath, new FileVisitOption[0]).filter(p -> p.toString().endsWith(".class")).forEach(classFile -> {
                    final String className = AutoEventSubscriberRegistryFabric.convertToClassName(rootPath, classFile);
                    if (!ENABLED && className.startsWith(testPackage)) {
                        return;
                    }
                    try (InputStream is = Files.newInputStream(classFile, new OpenOption[0]);){
                        ClassReader reader = new ClassReader(is);
                        reader.accept(new ClassVisitor(589824){

                            public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                                if (descriptor.contains("EventBusSubscriberWrapper")) {
                                    annotatedClasses.add(className);
                                    try {
                                        Class<?> clazz = Class.forName(className, false, ((Object)((Object)this)).getClass().getClassLoader());
                                        EventsWrapper.register(clazz);
                                    }
                                    catch (RuntimeException e) {
                                        Log.error((LogCategory)CATEGORY, (String)"Error when register event in {}.", (Object[])new Object[]{className});
                                    }
                                    catch (ClassNotFoundException e) {
                                        Log.error((LogCategory)CATEGORY, (String)"Failed to load mod class {} for @EventBusSubscriber annotation", (Object[])new Object[]{className, e});
                                    }
                                    catch (NoClassDefFoundError e) {
                                        Log.error((LogCategory)CATEGORY, (String)"Class {} was not found", (Object[])new Object[]{className, e});
                                    }
                                }
                                return null;
                            }
                        }, 7);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
            }
            catch (IOException e) {
                Log.warn((LogCategory)CATEGORY, (String)("Failed to scan classes for mod " + modId), (Throwable)e);
            }
        }
        Log.info((LogCategory)CATEGORY, (String)"Registered %d listeners for: %s", (Object[])new Object[]{annotatedClasses.size(), modId});
    }

    private static String convertToClassName(Path root, Path classFile) {
        return root.relativize(classFile).toString().replace(".class", "").replace(File.separatorChar, '.').replace('/', '.');
    }
}

