/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.eventwrapper.fabric;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.fabricmc.loader.impl.ModContainerImpl;
import net.fabricmc.loader.impl.entrypoint.EntrypointStorage;
import net.fabricmc.loader.impl.metadata.EntrypointMetadata;
import net.fabricmc.loader.impl.util.log.Log;
import net.fabricmc.loader.impl.util.log.LogCategory;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class AutoRegisterGameTest {
    public static final LogCategory CATEGORY = LogCategory.create((String[])new String[]{"Event Wrapper"});

    public static void register(ModContainerImpl container) {
        List rootPaths = container.getRootPaths();
        String targetPackage = "io.github.lounode.eventwrapper.test";
        for (Path rootPath : rootPaths) {
            try {
                Files.walk(rootPath, new FileVisitOption[0]).filter(p -> p.toString().endsWith(".class")).forEach(classFile -> {
                    final String className = AutoRegisterGameTest.convertToClassName(rootPath, classFile);
                    if (!className.startsWith(targetPackage)) {
                        return;
                    }
                    try (InputStream is = Files.newInputStream(classFile, new OpenOption[0]);){
                        ClassReader reader = new ClassReader(is);
                        reader.accept(new ClassVisitor(589824){

                            public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                                if (descriptor.contains("GameTestHolder")) {
                                    try {
                                        Class<?> clazz = Class.forName(className, false, ((Object)((Object)this)).getClass().getClassLoader());
                                        AutoRegisterGameTest.registerGameTests(clazz);
                                    }
                                    catch (ClassNotFoundException ignored) {
                                        Log.warn((LogCategory)CATEGORY, (String)("Failed to load GameTest class: " + className));
                                    }
                                }
                                return null;
                            }
                        }, 7);
                    }
                    catch (IOException ignored) {
                        Log.warn((LogCategory)CATEGORY, (String)("Error reading class file: " + String.valueOf(classFile)), (Throwable)ignored);
                    }
                });
            }
            catch (IOException e) {
                Log.warn((LogCategory)CATEGORY, (String)("Failed to scan rootPath: " + String.valueOf(rootPath)), (Throwable)e);
            }
        }
    }

    private static String convertToClassName(Path root, Path classFile) {
        return root.relativize(classFile).toString().replace(".class", "").replace(File.separatorChar, '.').replace('/', '.');
    }

    private static void registerGameTests(Class<?> clazz) {
        FabricLoader loader = FabricLoader.getInstance();
        ModContainerImpl modContainer = (ModContainerImpl)loader.getModContainer("eventwrapper").orElseThrow();
        try {
            Field field = FabricLoaderImpl.class.getDeclaredField("entrypointStorage");
            Field adptMapField = FabricLoaderImpl.class.getDeclaredField("adapterMap");
            field.setAccessible(true);
            adptMapField.setAccessible(true);
            EntrypointStorage entrypointStorage = (EntrypointStorage)field.get(loader);
            Map adptmap = (Map)adptMapField.get(loader);
            entrypointStorage.add(modContainer, "fabric-gametest", (EntrypointMetadata)new EntrypointMetadataImpl("default", clazz.getName()), adptmap);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static final class EntrypointMetadataImpl
    implements EntrypointMetadata {
        private final String adapter;
        private final String value;

        EntrypointMetadataImpl(String adapter, String value) {
            this.adapter = adapter;
            this.value = value;
        }

        public String getAdapter() {
            return this.adapter;
        }

        public String getValue() {
            return this.value;
        }
    }
}

