/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.eventwrapper.fabric;

import io.github.lounode.eventwrapper.EventsWrapper;
import io.github.lounode.eventwrapper.event.PlayLevelSoundEventWrapper;
import io.github.lounode.eventwrapper.event.entity.living.LivingDeathEventWrapper;
import io.github.lounode.eventwrapper.event.entity.living.MobEffectEventWrapper;
import io.github.lounode.eventwrapper.event.entity.living.ShieldBlockEventWrapper;
import io.github.lounode.eventwrapper.event.entity.player.AnvilRepairEventWrapper;
import io.github.lounode.eventwrapper.event.entity.player.EntityItemPickupEventWrapper;
import io.github.lounode.eventwrapper.event.entity.player.PlayerEventWrapper;
import io.github.lounode.eventwrapper.event.entity.player.PlayerInteractEventWrapper;
import io.github.lounode.eventwrapper.event.furnace.FurnaceFuelBurnTimeEventWrapper;
import io.github.lounode.eventwrapper.event.level.LevelEventWrapper;
import io.github.lounode.eventwrapper.event.server.ServerAboutToStartEventWrapper;
import io.github.lounode.eventwrapper.event.server.ServerStartedEventWrapper;
import io.github.lounode.eventwrapper.event.server.ServerStartingEventWrapper;
import io.github.lounode.eventwrapper.event.server.ServerStoppedEventWrapper;
import io.github.lounode.eventwrapper.event.server.ServerStoppingEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.EventWrapper;
import java.io.File;
import java.util.Map;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.impl.content.registry.FuelRegistryImpl;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2846;
import net.minecraft.class_29;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3956;
import net.minecraft.class_3965;
import net.minecraft.class_5268;
import net.minecraft.class_5321;
import net.minecraft.class_5483;
import net.minecraft.class_6012;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventWrapperHooks {
    public static class_1269 onInteractEntityAt(class_1657 player, class_1297 entity, class_239 ray, class_1268 hand) {
        class_243 vec3d = ray.method_17784().method_1020(entity.method_19538());
        return EventWrapperHooks.onInteractEntityAt(player, entity, vec3d, hand);
    }

    public static class_1269 onInteractEntityAt(class_1657 player, class_1297 entity, class_243 vec3d, class_1268 hand) {
        PlayerInteractEventWrapper.EntityInteractSpecific wrapper = new PlayerInteractEventWrapper.EntityInteractSpecific(player, hand, entity, vec3d);
        EventsWrapper.post(wrapper);
        return wrapper.isCanceled() ? wrapper.getCancellationResult() : null;
    }

    public static class_1269 onInteractEntity(class_1657 player, class_1297 entity, class_1268 hand) {
        PlayerInteractEventWrapper.EntityInteract wrapper = new PlayerInteractEventWrapper.EntityInteract(player, hand, entity);
        EventsWrapper.post(wrapper);
        return wrapper.isCanceled() ? wrapper.getCancellationResult() : null;
    }

    public static class_1269 onItemRightClick(class_1657 player, class_1268 hand) {
        PlayerInteractEventWrapper.RightClickItem evt = new PlayerInteractEventWrapper.RightClickItem(player, hand);
        EventsWrapper.post(evt);
        return evt.isCanceled() ? evt.getCancellationResult() : null;
    }

    public static PlayerInteractEventWrapper.LeftClickBlock onLeftClickBlock(class_1657 player, class_2338 pos, class_2350 face, class_2846.class_2847 action) {
        PlayerInteractEventWrapper.LeftClickBlock evt = new PlayerInteractEventWrapper.LeftClickBlock(player, pos, face);
        EventsWrapper.post(evt);
        return evt;
    }

    public static PlayerInteractEventWrapper.RightClickBlock onRightClickBlock(class_1657 player, class_1268 hand, class_2338 pos, class_3965 hitVec) {
        PlayerInteractEventWrapper.RightClickBlock evt = new PlayerInteractEventWrapper.RightClickBlock(player, hand, pos, hitVec);
        EventsWrapper.post(evt);
        return evt;
    }

    public static void onEmptyClick(class_1657 player, class_1268 hand) {
        EventsWrapper.post(new PlayerInteractEventWrapper.RightClickEmpty(player, hand));
    }

    public static void onEmptyLeftClick(class_1657 player) {
        EventsWrapper.post(new PlayerInteractEventWrapper.LeftClickEmpty(player));
    }

    public static boolean isCorrectToolForDrops(@NotNull class_2680 state, @NotNull class_1657 player) {
        PlayerEventWrapper.HarvestCheck event = new PlayerEventWrapper.HarvestCheck(player, state, true);
        EventsWrapper.post(event);
        return event.canHarvest();
    }

    public static class_2561 getPlayerDisplayName(class_1657 player, class_2561 username) {
        PlayerEventWrapper.NameFormat event = new PlayerEventWrapper.NameFormat(player, username);
        EventsWrapper.post(event);
        return event.getDisplayname();
    }

    public static class_2561 getPlayerTabListDisplayName(class_1657 player) {
        PlayerEventWrapper.TabListNameFormat event = new PlayerEventWrapper.TabListNameFormat(player);
        EventsWrapper.post(event);
        return event.getDisplayName();
    }

    public static void onPlayerClone(class_1657 player, class_1657 oldPlayer, boolean wasDeath) {
        EventsWrapper.post(new PlayerEventWrapper.Clone(player, oldPlayer, wasDeath));
    }

    public static void onStartEntityTracking(class_1297 entity, class_1657 player) {
        EventsWrapper.post(new PlayerEventWrapper.StartTracking(player, entity));
    }

    public static void onStopEntityTracking(class_1297 entity, class_1657 player) {
        EventsWrapper.post(new PlayerEventWrapper.StopTracking(player, entity));
    }

    public static void firePlayerLoadingEvent(class_1657 player, File playerDirectory, String uuidString) {
        EventsWrapper.post(new PlayerEventWrapper.LoadFromFile(player, playerDirectory, uuidString));
    }

    public static void firePlayerLoadingEvent(class_1657 player, class_29 playerFileData, String uuidString) {
        EventsWrapper.post(new PlayerEventWrapper.LoadFromFile(player, playerFileData.field_144, uuidString));
    }

    public static void firePlayerSavingEvent(class_1657 player, File playerDirectory, String uuidString) {
        EventsWrapper.post(new PlayerEventWrapper.SaveToFile(player, playerDirectory, uuidString));
    }

    public static int onItemPickup(class_1542 entityItem, class_1657 player) {
        EntityItemPickupEventWrapper event = new EntityItemPickupEventWrapper(player, entityItem);
        if (event.isCanceled()) {
            return -1;
        }
        return event.getResult() == EventWrapper.Result.ALLOW ? 1 : 0;
    }

    public static void firePlayerItemPickupEvent(class_1657 player, class_1542 item, class_1799 clone) {
        EventsWrapper.post(new PlayerEventWrapper.ItemPickupEvent(player, item, clone));
    }

    public static void firePlayerCraftingEvent(class_1657 player, class_1799 crafted, class_1263 craftMatrix) {
        EventsWrapper.post(new PlayerEventWrapper.ItemCraftedEvent(player, crafted, craftMatrix));
    }

    public static void firePlayerSmeltedEvent(class_1657 player, class_1799 smelted) {
        EventsWrapper.post(new PlayerEventWrapper.ItemSmeltedEvent(player, smelted));
    }

    public static void firePlayerChangedDimensionEvent(class_1657 player, class_5321<class_1937> fromDim, class_5321<class_1937> toDim) {
        EventsWrapper.post(new PlayerEventWrapper.PlayerChangedDimensionEvent(player, fromDim, toDim));
    }

    public static void firePlayerLoggedIn(class_1657 player) {
        EventsWrapper.post(new PlayerEventWrapper.PlayerLoggedInEvent(player));
    }

    public static void firePlayerLoggedOut(class_1657 player) {
        EventsWrapper.post(new PlayerEventWrapper.PlayerLoggedOutEvent(player));
    }

    public static void firePlayerRespawnEvent(class_1657 player, boolean endConquered) {
        EventsWrapper.post(new PlayerEventWrapper.PlayerRespawnEvent(player, endConquered));
    }

    @Nullable
    public static class_1934 onChangeGameType(class_1657 player, class_1934 currentGameType, class_1934 newGameType) {
        if (currentGameType != newGameType) {
            PlayerEventWrapper.PlayerChangeGameModeEvent evt = new PlayerEventWrapper.PlayerChangeGameModeEvent(player, currentGameType, newGameType);
            EventsWrapper.post(evt);
            return evt.isCanceled() ? null : evt.getNewGameMode();
        }
        return newGameType;
    }

    public static int getBurnTime(class_1799 stack, @Nullable class_3956<?> recipeType) {
        if (stack.method_7960()) {
            return 0;
        }
        class_1792 item = stack.method_7909();
        Map map = ((FuelRegistryImpl)FuelRegistry.INSTANCE).getFuelTimes();
        Integer burnTime = map.getOrDefault(item, null);
        int time = burnTime == null ? 0 : burnTime;
        return EventWrapperHooks.getItemBurnTime(stack, time, recipeType);
    }

    public static int getItemBurnTime(@NotNull class_1799 itemStack, int burnTime, @Nullable class_3956<?> recipeType) {
        FurnaceFuelBurnTimeEventWrapper event = new FurnaceFuelBurnTimeEventWrapper(itemStack, burnTime, recipeType);
        EventsWrapper.post(event);
        class_1792 item = itemStack.method_7909();
        if (event.isCanceled()) {
            FuelRegistry.INSTANCE.remove((class_1935)item);
            FuelRegistry.INSTANCE.add((class_1935)item, (Object)event.getBurnTime());
        }
        return event.getBurnTime();
    }

    public static void onServerStarting(MinecraftServer minecraftServer) {
        EventsWrapper.post(new ServerStartingEventWrapper(minecraftServer));
    }

    public static void onServerStarted(MinecraftServer minecraftServer) {
        EventsWrapper.post(new ServerStartedEventWrapper(minecraftServer));
    }

    public static void onServerStopping(MinecraftServer minecraftServer) {
        EventsWrapper.post(new ServerStoppingEventWrapper(minecraftServer));
    }

    public static void onServerStopped(MinecraftServer minecraftServer) {
        EventsWrapper.post(new ServerStoppedEventWrapper(minecraftServer));
    }

    public static void onServerAboutToStart(MinecraftServer minecraftServer) {
        EventsWrapper.post(new ServerAboutToStartEventWrapper(minecraftServer));
    }

    public static float onAnvilRepair(class_1657 player, @NotNull class_1799 output, @NotNull class_1799 left, @NotNull class_1799 right) {
        AnvilRepairEventWrapper e = new AnvilRepairEventWrapper(player, left, right, output);
        EventsWrapper.post(e);
        return e.getBreakChance();
    }

    public static void onMobEffectExpired(class_1309 entity, class_1293 mobEffectInstance) {
        EventsWrapper.post(new MobEffectEventWrapper.Expired(entity, mobEffectInstance));
    }

    public static PlayLevelSoundEventWrapper.AtEntity onPlaySoundAtEntity(class_1297 entity, class_6880<class_3414> name, class_3419 category, float volume, float pitch) {
        PlayLevelSoundEventWrapper.AtEntity event = new PlayLevelSoundEventWrapper.AtEntity(entity, name, category, volume, pitch);
        EventsWrapper.post(event);
        return event;
    }

    public static PlayLevelSoundEventWrapper.AtPosition onPlaySoundAtPosition(class_1937 level, double x, double y, double z, class_6880<class_3414> name, class_3419 category, float volume, float pitch) {
        PlayLevelSoundEventWrapper.AtPosition event = new PlayLevelSoundEventWrapper.AtPosition(level, new class_243(x, y, z), name, category, volume, pitch);
        EventsWrapper.post(event);
        return event;
    }

    public static boolean onLivingDeath(class_1309 entity, class_1282 src) {
        LivingDeathEventWrapper event = new LivingDeathEventWrapper(entity, src);
        EventsWrapper.post(event);
        return event.isCanceled();
    }

    public static void onLevelLoad(class_1937 level) {
        EventsWrapper.post(new LevelEventWrapper.Load((class_1936)level));
    }

    public static void onLevelUnload(class_1937 level) {
        EventsWrapper.post(new LevelEventWrapper.Unload((class_1936)level));
    }

    public static void onLevelSave(class_1937 level) {
        EventsWrapper.post(new LevelEventWrapper.Save((class_1936)level));
    }

    public static boolean onCreateWorldSpawn(class_1937 level, class_5268 settings) {
        LevelEventWrapper.CreateSpawnPosition event = new LevelEventWrapper.CreateSpawnPosition((class_1936)level, settings);
        return event.isCanceled();
    }

    public static class_6012<class_5483.class_1964> getPotentialSpawns(class_1936 level, class_1311 category, class_2338 pos, class_6012<class_5483.class_1964> oldList) {
        LevelEventWrapper.PotentialSpawns event = new LevelEventWrapper.PotentialSpawns(level, category, pos, oldList);
        if (event.isCanceled()) {
            return class_6012.method_34990();
        }
        return class_6012.method_34988(event.getSpawnerDataList());
    }

    public static ShieldBlockEventWrapper onShieldBlock(class_1309 blocker, class_1282 source, float blocked) {
        ShieldBlockEventWrapper e = new ShieldBlockEventWrapper(blocker, source, blocked);
        EventsWrapper.post(e);
        return e;
    }
}

