/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.eventwrapper.event.entity;

import io.github.lounode.eventwrapper.event.entity.EntityEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.Cancelable;
import java.util.Objects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

@Cancelable
public class ProjectileImpactEventWrapper
extends EntityEventWrapper {
    private final HitResult ray;
    private final Projectile projectile;
    private ImpactResult result = ImpactResult.DEFAULT;

    public ProjectileImpactEventWrapper(Projectile projectile, HitResult ray) {
        super((Entity)projectile);
        this.ray = ray;
        this.projectile = projectile;
    }

    public ProjectileImpactEventWrapper(ProjectileImpactEvent event) {
        this(event.getProjectile(), event.getRayTraceResult());
    }

    @Override
    @Deprecated(forRemoval=true, since="1.20.1")
    public void setCanceled(boolean cancel) {
        super.setCanceled(cancel);
    }

    public HitResult getRayTraceResult() {
        return this.ray;
    }

    public Projectile getProjectile() {
        return this.projectile;
    }

    public void setImpactResult(@NotNull ImpactResult newResult) {
        this.result = Objects.requireNonNull(newResult, "ImpactResult cannot be null");
    }

    public ImpactResult getImpactResult() {
        return this.result;
    }

    public static Class<? extends Event> getForgeClass() {
        return ProjectileImpactEvent.class;
    }

    @Override
    public Object toForgeEvent() {
        return new ProjectileImpactEvent(this.getProjectile(), this.getRayTraceResult());
    }

    public static enum ImpactResult {
        DEFAULT,
        SKIP_ENTITY,
        STOP_AT_CURRENT,
        STOP_AT_CURRENT_NO_DAMAGE;

    }
}

