/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.eventwrapper.event.entity.living;

import io.github.lounode.eventwrapper.event.entity.EntityEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.Cancelable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public abstract class LivingEventWrapper
extends EntityEventWrapper {
    private final LivingEntity livingEntity;

    public LivingEventWrapper(LivingEntity entity) {
        super((Entity)entity);
        this.livingEntity = entity;
    }

    public LivingEventWrapper(LivingEvent event) {
        this(event.getEntity());
    }

    public LivingEntity getEntity() {
        return this.livingEntity;
    }

    public static Class<? extends Event> getForgeClass() {
        return LivingEvent.class;
    }

    public static class LivingVisibilityEvent
    extends LivingEventWrapper {
        private double visibilityModifier;
        @Nullable
        private final Entity lookingEntity;

        public LivingVisibilityEvent(LivingEntity livingEntity, @Nullable Entity lookingEntity, double originalMultiplier) {
            super(livingEntity);
            this.visibilityModifier = originalMultiplier;
            this.lookingEntity = lookingEntity;
        }

        public LivingVisibilityEvent(LivingEvent.LivingVisibilityEvent event) {
            this(event.getEntity(), event.getLookingEntity(), event.getVisibilityModifier());
        }

        public void modifyVisibility(double mod) {
            this.visibilityModifier *= mod;
        }

        public double getVisibilityModifier() {
            return this.visibilityModifier;
        }

        @Nullable
        public Entity getLookingEntity() {
            return this.lookingEntity;
        }

        public static Class<? extends Event> getForgeClass() {
            return LivingEvent.LivingVisibilityEvent.class;
        }
    }

    public static class LivingJumpEvent
    extends LivingEventWrapper {
        public LivingJumpEvent(LivingEntity e) {
            super(e);
        }

        public LivingJumpEvent(LivingEvent.LivingJumpEvent event) {
            this(event.getEntity());
        }

        public static Class<? extends Event> getForgeClass() {
            return LivingEvent.LivingJumpEvent.class;
        }
    }

    @Cancelable
    public static class LivingTickEvent
    extends LivingEventWrapper {
        public LivingTickEvent(LivingEntity e) {
            super(e);
        }

        public LivingTickEvent(LivingEvent.LivingTickEvent event) {
            this(event.getEntity());
        }

        public static Class<? extends Event> getForgeClass() {
            return LivingEvent.LivingTickEvent.class;
        }
    }
}

