/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.eventwrapper.event.entity.living;

import io.github.lounode.eventwrapper.event.entity.living.LivingEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.Cancelable;
import io.github.lounode.eventwrapper.eventbus.api.EventWrapper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobEffectEventWrapper
extends LivingEventWrapper {
    @Nullable
    protected final MobEffectInstance effectInstance;

    public MobEffectEventWrapper(LivingEntity living, MobEffectInstance effectInstance) {
        super(living);
        this.effectInstance = effectInstance;
    }

    public MobEffectEventWrapper(MobEffectEvent event) {
        this(event.getEntity(), event.getEffectInstance());
    }

    @Nullable
    public MobEffectInstance getEffectInstance() {
        return this.effectInstance;
    }

    public static Class<? extends Event> getForgeClass() {
        return MobEffectEvent.class;
    }

    @Override
    public Object toForgeEvent() {
        return new MobEffectEvent(this.getEntity(), this.getEffectInstance());
    }

    public static class Expired
    extends MobEffectEventWrapper {
        public Expired(LivingEntity living, MobEffectInstance effectInstance) {
            super(living, effectInstance);
        }

        public Expired(MobEffectEvent.Expired event) {
            this(event.getEntity(), event.getEffectInstance());
        }

        public static Class<? extends Event> getForgeClass() {
            return MobEffectEvent.Expired.class;
        }

        @Override
        public Object toForgeEvent() {
            return new MobEffectEvent.Expired(this.getEntity(), this.getEffectInstance());
        }
    }

    public static class Added
    extends MobEffectEventWrapper {
        private final MobEffectInstance oldEffectInstance;
        private final Entity source;

        public Added(LivingEntity living, MobEffectInstance oldEffectInstance, MobEffectInstance newEffectInstance, Entity source) {
            super(living, newEffectInstance);
            this.oldEffectInstance = oldEffectInstance;
            this.source = source;
        }

        public Added(MobEffectEvent.Added event) {
            this(event.getEntity(), event.getOldEffectInstance(), event.getEffectInstance(), event.getEffectSource());
        }

        @Override
        @NotNull
        public MobEffectInstance getEffectInstance() {
            return super.getEffectInstance();
        }

        @Nullable
        public MobEffectInstance getOldEffectInstance() {
            return this.oldEffectInstance;
        }

        @Nullable
        public Entity getEffectSource() {
            return this.source;
        }

        public static Class<? extends Event> getForgeClass() {
            return MobEffectEvent.Added.class;
        }

        @Override
        public Object toForgeEvent() {
            return new MobEffectEvent.Added(this.getEntity(), this.getOldEffectInstance(), this.getEffectInstance(), this.getEffectSource());
        }
    }

    @EventWrapper.HasResult
    public static class Applicable
    extends MobEffectEventWrapper {
        public Applicable(LivingEntity living, @NotNull MobEffectInstance effectInstance) {
            super(living, effectInstance);
        }

        public Applicable(MobEffectEvent.Applicable event) {
            this(event.getEntity(), event.getEffectInstance());
        }

        @Override
        @NotNull
        public MobEffectInstance getEffectInstance() {
            return super.getEffectInstance();
        }

        public static Class<? extends Event> getForgeClass() {
            return MobEffectEvent.Applicable.class;
        }

        @Override
        public Object toForgeEvent() {
            return new MobEffectEvent.Applicable(this.getEntity(), this.getEffectInstance());
        }
    }

    @Cancelable
    public static class Remove
    extends MobEffectEventWrapper {
        private final MobEffect effect;

        public Remove(LivingEntity living, MobEffect effect) {
            super(living, living.m_21124_(effect));
            this.effect = effect;
        }

        public Remove(LivingEntity living, MobEffectInstance effectInstance) {
            super(living, effectInstance);
            this.effect = effectInstance.m_19544_();
        }

        public Remove(MobEffectEvent.Remove event) {
            this(event.getEntity(), event.getEffect());
        }

        public MobEffect getEffect() {
            return this.effect;
        }

        @Override
        @Nullable
        public MobEffectInstance getEffectInstance() {
            return super.getEffectInstance();
        }

        public static Class<? extends Event> getForgeClass() {
            return MobEffectEvent.Remove.class;
        }

        @Override
        public Object toForgeEvent() {
            return new MobEffectEvent.Remove(this.getEntity(), this.getEffectInstance());
        }
    }
}

