/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.eventwrapper.event.entity.player;

import io.github.lounode.eventwrapper.event.entity.player.PlayerEventWrapper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public class AnvilRepairEventWrapper
extends PlayerEventWrapper {
    @NotNull
    private final ItemStack left;
    @NotNull
    private final ItemStack right;
    @NotNull
    private final ItemStack output;
    private float breakChance;

    public AnvilRepairEventWrapper(Player player, @NotNull ItemStack left, @NotNull ItemStack right, @NotNull ItemStack output) {
        super(player);
        this.output = output;
        this.left = left;
        this.right = right;
        this.setBreakChance(0.12f);
    }

    @NotNull
    public ItemStack getOutput() {
        return this.output;
    }

    @NotNull
    public ItemStack getLeft() {
        return this.left;
    }

    @NotNull
    public ItemStack getRight() {
        return this.right;
    }

    public float getBreakChance() {
        return this.breakChance;
    }

    public void setBreakChance(float breakChance) {
        this.breakChance = breakChance;
    }

    public AnvilRepairEventWrapper(AnvilRepairEvent event) {
        this(event.getEntity(), event.getLeft(), event.getRight(), event.getOutput());
        this.setBreakChance(event.getBreakChance());
    }

    public static Class<? extends Event> getForgeClass() {
        return AnvilRepairEvent.class;
    }

    @Override
    public Object toForgeEvent() {
        AnvilRepairEvent event = new AnvilRepairEvent(this.getEntity(), this.getLeft(), this.getRight(), this.getOutput());
        event.setBreakChance(this.getBreakChance());
        return event;
    }
}

