/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.eventwrapper.event.entity.player;

import io.github.lounode.eventwrapper.event.entity.living.LivingEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.Cancelable;
import java.io.File;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PlayerEventWrapper
extends LivingEventWrapper {
    private final Player player;

    public PlayerEventWrapper(Player player) {
        super((LivingEntity)player);
        this.player = player;
    }

    public PlayerEventWrapper(PlayerEvent event) {
        this(event.getEntity());
    }

    public Player getEntity() {
        return this.player;
    }

    public static Class<? extends Event> getForgeClass() {
        return PlayerEvent.class;
    }

    @Cancelable
    public static class PlayerChangeGameModeEvent
    extends PlayerEventWrapper {
        private final GameType currentGameMode;
        private GameType newGameMode;

        public PlayerChangeGameModeEvent(Player player, GameType currentGameMode, GameType newGameMode) {
            super(player);
            this.currentGameMode = currentGameMode;
            this.newGameMode = newGameMode;
        }

        public PlayerChangeGameModeEvent(PlayerEvent.PlayerChangeGameModeEvent event) {
            this(event.getEntity(), event.getCurrentGameMode(), event.getNewGameMode());
        }

        public GameType getCurrentGameMode() {
            return this.currentGameMode;
        }

        public GameType getNewGameMode() {
            return this.newGameMode;
        }

        public void setNewGameMode(GameType newGameMode) {
            this.newGameMode = newGameMode;
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.PlayerChangeGameModeEvent.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.PlayerChangeGameModeEvent(this.getEntity(), this.getCurrentGameMode(), this.getNewGameMode());
        }
    }

    public static class PlayerChangedDimensionEvent
    extends PlayerEventWrapper {
        private final ResourceKey<Level> fromDim;
        private final ResourceKey<Level> toDim;

        public PlayerChangedDimensionEvent(Player player, ResourceKey<Level> fromDim, ResourceKey<Level> toDim) {
            super(player);
            this.fromDim = fromDim;
            this.toDim = toDim;
        }

        public PlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
            this(event.getEntity(), (ResourceKey<Level>)event.getFrom(), (ResourceKey<Level>)event.getTo());
        }

        public ResourceKey<Level> getFrom() {
            return this.fromDim;
        }

        public ResourceKey<Level> getTo() {
            return this.toDim;
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.PlayerChangedDimensionEvent.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.PlayerChangedDimensionEvent(this.getEntity(), this.getFrom(), this.getTo());
        }
    }

    public static class PlayerRespawnEvent
    extends PlayerEventWrapper {
        private final boolean endConquered;

        public PlayerRespawnEvent(Player player, boolean endConquered) {
            super(player);
            this.endConquered = endConquered;
        }

        public PlayerRespawnEvent(PlayerEvent.PlayerRespawnEvent event) {
            this(event.getEntity(), event.isEndConquered());
        }

        public boolean isEndConquered() {
            return this.endConquered;
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.PlayerRespawnEvent.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.PlayerRespawnEvent(this.getEntity(), this.isEndConquered());
        }
    }

    public static class PlayerLoggedOutEvent
    extends PlayerEventWrapper {
        public PlayerLoggedOutEvent(Player player) {
            super(player);
        }

        public PlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
            this(event.getEntity());
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.PlayerLoggedOutEvent.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.PlayerLoggedOutEvent(this.getEntity());
        }
    }

    public static class PlayerLoggedInEvent
    extends PlayerEventWrapper {
        public PlayerLoggedInEvent(Player player) {
            super(player);
        }

        public PlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
            this(event.getEntity());
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.PlayerLoggedInEvent.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.PlayerLoggedInEvent(this.getEntity());
        }
    }

    public static class ItemSmeltedEvent
    extends PlayerEventWrapper {
        @NotNull
        private final ItemStack smelting;

        public ItemSmeltedEvent(Player player, @NotNull ItemStack crafting) {
            super(player);
            this.smelting = crafting;
        }

        public ItemSmeltedEvent(PlayerEvent.ItemSmeltedEvent event) {
            this(event.getEntity(), event.getSmelting());
        }

        @NotNull
        public ItemStack getSmelting() {
            return this.smelting;
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.ItemSmeltedEvent.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.ItemSmeltedEvent(this.getEntity(), this.getSmelting());
        }
    }

    public static class ItemCraftedEvent
    extends PlayerEventWrapper {
        @NotNull
        private final ItemStack crafting;
        private final Container craftMatrix;

        public ItemCraftedEvent(Player player, @NotNull ItemStack crafting, Container craftMatrix) {
            super(player);
            this.crafting = crafting;
            this.craftMatrix = craftMatrix;
        }

        public ItemCraftedEvent(PlayerEvent.ItemCraftedEvent event) {
            this(event.getEntity(), event.getCrafting(), event.getInventory());
        }

        @NotNull
        public ItemStack getCrafting() {
            return this.crafting;
        }

        public Container getInventory() {
            return this.craftMatrix;
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.ItemCraftedEvent.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.ItemCraftedEvent(this.getEntity(), this.getCrafting(), this.getInventory());
        }
    }

    public static class ItemPickupEvent
    extends PlayerEventWrapper {
        private final ItemEntity originalEntity;
        private final ItemStack stack;

        public ItemPickupEvent(Player player, ItemEntity entPickedUp, ItemStack stack) {
            super(player);
            this.originalEntity = entPickedUp;
            this.stack = stack;
        }

        public ItemPickupEvent(PlayerEvent.ItemPickupEvent event) {
            this(event.getEntity(), event.getOriginalEntity(), event.getStack());
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public ItemEntity getOriginalEntity() {
            return this.originalEntity;
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.ItemPickupEvent.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.ItemPickupEvent(this.getEntity(), this.getOriginalEntity(), this.getStack());
        }
    }

    public static class SaveToFile
    extends PlayerEventWrapper {
        private final File playerDirectory;
        private final String playerUUID;

        public SaveToFile(Player player, File originDirectory, String playerUUID) {
            super(player);
            this.playerDirectory = originDirectory;
            this.playerUUID = playerUUID;
        }

        public SaveToFile(PlayerEvent.SaveToFile event) {
            this(event.getEntity(), event.getPlayerDirectory(), event.getPlayerUUID());
        }

        public File getPlayerFile(String suffix) {
            if ("dat".equals(suffix)) {
                throw new IllegalArgumentException("The suffix 'dat' is reserved");
            }
            return new File(this.getPlayerDirectory(), this.getPlayerUUID() + "." + suffix);
        }

        public File getPlayerDirectory() {
            return this.playerDirectory;
        }

        public String getPlayerUUID() {
            return this.playerUUID;
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.SaveToFile.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.SaveToFile(this.getEntity(), this.getPlayerDirectory(), this.getPlayerUUID());
        }
    }

    public static class LoadFromFile
    extends PlayerEventWrapper {
        private final File playerDirectory;
        private final String playerUUID;

        public LoadFromFile(Player player, File originDirectory, String playerUUID) {
            super(player);
            this.playerDirectory = originDirectory;
            this.playerUUID = playerUUID;
        }

        public LoadFromFile(PlayerEvent.LoadFromFile event) {
            this(event.getEntity(), event.getPlayerDirectory(), event.getPlayerUUID());
        }

        public File getPlayerFile(String suffix) {
            if ("dat".equals(suffix)) {
                throw new IllegalArgumentException("The suffix 'dat' is reserved");
            }
            return new File(this.getPlayerDirectory(), this.getPlayerUUID() + "." + suffix);
        }

        public File getPlayerDirectory() {
            return this.playerDirectory;
        }

        public String getPlayerUUID() {
            return this.playerUUID;
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.LoadFromFile.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.LoadFromFile(this.getEntity(), this.getPlayerDirectory(), this.getPlayerUUID());
        }
    }

    public static class StopTracking
    extends PlayerEventWrapper {
        private final Entity target;

        public StopTracking(Player player, Entity target) {
            super(player);
            this.target = target;
        }

        public StopTracking(PlayerEvent.StopTracking event) {
            this(event.getEntity(), event.getTarget());
        }

        public Entity getTarget() {
            return this.target;
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.StopTracking.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.StopTracking(this.getEntity(), this.getTarget());
        }
    }

    public static class StartTracking
    extends PlayerEventWrapper {
        private final Entity target;

        public StartTracking(Player player, Entity target) {
            super(player);
            this.target = target;
        }

        public StartTracking(PlayerEvent.StartTracking event) {
            this(event.getEntity(), event.getTarget());
        }

        public Entity getTarget() {
            return this.target;
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.StartTracking.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.StartTracking(this.getEntity(), this.getTarget());
        }
    }

    public static class Clone
    extends PlayerEventWrapper {
        private final Player original;
        private final boolean wasDeath;

        public Clone(Player _new, Player oldPlayer, boolean wasDeath) {
            super(_new);
            this.original = oldPlayer;
            this.wasDeath = wasDeath;
        }

        public Clone(PlayerEvent.Clone event) {
            this(event.getEntity(), event.getOriginal(), event.isWasDeath());
        }

        public Player getOriginal() {
            return this.original;
        }

        public boolean isWasDeath() {
            return this.wasDeath;
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.Clone.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.Clone(this.getEntity(), this.getOriginal(), this.isWasDeath());
        }
    }

    public static class TabListNameFormat
    extends PlayerEventWrapper {
        @Nullable
        private Component displayName;

        public TabListNameFormat(Player player) {
            super(player);
        }

        public TabListNameFormat(PlayerEvent.TabListNameFormat event) {
            this(event.getEntity());
        }

        @Nullable
        public Component getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(@Nullable Component displayName) {
            this.displayName = displayName;
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.TabListNameFormat.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.TabListNameFormat(this.getEntity());
        }
    }

    public static class NameFormat
    extends PlayerEventWrapper {
        private final Component username;
        private Component displayname;

        public NameFormat(Player player, Component username) {
            super(player);
            this.username = username;
            this.setDisplayname(username);
        }

        public NameFormat(PlayerEvent.NameFormat event) {
            this(event.getEntity(), event.getUsername());
        }

        public Component getUsername() {
            return this.username;
        }

        public Component getDisplayname() {
            return this.displayname;
        }

        public void setDisplayname(Component displayname) {
            this.displayname = displayname;
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.NameFormat.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.NameFormat(this.getEntity(), this.getUsername());
        }
    }

    @Cancelable
    public static class BreakSpeed
    extends PlayerEventWrapper {
        private static final BlockPos LEGACY_UNKNOWN = new BlockPos(0, -114514, 0);
        private final BlockState state;
        private final float originalSpeed;
        private float newSpeed = 0.0f;
        private final Optional<BlockPos> pos;

        public BreakSpeed(Player player, BlockState state, float original, @Nullable BlockPos pos) {
            super(player);
            this.state = state;
            this.originalSpeed = original;
            this.setNewSpeed(original);
            this.pos = Optional.ofNullable(pos);
        }

        public BreakSpeed(PlayerEvent.BreakSpeed event) {
            this(event.getEntity(), event.getState(), event.getOriginalSpeed(), event.getPosition().isPresent() ? (BlockPos)event.getPosition().get() : null);
            this.setNewSpeed(event.getNewSpeed());
        }

        public BlockState getState() {
            return this.state;
        }

        public float getOriginalSpeed() {
            return this.originalSpeed;
        }

        public float getNewSpeed() {
            return this.newSpeed;
        }

        public void setNewSpeed(float newSpeed) {
            this.newSpeed = newSpeed;
        }

        public Optional<BlockPos> getPosition() {
            return this.pos;
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.BreakSpeed.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.BreakSpeed(this.getEntity(), this.getState(), this.getOriginalSpeed(), this.getPosition().isPresent() ? this.getPosition().get() : null);
        }
    }

    public static class HarvestCheck
    extends PlayerEventWrapper {
        private final BlockState state;
        private boolean success;

        public HarvestCheck(Player player, BlockState state, boolean success) {
            super(player);
            this.state = state;
            this.success = success;
        }

        public HarvestCheck(PlayerEvent.HarvestCheck event) {
            this(event.getEntity(), event.getTargetBlock(), event.canHarvest());
        }

        public BlockState getTargetBlock() {
            return this.state;
        }

        public boolean canHarvest() {
            return this.success;
        }

        public void setCanHarvest(boolean success) {
            this.success = success;
        }

        public static Class<? extends Event> getForgeClass() {
            return PlayerEvent.HarvestCheck.class;
        }

        @Override
        public Object toForgeEvent() {
            return new PlayerEvent.HarvestCheck(this.getEntity(), this.getTargetBlock(), this.canHarvest());
        }
    }
}

