/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.eventwrapper.eventbus.api;

import io.github.lounode.eventwrapper.eventbus.BusBuilderImpl;
import io.github.lounode.eventwrapper.eventbus.api.IEventBus;
import io.github.lounode.eventwrapper.eventbus.api.IEventClassChecker;
import io.github.lounode.eventwrapper.eventbus.api.IEventExceptionHandler;

public interface BusBuilder {
    public static BusBuilder builder() {
        return new BusBuilderImpl();
    }

    public BusBuilder setExceptionHandler(IEventExceptionHandler var1);

    public BusBuilder startShutdown();

    public BusBuilder checkTypesOnDispatch();

    default public BusBuilder markerType(Class<?> markerInterface) {
        if (!markerInterface.isInterface()) {
            throw new IllegalArgumentException("Cannot specify a class marker type");
        }
        return this.classChecker(eventType -> {
            if (!markerInterface.isAssignableFrom(eventType)) {
                throw new IllegalArgumentException("This bus only accepts subclasses of " + String.valueOf(markerInterface) + ", which " + String.valueOf(eventType) + " is not.");
            }
        });
    }

    public BusBuilder classChecker(IEventClassChecker var1);

    public BusBuilder allowPerPhasePost();

    public IEventBus build();
}

