/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.eventwrapper.eventbus.api;

import io.github.lounode.eventwrapper.eventbus.IWrapperListener;
import io.github.lounode.eventwrapper.eventbus.api.EventListener;
import io.github.lounode.eventwrapper.eventbus.api.EventWrapper;
import java.util.function.Consumer;
import java.util.function.Predicate;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class ConsumerEventHandler
extends EventListener {
    protected final Consumer<EventWrapper> consumer;

    public ConsumerEventHandler(Consumer<EventWrapper> consumer) {
        this.consumer = consumer;
    }

    @Override
    public void invoke(EventWrapper event) {
        this.consumer.accept(event);
    }

    public String toString() {
        return this.consumer.toString();
    }

    public static final class WithPredicate
    extends ConsumerEventHandler
    implements IWrapperListener {
        private final Predicate<EventWrapper> predicate;
        private final EventListener withoutCheck;

        public WithPredicate(Consumer<EventWrapper> consumer, Predicate<EventWrapper> predicate) {
            super(consumer);
            this.predicate = predicate;
            this.withoutCheck = new ConsumerEventHandler(consumer);
        }

        @Override
        public void invoke(EventWrapper event) {
            if (this.predicate.test(event)) {
                this.consumer.accept(event);
            }
        }

        @Override
        public EventListener getWithoutCheck() {
            return this.withoutCheck;
        }
    }
}

