/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.eventwrapper.eventbus.api;

import io.github.lounode.eventwrapper.eventbus.api.EventListenerHelper;
import io.github.lounode.eventwrapper.eventbus.api.EventPriority;
import io.github.lounode.xplatform.platform.Platform;
import io.github.lounode.xplatform.platform.support.CrossPlatform;
import io.github.lounode.xplatform.platform.support.SupportPlatform;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CrossPlatform
public abstract class EventWrapper {
    private boolean isCanceled = false;
    private Result result = Result.DEFAULT;
    private EventPriority phase = null;

    public boolean isCancelable() {
        return EventListenerHelper.isCancelable(this.getClass());
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean cancel) {
        if (!this.isCancelable()) {
            throw new UnsupportedOperationException("Attempted to call Event#setCanceled() on a non-cancelable event of type: " + this.getClass().getCanonicalName());
        }
        this.isCanceled = cancel;
    }

    public boolean hasResult() {
        return EventListenerHelper.hasResult(this.getClass());
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result value) {
        this.result = value;
    }

    @Nullable
    public EventPriority getPhase() {
        return this.phase;
    }

    public void setPhase(@NotNull EventPriority value) {
        int prev;
        Objects.requireNonNull(value, "setPhase argument must not be null");
        int n = prev = this.phase == null ? -1 : this.phase.ordinal();
        if (prev >= value.ordinal()) {
            throw new IllegalArgumentException("Attempted to set event phase to " + String.valueOf(value) + " when already " + String.valueOf(this.phase));
        }
        this.phase = value;
    }

    @SupportPlatform(value=Platform.FORGE)
    public static Class<? extends Event> getForgeClass() {
        return Event.class;
    }

    @SupportPlatform(value=Platform.FORGE)
    public Object toForgeEvent() {
        return new Event();
    }

    public static enum Result {
        DENY,
        DEFAULT,
        ALLOW;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface HasResult {
    }
}

