/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.eventwrapper.forge;

import io.github.lounode.eventwrapper.EventsWrapper;
import io.github.lounode.eventwrapper.eventbus.api.Dist;
import io.github.lounode.eventwrapper.eventbus.api.EventBusSubscriberWrapper;
import io.github.lounode.eventwrapper.eventbus.api.OnlyIn;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

public class AutoEventSubscriberRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Type AUTO_SUBSCRIBER = Type.getType(EventBusSubscriberWrapper.class);
    private static final Type MOD_TYPE = Type.getType(Mod.class);
    private static final Type ONLY_IN_TYPE = Type.getType(OnlyIn.class);
    private static final Type FORGE_ONLY_IN_TYPE = Type.getType(net.minecraftforge.api.distmarker.OnlyIn.class);

    public static void inject(String modId) {
        List scanDatas = ModList.get().getAllScanData();
        ModFileScanData result = null;
        for (ModFileScanData scanData : scanDatas) {
            Map<String, String> modids = scanData.getAnnotations().stream().filter(data -> MOD_TYPE.equals((Object)data.annotationType())).collect(Collectors.toMap(a -> a.clazz().getClassName(), a -> (String)a.annotationData().get("value")));
            if (!modids.values().contains(modId)) continue;
            result = scanData;
        }
        if (result == null) {
            LOGGER.error("Can't find mod scan data: id: " + modId);
        }
        AutoEventSubscriberRegistry.inject(result);
    }

    public static void inject(ModFileScanData scanData) {
        if (scanData == null) {
            return;
        }
        List<ModFileScanData.AnnotationData> targets = scanData.getAnnotations().stream().filter(data -> AUTO_SUBSCRIBER.equals((Object)data.annotationType())).toList();
        Set clientOnlyClasses = scanData.getAnnotations().stream().filter(data -> ONLY_IN_TYPE.equals((Object)data.annotationType()) || FORGE_ONLY_IN_TYPE.equals((Object)data.annotationType())).filter(data -> {
            try {
                Object value = data.annotationData().get("value");
                return value == Dist.CLIENT || value == net.minecraftforge.api.distmarker.Dist.CLIENT;
            }
            catch (Exception e) {
                return false;
            }
        }).map(data -> data.clazz().getClassName()).collect(Collectors.toSet());
        for (ModFileScanData.AnnotationData data2 : targets) {
            if (FMLEnvironment.dist != net.minecraftforge.api.distmarker.Dist.CLIENT && clientOnlyClasses.contains(data2.clazz().getClassName())) {
                LOGGER.warn("Skipping client class {}", (Object)data2.clazz().getClassName());
                continue;
            }
            LOGGER.debug(Logging.LOADING, "Auto-subscribing {}", (Object)data2.clazz().getClassName());
            try {
                EventsWrapper.register(Class.forName(data2.clazz().getClassName()));
            }
            catch (RuntimeException e) {
                LOGGER.error(Logging.LOADING, "Error when register event in {}.", (Object)data2.clazz().getClassName());
            }
            catch (ClassNotFoundException e) {
                LOGGER.error(Logging.LOADING, "Failed to load mod class {} for @EventBusSubscriber annotation", (Object)data2.clazz(), (Object)e);
            }
            catch (NoClassDefFoundError e) {
                LOGGER.error(Logging.LOADING, "Class {} was not found", (Object)data2.clazz(), (Object)e);
            }
        }
    }

    private static <R> R value(ModFileScanData.AnnotationData data, String key, R value) {
        return data.annotationData().getOrDefault(key, value);
    }
}

