/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.eventwrapper.forge.event;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.github.lounode.eventwrapper.event.PlayLevelSoundEventWrapper;
import io.github.lounode.eventwrapper.event.entity.EntityEventWrapper;
import io.github.lounode.eventwrapper.event.entity.living.LivingAttackEventWrapper;
import io.github.lounode.eventwrapper.event.entity.living.LivingDamageEventWrapper;
import io.github.lounode.eventwrapper.event.entity.living.LivingDeathEventWrapper;
import io.github.lounode.eventwrapper.event.entity.living.LivingEventWrapper;
import io.github.lounode.eventwrapper.event.entity.living.LivingHealEventWrapper;
import io.github.lounode.eventwrapper.event.entity.living.LivingHurtEventWrapper;
import io.github.lounode.eventwrapper.event.entity.living.MobEffectEventWrapper;
import io.github.lounode.eventwrapper.event.entity.living.ShieldBlockEventWrapper;
import io.github.lounode.eventwrapper.event.entity.player.AnvilRepairEventWrapper;
import io.github.lounode.eventwrapper.event.entity.player.AttackEntityEventWrapper;
import io.github.lounode.eventwrapper.event.entity.player.EntityItemPickupEventWrapper;
import io.github.lounode.eventwrapper.event.entity.player.ItemCooldownFinishEventWrapper;
import io.github.lounode.eventwrapper.event.entity.player.ItemCooldownStartEventWrapper;
import io.github.lounode.eventwrapper.event.entity.player.PlayerEventWrapper;
import io.github.lounode.eventwrapper.event.entity.player.PlayerInteractEventWrapper;
import io.github.lounode.eventwrapper.event.furnace.FurnaceFuelBurnTimeEventWrapper;
import io.github.lounode.eventwrapper.event.level.LevelEventWrapper;
import io.github.lounode.eventwrapper.event.server.ServerAboutToStartEventWrapper;
import io.github.lounode.eventwrapper.event.server.ServerLifecycleEventWrapper;
import io.github.lounode.eventwrapper.event.server.ServerStartedEventWrapper;
import io.github.lounode.eventwrapper.event.server.ServerStartingEventWrapper;
import io.github.lounode.eventwrapper.event.server.ServerStoppedEventWrapper;
import io.github.lounode.eventwrapper.event.server.ServerStoppingEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.EventConverter;
import io.github.lounode.eventwrapper.eventbus.api.EventWrapper;
import io.github.lounode.eventwrapper.forge.event.converter.ForgeEventConverter;
import io.github.lounode.eventwrapper.forge.event.converter.PlayLevelSoundEventConverter;
import io.github.lounode.eventwrapper.forge.event.converter.entity.EntityEventConverter;
import io.github.lounode.eventwrapper.forge.event.converter.entity.living.LivingAttackEventConverter;
import io.github.lounode.eventwrapper.forge.event.converter.entity.living.LivingDamageEventConverter;
import io.github.lounode.eventwrapper.forge.event.converter.entity.living.LivingDeathEventConverter;
import io.github.lounode.eventwrapper.forge.event.converter.entity.living.LivingEventConverter;
import io.github.lounode.eventwrapper.forge.event.converter.entity.living.LivingHealEventConverter;
import io.github.lounode.eventwrapper.forge.event.converter.entity.living.LivingHurtEventConverter;
import io.github.lounode.eventwrapper.forge.event.converter.entity.living.MobEffectEventConverter;
import io.github.lounode.eventwrapper.forge.event.converter.entity.living.ShieldBlockEventConverter;
import io.github.lounode.eventwrapper.forge.event.converter.entity.player.AnvilRepairEventConverter;
import io.github.lounode.eventwrapper.forge.event.converter.entity.player.AttackEntityEventConverter;
import io.github.lounode.eventwrapper.forge.event.converter.entity.player.EntityItemPickupEventConverter;
import io.github.lounode.eventwrapper.forge.event.converter.entity.player.ItemCooldownFinishEventConverter;
import io.github.lounode.eventwrapper.forge.event.converter.entity.player.ItemCooldownStartEventConverter;
import io.github.lounode.eventwrapper.forge.event.converter.entity.player.PlayerEventConverter;
import io.github.lounode.eventwrapper.forge.event.converter.entity.player.PlayerInteractEventConverter;
import io.github.lounode.eventwrapper.forge.event.converter.furnace.FurnaceFuelBurnTimeEventConverter;
import io.github.lounode.eventwrapper.forge.event.converter.level.LevelEventConverter;
import io.github.lounode.eventwrapper.forge.event.converter.server.ServerAboutToStartEventConverter;
import io.github.lounode.eventwrapper.forge.event.converter.server.ServerLifecycleEventConverter;
import io.github.lounode.eventwrapper.forge.event.converter.server.ServerStartedEventConverter;
import io.github.lounode.eventwrapper.forge.event.converter.server.ServerStartingEventConverter;
import io.github.lounode.eventwrapper.forge.event.converter.server.ServerStoppedEventConverter;
import io.github.lounode.eventwrapper.forge.event.converter.server.ServerStoppingEventConverter;
import io.github.lounode.eventwrapper.forge.event.entity.player.ItemCooldownFinishEvent;
import io.github.lounode.eventwrapper.forge.event.entity.player.ItemCooldownStartEvent;
import net.minecraftforge.event.PlayLevelSoundEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerLifecycleEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public class ForgeEventMappings {
    private static final BiMap<Class<? extends Event>, Class<? extends EventWrapper>> MAPPINGS = HashBiMap.create();
    private static final BiMap<Class<? extends Event>, ForgeEventConverter<?, ?>> EVENT_TO_WRAPPER_MAPPINGS = HashBiMap.create();
    private static final BiMap<Class<? extends EventWrapper>, ForgeEventConverter<?, ?>> WRAPPER_TO_EVENT_MAPPINGS = HashBiMap.create();

    public static void makeLink(Class<? extends Event> event, Class<? extends EventWrapper> wrapper, ForgeEventConverter<?, ?> converter) {
        MAPPINGS.put(event, wrapper);
        EVENT_TO_WRAPPER_MAPPINGS.put(event, converter);
        WRAPPER_TO_EVENT_MAPPINGS.put(wrapper, converter);
    }

    @Nullable
    public static EventConverter<?, ?> getConverter(Class<?> clazz) {
        if (EventWrapper.class.isAssignableFrom(clazz)) {
            return (EventConverter)WRAPPER_TO_EVENT_MAPPINGS.get(clazz);
        }
        if (Event.class.isAssignableFrom(clazz)) {
            return (EventConverter)EVENT_TO_WRAPPER_MAPPINGS.get(clazz);
        }
        return null;
    }

    @Nullable
    public static Class<? extends Event> getForgeEventClass(Class<? extends EventWrapper> wrapperClass) {
        return (Class)MAPPINGS.inverse().get(wrapperClass);
    }

    @Nullable
    public static Class<? extends EventWrapper> getWrapperClass(Class<? extends Event> eventClass) {
        return (Class)MAPPINGS.get(eventClass);
    }

    static {
        ForgeEventMappings.makeLink(ServerLifecycleEvent.class, ServerLifecycleEventWrapper.class, new ServerLifecycleEventConverter());
        ForgeEventMappings.makeLink(ServerAboutToStartEvent.class, ServerAboutToStartEventWrapper.class, new ServerAboutToStartEventConverter());
        ForgeEventMappings.makeLink(ServerStartedEvent.class, ServerStartedEventWrapper.class, new ServerStartedEventConverter());
        ForgeEventMappings.makeLink(ServerStartingEvent.class, ServerStartingEventWrapper.class, new ServerStartingEventConverter());
        ForgeEventMappings.makeLink(ServerStoppedEvent.class, ServerStoppedEventWrapper.class, new ServerStoppedEventConverter());
        ForgeEventMappings.makeLink(ServerStoppingEvent.class, ServerStoppingEventWrapper.class, new ServerStoppingEventConverter());
        ForgeEventMappings.makeLink(FurnaceFuelBurnTimeEvent.class, FurnaceFuelBurnTimeEventWrapper.class, new FurnaceFuelBurnTimeEventConverter());
        ForgeEventMappings.makeLink(EntityEvent.EntityConstructing.class, EntityEventWrapper.EntityConstructing.class, new EntityEventConverter.EntityConstructingConverter());
        ForgeEventMappings.makeLink(EntityEvent.EnteringSection.class, EntityEventWrapper.EnteringSection.class, new EntityEventConverter.EnteringSectionConverter());
        ForgeEventMappings.makeLink(AnvilRepairEvent.class, AnvilRepairEventWrapper.class, new AnvilRepairEventConverter());
        ForgeEventMappings.makeLink(AttackEntityEvent.class, AttackEntityEventWrapper.class, new AttackEntityEventConverter());
        ForgeEventMappings.makeLink(EntityItemPickupEvent.class, EntityItemPickupEventWrapper.class, new EntityItemPickupEventConverter());
        ForgeEventMappings.makeLink(ItemCooldownStartEvent.class, ItemCooldownStartEventWrapper.class, new ItemCooldownStartEventConverter());
        ForgeEventMappings.makeLink(ItemCooldownFinishEvent.class, ItemCooldownFinishEventWrapper.class, new ItemCooldownFinishEventConverter());
        ForgeEventMappings.makeLink(PlayerEvent.HarvestCheck.class, PlayerEventWrapper.HarvestCheck.class, new PlayerEventConverter.HarvestCheckConverter());
        ForgeEventMappings.makeLink(PlayerEvent.BreakSpeed.class, PlayerEventWrapper.BreakSpeed.class, new PlayerEventConverter.BreakSpeedConverter());
        ForgeEventMappings.makeLink(PlayerEvent.NameFormat.class, PlayerEventWrapper.NameFormat.class, new PlayerEventConverter.NameFormatConverter());
        ForgeEventMappings.makeLink(PlayerEvent.TabListNameFormat.class, PlayerEventWrapper.TabListNameFormat.class, new PlayerEventConverter.TabListNameFormatConverter());
        ForgeEventMappings.makeLink(PlayerEvent.Clone.class, PlayerEventWrapper.Clone.class, new PlayerEventConverter.CloneConverter());
        ForgeEventMappings.makeLink(PlayerEvent.StartTracking.class, PlayerEventWrapper.StartTracking.class, new PlayerEventConverter.StartTrackingConverter());
        ForgeEventMappings.makeLink(PlayerEvent.StopTracking.class, PlayerEventWrapper.StopTracking.class, new PlayerEventConverter.StopTrackingConverter());
        ForgeEventMappings.makeLink(PlayerEvent.LoadFromFile.class, PlayerEventWrapper.LoadFromFile.class, new PlayerEventConverter.LoadFromFileConverter());
        ForgeEventMappings.makeLink(PlayerEvent.SaveToFile.class, PlayerEventWrapper.SaveToFile.class, new PlayerEventConverter.SaveToFileConverter());
        ForgeEventMappings.makeLink(PlayerEvent.ItemPickupEvent.class, PlayerEventWrapper.ItemPickupEvent.class, new PlayerEventConverter.ItemPickupConverter());
        ForgeEventMappings.makeLink(PlayerEvent.ItemCraftedEvent.class, PlayerEventWrapper.ItemCraftedEvent.class, new PlayerEventConverter.ItemCraftedConverter());
        ForgeEventMappings.makeLink(PlayerEvent.ItemSmeltedEvent.class, PlayerEventWrapper.ItemSmeltedEvent.class, new PlayerEventConverter.ItemSmeltedConverter());
        ForgeEventMappings.makeLink(PlayerEvent.PlayerLoggedInEvent.class, PlayerEventWrapper.PlayerLoggedInEvent.class, new PlayerEventConverter.PlayerLoggedInConverter());
        ForgeEventMappings.makeLink(PlayerEvent.PlayerLoggedOutEvent.class, PlayerEventWrapper.PlayerLoggedOutEvent.class, new PlayerEventConverter.PlayerLoggedOutConverter());
        ForgeEventMappings.makeLink(PlayerEvent.PlayerRespawnEvent.class, PlayerEventWrapper.PlayerRespawnEvent.class, new PlayerEventConverter.PlayerRespawnConverter());
        ForgeEventMappings.makeLink(PlayerEvent.PlayerChangedDimensionEvent.class, PlayerEventWrapper.PlayerChangedDimensionEvent.class, new PlayerEventConverter.PlayerChangedDimensionConverter());
        ForgeEventMappings.makeLink(PlayerEvent.PlayerChangeGameModeEvent.class, PlayerEventWrapper.PlayerChangeGameModeEvent.class, new PlayerEventConverter.PlayerChangeGameModeConverter());
        ForgeEventMappings.makeLink(PlayerInteractEvent.EntityInteractSpecific.class, PlayerInteractEventWrapper.EntityInteractSpecific.class, new PlayerInteractEventConverter.EntityInteractSpecificConverter());
        ForgeEventMappings.makeLink(PlayerInteractEvent.EntityInteract.class, PlayerInteractEventWrapper.EntityInteract.class, new PlayerInteractEventConverter.EntityInteractConverter());
        ForgeEventMappings.makeLink(PlayerInteractEvent.RightClickBlock.class, PlayerInteractEventWrapper.RightClickBlock.class, new PlayerInteractEventConverter.RightClickBlockConverter());
        ForgeEventMappings.makeLink(PlayerInteractEvent.RightClickItem.class, PlayerInteractEventWrapper.RightClickItem.class, new PlayerInteractEventConverter.RightClickItemConverter());
        ForgeEventMappings.makeLink(PlayerInteractEvent.RightClickEmpty.class, PlayerInteractEventWrapper.RightClickEmpty.class, new PlayerInteractEventConverter.RightClickEmptyConverter());
        ForgeEventMappings.makeLink(PlayerInteractEvent.LeftClickBlock.class, PlayerInteractEventWrapper.LeftClickBlock.class, new PlayerInteractEventConverter.LeftClickBlockConverter());
        ForgeEventMappings.makeLink(PlayerInteractEvent.LeftClickEmpty.class, PlayerInteractEventWrapper.LeftClickEmpty.class, new PlayerInteractEventConverter.LeftClickEmptyConverter());
        ForgeEventMappings.makeLink(LivingAttackEvent.class, LivingAttackEventWrapper.class, new LivingAttackEventConverter());
        ForgeEventMappings.makeLink(LivingDamageEvent.class, LivingDamageEventWrapper.class, new LivingDamageEventConverter());
        ForgeEventMappings.makeLink(LivingHealEvent.class, LivingHealEventWrapper.class, new LivingHealEventConverter());
        ForgeEventMappings.makeLink(LivingHurtEvent.class, LivingHurtEventWrapper.class, new LivingHurtEventConverter());
        ForgeEventMappings.makeLink(MobEffectEvent.Remove.class, MobEffectEventWrapper.Remove.class, new MobEffectEventConverter.RemoveConverter());
        ForgeEventMappings.makeLink(MobEffectEvent.Applicable.class, MobEffectEventWrapper.Applicable.class, new MobEffectEventConverter.ApplicableConverter());
        ForgeEventMappings.makeLink(MobEffectEvent.Added.class, MobEffectEventWrapper.Added.class, new MobEffectEventConverter.AddedConverter());
        ForgeEventMappings.makeLink(MobEffectEvent.Expired.class, MobEffectEventWrapper.Expired.class, new MobEffectEventConverter.ExpiredConverter());
        ForgeEventMappings.makeLink(LivingEvent.LivingJumpEvent.class, LivingEventWrapper.LivingJumpEvent.class, new LivingEventConverter.LivingJumpConverter());
        ForgeEventMappings.makeLink(LivingEvent.LivingTickEvent.class, LivingEventWrapper.LivingTickEvent.class, new LivingEventConverter.LivingTickConverter());
        ForgeEventMappings.makeLink(LivingEvent.LivingVisibilityEvent.class, LivingEventWrapper.LivingVisibilityEvent.class, new LivingEventConverter.LivingVisibilityConverter());
        ForgeEventMappings.makeLink(LivingDeathEvent.class, LivingDeathEventWrapper.class, new LivingDeathEventConverter());
        ForgeEventMappings.makeLink(ShieldBlockEvent.class, ShieldBlockEventWrapper.class, new ShieldBlockEventConverter());
        ForgeEventMappings.makeLink(PlayLevelSoundEvent.AtEntity.class, PlayLevelSoundEventWrapper.AtEntity.class, new PlayLevelSoundEventConverter.AtEntity());
        ForgeEventMappings.makeLink(PlayLevelSoundEvent.AtPosition.class, PlayLevelSoundEventWrapper.AtPosition.class, new PlayLevelSoundEventConverter.AtPosition());
        ForgeEventMappings.makeLink(LevelEvent.Load.class, LevelEventWrapper.Load.class, new LevelEventConverter.Load());
        ForgeEventMappings.makeLink(LevelEvent.Unload.class, LevelEventWrapper.Unload.class, new LevelEventConverter.Unload());
        ForgeEventMappings.makeLink(LevelEvent.Save.class, LevelEventWrapper.Save.class, new LevelEventConverter.Save());
        ForgeEventMappings.makeLink(LevelEvent.CreateSpawnPosition.class, LevelEventWrapper.CreateSpawnPosition.class, new LevelEventConverter.CreateSpawnPosition());
        ForgeEventMappings.makeLink(LevelEvent.PotentialSpawns.class, LevelEventWrapper.PotentialSpawns.class, new LevelEventConverter.PotentialSpawns());
    }
}

