/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.eventwrapper.mixin;

import io.github.lounode.eventwrapper.EventsWrapper;
import io.github.lounode.eventwrapper.event.entity.player.ItemCooldownFinishEventWrapper;
import io.github.lounode.eventwrapper.event.entity.player.ItemCooldownStartEventWrapper;
import io.github.lounode.eventwrapper.utils.ClientUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ServerItemCooldowns;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemCooldowns.class})
public class ItemCooldownEventPoster {
    @Inject(method={"removeCooldown"}, at={@At(value="HEAD")})
    private void onCooldownRemove(Item item, CallbackInfo ci) {
        Player player;
        ItemCooldowns self = (ItemCooldowns)this;
        if (self instanceof ServerItemCooldowns) {
            ServerItemCooldowns cooldowns = (ServerItemCooldowns)self;
            player = cooldowns.f_43065_;
        } else {
            player = ClientUtil.getClientPlayer();
        }
        ItemCooldownFinishEventWrapper event = new ItemCooldownFinishEventWrapper(player, item);
        EventsWrapper.post(event);
    }

    @ModifyVariable(method={"addCooldown"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private int onCooldownStart(int ticks, Item item) {
        Player player;
        ItemCooldowns self = (ItemCooldowns)this;
        if (self instanceof ServerItemCooldowns) {
            ServerItemCooldowns cooldowns = (ServerItemCooldowns)self;
            player = cooldowns.f_43065_;
        } else {
            player = ClientUtil.getClientPlayer();
        }
        ItemCooldownStartEventWrapper event = new ItemCooldownStartEventWrapper(player, item, ticks);
        EventsWrapper.post(event);
        return event.isCanceled() ? 0 : event.getTicks();
    }
}

