/*
 * Decompiled with CFR 0.152.
 */
package com.example.chattohttp;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ChatToHttpPlugin
extends JavaPlugin
implements Listener {
    private String webhookUrl;
    private String password;

    public void onEnable() {
        this.saveDefaultConfig();
        this.reloadConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("c2h").setExecutor((CommandExecutor)this);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("c2h")) {
            if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
                Player player = (Player)sender;
                if (player.hasPermission("c2h.reload")) {
                    this.reloadConfig();
                    sender.sendMessage(this.getConfig().getString("config-reloaded"));
                    return true;
                }
                sender.sendMessage(this.getConfig().getString("no-permission-message"));
                return false;
            }
            sender.sendMessage(this.getConfig().getString("main-text"));
        }
        return false;
    }

    public void reloadConfig() {
        super.reloadConfig();
        this.webhookUrl = this.getConfig().getString("webhook-url");
        this.password = this.getConfig().getString("password");
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        try {
            String nick = event.getPlayer().getName();
            String message = event.getMessage();
            String encodedNick = URLEncoder.encode(nick, StandardCharsets.UTF_8.toString());
            String encodedMessage = URLEncoder.encode(message, StandardCharsets.UTF_8.toString());
            String urlString = this.webhookUrl + "?nick=" + encodedNick + "&message=" + encodedMessage + "&password=" + this.password;
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.getResponseCode();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

