/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.baubles;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import me.val_mobile.data.RSVModule;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.RSVTask;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MagicMirrorTask
extends BukkitRunnable
implements RSVTask {
    private static final Map<UUID, MagicMirrorTask> tasks = new HashMap<UUID, MagicMirrorTask>();
    private final RSVPlugin plugin;
    private final UUID id;
    private int ticks = 0;
    private final int duration;
    private final int tickPeriod;

    public MagicMirrorTask(Player player, RSVPlugin plugin) {
        this.id = player.getUniqueId();
        this.plugin = plugin;
        FileConfiguration config = RSVModule.getModule("Baubles").getUserConfig().getConfig();
        this.duration = config.getInt("Items.magic_mirror.Cooldown");
        this.tickPeriod = config.getInt("Items.magic_mirror.TickPeriod");
        tasks.put(this.id, this);
    }

    public void run() {
        if (this.conditionsMet(Bukkit.getPlayer((UUID)this.id))) {
            this.ticks += this.tickPeriod;
        } else {
            this.stop();
        }
    }

    @Override
    public boolean conditionsMet(@Nullable Player player) {
        return player != null && this.ticks < this.duration;
    }

    @Override
    public void start() {
        this.runTaskTimer((Plugin)this.plugin, 0L, this.tickPeriod);
    }

    @Override
    public void stop() {
        tasks.remove(this.id);
        this.cancel();
    }

    public static boolean hasTask(UUID id) {
        return tasks.containsKey(id) && tasks.get(id) != null;
    }

    public static Map<UUID, MagicMirrorTask> getTasks() {
        return tasks;
    }
}

