/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.baubles;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import me.val_mobile.baubles.BaubleModule;
import me.val_mobile.data.RSVPlayer;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.RSVTask;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class PolarizedStoneTask
extends BukkitRunnable
implements RSVTask {
    private static final Map<UUID, PolarizedStoneTask> tasks = new HashMap<UUID, PolarizedStoneTask>();
    private final RSVPlayer rsvPlayer;
    private final RSVPlugin plugin;
    private final UUID id;
    private final Collection<String> allowedWorlds;
    private final FileConfiguration config;
    private final double maxRadius;
    private final double pullForce;

    public PolarizedStoneTask(BaubleModule module, RSVPlayer rsvPlayer, RSVPlugin plugin) {
        this.rsvPlayer = rsvPlayer;
        this.id = rsvPlayer.getPlayer().getUniqueId();
        this.allowedWorlds = module.getAllowedWorlds();
        this.config = module.getUserConfig().getConfig();
        this.plugin = plugin;
        this.maxRadius = this.config.getDouble("Items.polarized_stone.MaxRadius");
        this.pullForce = this.config.getDouble("Items.polarized_stone.PullForce");
        tasks.put(this.id, this);
    }

    public void run() {
        Player player = this.rsvPlayer.getPlayer();
        if (this.conditionsMet(player)) {
            Location pLoc = player.getLocation();
            Vector pVector = pLoc.toVector();
            for (Entity entity : player.getNearbyEntities(this.maxRadius, this.maxRadius, this.maxRadius)) {
                if (entity.getType() != EntityType.EXPERIENCE_ORB && entity.getType() != EntityType.DROPPED_ITEM || !(entity.getLocation().distanceSquared(pLoc) > 0.25)) continue;
                entity.setVelocity(pVector.subtract(entity.getLocation().toVector()).normalize().multiply(this.pullForce));
            }
        } else {
            this.stop();
        }
    }

    @Override
    public boolean conditionsMet(@Nullable Player player) {
        return this.globalConditionsMet((LivingEntity)player) && this.allowedWorlds.contains(player.getWorld().getName()) && this.rsvPlayer.getBaubleDataModule().hasBauble("polarized_stone");
    }

    @Override
    public void start() {
        int tickPeriod = this.config.getInt("Items.polarized_stone.TickPeriod");
        this.runTaskTimer((Plugin)this.plugin, 0L, tickPeriod);
    }

    @Override
    public void stop() {
        tasks.remove(this.id);
        this.cancel();
    }

    public static boolean hasTask(UUID id) {
        return tasks.containsKey(id) && tasks.get(id) != null;
    }

    public static Map<UUID, PolarizedStoneTask> getTasks() {
        return tasks;
    }
}

