/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.baubles;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import me.val_mobile.baubles.BaubleModule;
import me.val_mobile.data.RSVPlayer;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.RSVTask;
import me.val_mobile.utils.Utils;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class StoneSeaTask
extends BukkitRunnable
implements RSVTask {
    private static final Map<UUID, StoneSeaTask> tasks = new HashMap<UUID, StoneSeaTask>();
    private final RSVPlayer rsvPlayer;
    private final UUID id;
    private final Collection<String> allowedWorlds;
    private final RSVPlugin plugin;
    private final double baseSwimSpeed;
    private final double horizontalSpeedIncrement;
    private final double verticalSpeedIncrement;
    private final double maxHorizontalSpeed;
    private final double maxVerticalSpeed;
    private final FileConfiguration config;

    public StoneSeaTask(BaubleModule module, RSVPlayer rsvPlayer, RSVPlugin plugin) {
        this.rsvPlayer = rsvPlayer;
        this.allowedWorlds = module.getAllowedWorlds();
        this.id = rsvPlayer.getPlayer().getUniqueId();
        this.plugin = plugin;
        this.config = module.getUserConfig().getConfig();
        this.baseSwimSpeed = this.config.getDouble("Items.stone_sea.BaseSwimSpeed");
        this.horizontalSpeedIncrement = this.config.getDouble("Items.stone_sea.HorizontalSpeedIncrement");
        this.verticalSpeedIncrement = this.config.getDouble("Items.stone_sea.VerticalSpeedIncrement");
        this.maxHorizontalSpeed = this.config.getDouble("Items.stone_sea.MaxHorizontalSpeed");
        this.maxVerticalSpeed = this.config.getDouble("Items.stone_sea.MaxVerticalSpeed");
        tasks.put(this.id, this);
    }

    public void run() {
        Player player = this.rsvPlayer.getPlayer();
        if (this.conditionsMet(player)) {
            Vector velocity = player.getVelocity().clone();
            double magnitude = velocity.length() * 43.17;
            if (player.isSwimming() && magnitude > 1.5 || player.isInWater() && magnitude > 0.5) {
                double swimSpeed = this.baseSwimSpeed;
                int depthStrider = 0;
                boolean dolphinsGrace = player.hasPotionEffect(PotionEffectType.DOLPHINS_GRACE);
                Vector dir = player.getLocation().getDirection().clone();
                ItemStack boots = player.getInventory().getBoots();
                if (Utils.isItemReal(boots)) {
                    depthStrider = boots.getEnchantmentLevel(Enchantment.DEPTH_STRIDER);
                }
                swimSpeed += 8.93 * (double)depthStrider;
                if (dolphinsGrace) {
                    swimSpeed += 9.8;
                }
                if (magnitude < swimSpeed) {
                    velocity.add(dir.normalize().multiply(new Vector(this.horizontalSpeedIncrement, this.verticalSpeedIncrement, this.horizontalSpeedIncrement)));
                    double vx = velocity.getX();
                    double vy = velocity.getY();
                    double vz = velocity.getZ();
                    double horMag = Math.sqrt(vx * vx + vz * vz);
                    if (horMag > this.maxHorizontalSpeed) {
                        velocity.setX(horMag > Math.abs(vx) ? vx : this.maxHorizontalSpeed * (double)(vx < 0.0 ? -1 : 1));
                        velocity.setZ(horMag > Math.abs(vz) ? vz : this.maxHorizontalSpeed * (double)(vz < 0.0 ? -1 : 1));
                    }
                    if (Math.abs(vy) > this.maxVerticalSpeed) {
                        velocity.setY(this.maxVerticalSpeed * (double)(vy < 0.0 ? -1 : 1));
                    }
                    player.setVelocity(velocity);
                }
            }
        } else {
            this.stop();
        }
    }

    @Override
    public boolean conditionsMet(@Nullable Player player) {
        return this.globalConditionsMet((LivingEntity)player) && this.allowedWorlds.contains(player.getWorld().getName()) && this.rsvPlayer.getBaubleDataModule().hasBauble("stone_sea");
    }

    @Override
    public void start() {
        int tickPeriod = this.config.getInt("Items.stone_sea.TickPeriod");
        this.runTaskTimer((Plugin)this.plugin, 0L, tickPeriod);
    }

    @Override
    public void stop() {
        tasks.remove(this.id);
        this.cancel();
    }

    public static boolean hasTask(UUID id) {
        return tasks.containsKey(id) && tasks.get(id) != null;
    }

    public static Map<UUID, StoneSeaTask> getTasks() {
        return tasks;
    }
}

