/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.baubles;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.UUID;
import me.val_mobile.baubles.BaubleModule;
import me.val_mobile.data.baubles.GUI;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class WormholeInventory
extends GUI {
    private final NavigableMap<UUID, Integer> players = new TreeMap<UUID, Integer>();
    private final Collection<Integer> notAllowed = List.of(Integer.valueOf(17), Integer.valueOf(18), Integer.valueOf(26), Integer.valueOf(27), Integer.valueOf(35), Integer.valueOf(36));
    private final FileConfiguration config;
    private int nextSlot = 10;

    public WormholeInventory(RSVPlugin plugin, BaubleModule module) {
        super(null, 54, "Wormhole Inventory");
        this.config = module.getUserConfig().getConfig();
        Inventory inv = this.getInventory();
        RSVItem guiGlass = RSVItem.getItem("gui_glass");
        int size = inv.getSize();
        for (int i = 0; i < size; ++i) {
            if (Utils.isItemReal(inv.getItem(i))) continue;
            inv.setItem(i, (ItemStack)guiGlass);
        }
    }

    public void addPlayer(Player player) {
        UUID id = player.getUniqueId();
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        ItemMeta meta = skull.getItemMeta();
        if (player.isOnline()) {
            ((SkullMeta)meta).setOwningPlayer((OfflinePlayer)Bukkit.getPlayer((UUID)id));
        } else {
            ((SkullMeta)meta).setOwningPlayer(Bukkit.getOfflinePlayer((UUID)id));
        }
        meta.setDisplayName(Utils.translateMsg(this.config.getString("WormholeInventory.SkullName"), (CommandSender)player, Map.of("PLAYER_NAME", player.getDisplayName())));
        skull.setItemMeta(meta);
        if (!this.players.containsKey(id) && this.nextSlot > 9 && this.nextSlot < 44) {
            if (this.notAllowed.contains(this.nextSlot)) {
                while (this.notAllowed.contains(this.nextSlot)) {
                    ++this.nextSlot;
                }
                this.players.put(id, this.nextSlot);
                this.getInventory().setItem(this.nextSlot, skull);
            } else {
                this.players.put(id, this.nextSlot);
                this.getInventory().setItem(this.nextSlot, skull);
                ++this.nextSlot;
            }
        }
    }

    public boolean containsPlayer(Player player) {
        if (this.players.containsKey(player.getUniqueId())) {
            return this.players.get(player.getUniqueId()) != null;
        }
        return false;
    }

    public void removePlayer(Player player) {
        if (this.containsPlayer(player)) {
            UUID id = player.getUniqueId();
            int slot = (Integer)this.players.get(id);
            if (((UUID)this.players.lastKey()).equals(id)) {
                this.players.remove(id);
                this.getInventory().setItem(slot, (ItemStack)RSVItem.getItem("gui_glass"));
                --this.nextSlot;
            } else {
                Map.Entry<UUID, Integer> lastEntry = this.players.lastEntry();
                UUID lastId = lastEntry.getKey();
                int lastSlot = lastEntry.getValue();
                this.players.put(lastId, slot);
                this.getInventory().setItem(slot, this.getInventory().getItem(lastSlot));
                this.getInventory().setItem(lastSlot, (ItemStack)RSVItem.getItem("gui_glass"));
                this.players.remove(id);
                this.nextSlot = lastSlot;
            }
        }
    }
}

