/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.data;

import java.util.HashSet;
import java.util.Set;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.Utils;
import me.val_mobile.utils.recipe.RSVAnvilRecipe;
import me.val_mobile.utils.recipe.RSVBrewingRecipe;
import me.val_mobile.utils.recipe.RSVCampfireRecipe;
import me.val_mobile.utils.recipe.RSVFurnaceRecipe;
import me.val_mobile.utils.recipe.RSVRecipe;
import me.val_mobile.utils.recipe.RSVShapedRecipe;
import me.val_mobile.utils.recipe.RSVShapelessRecipe;
import me.val_mobile.utils.recipe.RSVSmithingRecipe;
import me.val_mobile.utils.recipe.RSVSmokingRecipe;
import me.val_mobile.utils.recipe.RSVStonecuttingRecipe;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingRecipe;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.inventory.StonecuttingRecipe;

public class RecipeManager {
    private final Set<NamespacedKey> recipeKeys = new HashSet<NamespacedKey>();
    private final Set<RSVAnvilRecipe> anvilRecipes = new HashSet<RSVAnvilRecipe>();
    private final Set<RSVBrewingRecipe> brewingRecipes = new HashSet<RSVBrewingRecipe>();
    private final RSVPlugin plugin;
    private final FileConfiguration recipeConfig;
    private final FileConfiguration userConfig;

    public RecipeManager(RSVPlugin plugin, FileConfiguration recipeConfig, FileConfiguration userConfig) {
        this.plugin = plugin;
        this.recipeConfig = recipeConfig;
        this.userConfig = userConfig;
        this.initialize();
    }

    public void initialize() {
        Set keys = this.recipeConfig.getKeys(false);
        for (String name : keys) {
            Recipe recipe;
            String type = this.recipeConfig.getString(name + ".Type");
            if (type == null) continue;
            if (this.userConfig == null) {
                recipe = this.getRecipe(type, name);
                this.addRecipe(recipe);
                continue;
            }
            if (this.userConfig.getBoolean("Recipes." + name + ".Enabled.EnableAllVersions")) {
                recipe = this.getRecipe(type, name);
                this.addRecipe(recipe);
                continue;
            }
            if (this.userConfig.contains("Recipes." + name + ".Enabled.Versions." + Utils.getMinecraftVersion(true))) {
                if (!this.userConfig.getBoolean("Recipes." + name + ".Enabled.Versions." + Utils.getMinecraftVersion(true))) continue;
                recipe = this.getRecipe(type, name);
                this.addRecipe(recipe);
                continue;
            }
            recipe = this.getRecipe(type, name);
            this.addRecipe(recipe);
        }
    }

    public Recipe getRecipe(String type, String recipeName) {
        RSVRecipe recipe = null;
        switch (type) {
            case "Shaped": {
                try {
                    recipe = new RSVShapedRecipe(this.recipeConfig, recipeName, this.plugin);
                    this.recipeKeys.add(((ShapedRecipe)recipe).getKey());
                }
                catch (Exception exception) {}
                break;
            }
            case "Shapeless": {
                if (Utils.isServerRunningPaper()) {
                    try {
                        recipe = new RSVShapelessRecipe(this.recipeConfig, recipeName, this.plugin);
                        this.recipeKeys.add(((ShapelessRecipe)recipe).getKey());
                    }
                    catch (Exception exception) {}
                    break;
                }
                try {
                    recipe = new RSVShapedRecipe(this.recipeConfig, recipeName, this.plugin);
                    this.recipeKeys.add(((ShapedRecipe)recipe).getKey());
                }
                catch (Exception exception) {}
                break;
            }
            case "Smithing": {
                try {
                    recipe = new RSVSmithingRecipe(this.recipeConfig, recipeName, this.plugin);
                    this.recipeKeys.add(((SmithingRecipe)recipe).getKey());
                }
                catch (Exception exception) {}
                break;
            }
            case "Furnace": {
                try {
                    recipe = new RSVFurnaceRecipe(this.recipeConfig, recipeName, this.plugin);
                    this.recipeKeys.add(((FurnaceRecipe)recipe).getKey());
                }
                catch (Exception exception) {}
                break;
            }
            case "Campfire": {
                try {
                    recipe = new RSVCampfireRecipe(this.recipeConfig, recipeName, this.plugin);
                    this.recipeKeys.add(((CampfireRecipe)recipe).getKey());
                }
                catch (Exception exception) {}
                break;
            }
            case "Smoker": {
                try {
                    recipe = new RSVSmokingRecipe(this.recipeConfig, recipeName, this.plugin);
                    this.recipeKeys.add(((SmokingRecipe)recipe).getKey());
                }
                catch (Exception exception) {}
                break;
            }
            case "Stonecutting": {
                try {
                    recipe = new RSVStonecuttingRecipe(this.recipeConfig, recipeName, this.plugin);
                    this.recipeKeys.add(((StonecuttingRecipe)recipe).getKey());
                }
                catch (Exception exception) {}
                break;
            }
            case "Anvil": {
                try {
                    recipe = new RSVAnvilRecipe(this.recipeConfig, recipeName);
                    this.anvilRecipes.add((RSVAnvilRecipe)recipe);
                }
                catch (Exception exception) {}
                break;
            }
            case "Brewing": {
                try {
                    recipe = new RSVBrewingRecipe(this.recipeConfig, recipeName, this.plugin);
                    this.brewingRecipes.add((RSVBrewingRecipe)recipe);
                }
                catch (Exception exception) {}
                break;
            }
            default: {
                return null;
            }
        }
        return recipe;
    }

    public void addRecipe(Recipe r) {
        Keyed keyed;
        if (r != null && !(r instanceof RSVBrewingRecipe) && !(r instanceof RSVAnvilRecipe) && r instanceof Keyed && Bukkit.getRecipe((NamespacedKey)(keyed = (Keyed)r).getKey()) == null) {
            Bukkit.addRecipe((Recipe)r);
        }
    }

    public Set<NamespacedKey> getRecipeKeys() {
        return this.recipeKeys;
    }

    public Set<RSVAnvilRecipe> getAnvilRecipes() {
        return this.anvilRecipes;
    }

    public Set<RSVBrewingRecipe> getBrewingRecipes() {
        return this.brewingRecipes;
    }
}

