/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.iceandfire;

import me.val_mobile.data.RSVModule;
import me.val_mobile.iceandfire.Dragon;
import me.val_mobile.iceandfire.LightningBreath;
import me.val_mobile.iceandfire.LightningExplosionAttack;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.spartanandfire.ElectrocuteTask;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.LivingEntity;

public interface LightningDragon
extends Dragon {
    public static final FileConfiguration CONFIG = RSVModule.getModule("IceandFire").getUserConfig().getConfig();

    @Override
    default public void performMeleeAttack(LivingEntity entity) {
        double stageMultiplier = CONFIG.getDouble("Dragon.LightningDragon.MeleeAttack.StageMultiplier.Stage" + this.getStage());
        entity.damage(CONFIG.getDouble("Dragon.LightningDragon.MeleeAttack.BaseDamage") * stageMultiplier, this.getEntity());
    }

    @Override
    default public void performSpecialAbility(LivingEntity entity) {
        Location loc = entity.getLocation();
        if (CONFIG.getBoolean("Dragon.LightningDragon.ElectrocuteAbility.SummonCosmeticLightning")) {
            loc.getWorld().strikeLightningEffect(loc);
        } else {
            loc.getWorld().strikeLightning(loc);
        }
        if (!ElectrocuteTask.hasTask(entity.getUniqueId())) {
            new ElectrocuteTask(RSVPlugin.getPlugin(), this.getStage(), (Damageable)entity).start();
        }
    }

    @Override
    default public void triggerBreathAttack(Location target) {
        new LightningBreath(this, target, RSVPlugin.getPlugin()).start();
    }

    @Override
    default public void triggerExplosionAttack(Location target) {
        new LightningExplosionAttack(this, target, RSVPlugin.getPlugin()).start();
    }
}

