/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.integrations;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagConflictException;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import javax.annotation.Nonnull;
import me.val_mobile.integrations.ProtectionPlugin;
import me.val_mobile.rsv.RSVPlugin;
import org.bukkit.Location;

public class WorldGuard
extends ProtectionPlugin {
    public static final String NAME = "WorldGuard";

    public WorldGuard(RSVPlugin plugin) {
        super(plugin, NAME);
        if (this.isIntegrated) {
            FlagRegistry registry = com.sk89q.worldguard.WorldGuard.getInstance().getFlagRegistry();
            try {
                StateFlag flag = new StateFlag("rsv-throwing", true);
                registry.register((Flag)flag);
            }
            catch (FlagConflictException e) {
                Flag existing = registry.get("rsv-throwing");
                if (existing instanceof StateFlag) {
                    // empty if block
                }
            }
        }
    }

    @Override
    public boolean otherLoadOptions() {
        return true;
    }

    @Override
    public boolean isPvpAllowed(@Nonnull Location loc) {
        RegionContainer container = com.sk89q.worldguard.WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        ApplicableRegionSet set = query.getApplicableRegions(BukkitAdapter.adapt((Location)loc));
        return set.testState(null, new StateFlag[]{Flags.PVP});
    }

    @Override
    public boolean isMobGriefingAllowed(@Nonnull Location loc) {
        RegionContainer container = com.sk89q.worldguard.WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        ApplicableRegionSet set = query.getApplicableRegions(BukkitAdapter.adapt((Location)loc));
        return set.testState(null, new StateFlag[]{Flags.MOB_DAMAGE});
    }
}

