/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.misc;

import java.util.Collection;
import java.util.Set;
import me.val_mobile.data.RSVModule;
import me.val_mobile.data.RSVPlayer;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.PlayerJumpEvent;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.Utils;
import me.val_mobile.utils.recipe.RSVAnvilRecipe;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Statistic;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.inventory.PrepareSmithingEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.player.PlayerItemMendEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerStatisticIncrementEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MiscEvents
implements Listener {
    private final RSVPlugin plugin;

    public MiscEvents(RSVPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!RSVPlayer.isValidPlayer(player)) {
            RSVPlayer rsvplayer = new RSVPlayer(player);
            rsvplayer.retrieveData();
        }
        Collection<RSVModule> rsvModules = RSVModule.getModules().values();
        for (RSVModule module : rsvModules) {
            if (!module.isGloballyEnabled() || !module.getAllowedWorlds().contains(player.getWorld().getName())) continue;
            Set<NamespacedKey> keys = module.getModuleRecipes().getRecipeKeys();
            FileConfiguration config = module.getUserConfig().getConfig();
            for (NamespacedKey key : keys) {
                if (!config.getBoolean("Recipes." + key.getKey() + ".Unlock")) continue;
                Utils.discoverRecipe(player, Bukkit.getRecipe((NamespacedKey)key));
            }
        }
    }

    @EventHandler
    public void onCraft(PrepareItemCraftEvent event) {
        Recipe r = event.getRecipe();
        if (r != null) {
            Keyed keyed;
            NamespacedKey key;
            ItemStack[] matrix = event.getInventory().getMatrix();
            if (event.isRepair()) {
                ItemStack first = null;
                ItemStack second = null;
                boolean firstRSVItem = false;
                boolean secondRSVItem = false;
                for (ItemStack item : matrix) {
                    if (Utils.isItemReal(item)) {
                        if (first == null) {
                            first = item;
                            firstRSVItem = RSVItem.isRSVItem(item);
                        } else {
                            second = item;
                            secondRSVItem = RSVItem.isRSVItem(item);
                        }
                    }
                    if (first != null && second != null) break;
                }
                if (firstRSVItem || secondRSVItem) {
                    if (firstRSVItem && secondRSVItem) {
                        if (RSVItem.getNameFromItem(first).equals(RSVItem.getNameFromItem(second))) {
                            boolean hasCustomDur = Utils.hasCustomDurability(first);
                            int maxDur = hasCustomDur ? Utils.getMaxCustomDurability(first) : Utils.getMaxVanillaDurability(first);
                            int firstDur = hasCustomDur ? Utils.getCustomDurability(first) : Utils.getVanillaDurability(first);
                            int secondDur = hasCustomDur ? Utils.getCustomDurability(second) : Utils.getVanillaDurability(second);
                            int total = (int)Math.min((double)(firstDur + secondDur) + Math.floor((double)maxDur / 20.0), (double)maxDur);
                            RSVItem result = RSVItem.getItem(RSVItem.getNameFromItem(first));
                            Utils.changeDurability(result, total - maxDur, false, false, null);
                            event.getInventory().setResult((ItemStack)result);
                        } else {
                            event.getInventory().setResult(null);
                        }
                    } else {
                        event.getInventory().setResult(null);
                    }
                }
            }
            if (r instanceof Keyed && (key = (keyed = (Keyed)r).getKey()).getNamespace().equals("minecraft")) {
                block6 : switch (key.getKey()) {
                    case "dark_prismarine": 
                    case "prismarine": 
                    case "prismarine_bricks": 
                    case "sea_lantern": {
                        for (ItemStack item : matrix) {
                            if (!RSVItem.isRSVItem(item)) continue;
                            event.getInventory().setResult(null);
                            break block6;
                        }
                        break;
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onSmithing(PrepareSmithingEvent event) {
        ItemStack base;
        SmithingInventory inv = event.getInventory();
        if (Utils.isNetheriteRecipe(inv) && RSVItem.isRSVItem(base = Utils.getMinecraftVersion(false).compareTo("1.20") >= 0 ? inv.getItem(1) : inv.getItem(0))) {
            String rsvName;
            switch (rsvName = RSVItem.getNameFromItem(base)) {
                case "diamond_rapier": 
                case "diamond_greatsword": 
                case "diamond_longsword": 
                case "diamond_spear": 
                case "diamond_saber": 
                case "diamond_boomerang": 
                case "diamond_dagger": 
                case "diamond_glaive": 
                case "diamond_halberd": 
                case "diamond_hammer": 
                case "diamond_javelin": 
                case "diamond_lance": 
                case "diamond_mace": 
                case "diamond_pike": 
                case "diamond_quarterstaff": 
                case "diamond_tomahawk": 
                case "diamond_throwing_knife": 
                case "diamond_warhammer": 
                case "diamond_battleaxe": 
                case "diamond_longbow": 
                case "diamond_crossbow": 
                case "diamond_knife": 
                case "diamond_saw": 
                case "diamond_mattock": {
                    FileConfiguration userConfig = RSVModule.getModule(RSVItem.getModuleNameFromItem(base)).getUserConfig().getConfig();
                    if (userConfig.getBoolean("Recipes." + rsvName + ".Enabled.EnableAllVersions")) {
                        event.setResult(Utils.getNetheriteRSVWeapon(base));
                        break;
                    }
                    if (userConfig.contains("Recipes." + rsvName + ".Enabled.Versions." + Utils.getMinecraftVersion(true))) {
                        if (userConfig.getBoolean("Recipes." + rsvName + ".Enabled.Versions." + Utils.getMinecraftVersion(true))) {
                            event.setResult(Utils.getNetheriteRSVWeapon(base));
                            break;
                        }
                        event.setResult(null);
                        break;
                    }
                    event.setResult(null);
                    break;
                }
                default: {
                    event.setResult(null);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDurability(PlayerItemDamageEvent event) {
        ItemStack item = event.getItem();
        if (!event.isCancelled() && RSVItem.isRSVItem(item) && Utils.hasCustomDurability(item)) {
            Utils.changeDurability(item, -event.getDamage(), true, true, (Entity)event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDurability(PlayerItemMendEvent event) {
        ItemStack item = event.getItem();
        if (!event.isCancelled() && RSVItem.isRSVItem(item) && Utils.hasCustomDurability(item)) {
            int customDif = Utils.getMaxCustomDurability(item) - Utils.getCustomDurability(item);
            int dif = Utils.getMaxVanillaDurability(item) - Utils.getVanillaDurability(item);
            Utils.changeDurability(item, (int)Math.ceil((double)event.getRepairAmount() * (double)customDif / (double)dif), false, false, (Entity)event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onIncrementStatistics(PlayerStatisticIncrementEvent event) {
        Player player;
        Location loc;
        Block block;
        Material blockMaterial;
        if (!(event.isCancelled() || event.getStatistic() != Statistic.JUMP || Tag.CLIMBABLE.isTagged((Keyed)(blockMaterial = (block = (loc = (player = event.getPlayer()).getLocation()).getBlock()).getType())) || block.isLiquid() || player.isRiptiding() || player.isFlying() || player.isSwimming())) {
            Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerJumpEvent(event.getPlayer()));
        }
    }

    @EventHandler
    public void onAnvil(PrepareAnvilEvent event) {
        AnvilInventory inv = event.getInventory();
        Set<RSVAnvilRecipe> anvilRecipes = this.plugin.getMiscRecipes().getAnvilRecipes();
        for (RSVAnvilRecipe recipe : anvilRecipes) {
            if (!recipe.isValidRecipe(inv)) continue;
            recipe.useRecipe(event);
            break;
        }
        ItemStack result = event.getResult();
        ItemStack first = inv.getItem(0);
        ItemStack second = inv.getItem(1);
        if (RSVItem.isRSVItem(first) || RSVItem.isRSVItem(second)) {
            if (Utils.isItemReal(result)) {
                if (RSVItem.isRSVItem(first)) {
                    if (RSVItem.isRSVItem(second)) {
                        if (RSVItem.getNameFromItem(first).equals(RSVItem.getNameFromItem(second))) {
                            if (Utils.hasCustomDurability(first)) {
                                int maxDur = Utils.getMaxCustomDurability(first);
                                int total = Math.min(Utils.getCustomDurability(first) + Utils.getCustomDurability(second), maxDur);
                                if (first.getItemMeta().hasEnchant(Enchantment.DAMAGE_ALL) || second.getItemMeta().hasEnchant(Enchantment.DAMAGE_ALL)) {
                                    Utils.updateDamageLore(result, result.getItemMeta().getEnchants().entrySet());
                                }
                                int resultDur = Math.min(Utils.getCustomDurability(result), maxDur);
                                Utils.changeDurability(result, -resultDur + total, false, false, null);
                                event.setResult(result);
                            }
                        } else {
                            event.setResult(null);
                        }
                    } else if (Utils.isItemReal(second)) {
                        ItemMeta total = second.getItemMeta();
                        if (total instanceof EnchantmentStorageMeta) {
                            EnchantmentStorageMeta enchMeta = (EnchantmentStorageMeta)total;
                            if (enchMeta.hasStoredEnchant(Enchantment.DAMAGE_ALL)) {
                                Utils.updateDamageLore(result, result.getItemMeta().getEnchants().entrySet());
                                event.setResult(result);
                            }
                        } else if (RSVItem.getItem(RSVItem.getNameFromItem(first)).getRepairIng().test(second) && Utils.getDurability(first) < Utils.getMaxDurability(first)) {
                            int change = (int)Math.round((double)Utils.getMaxDurability(first) * 0.25 * (double)second.getAmount());
                            Utils.changeDurability(result, change, false, false, null);
                            event.setResult(result);
                        } else {
                            event.setResult(null);
                        }
                    }
                } else {
                    event.setResult(null);
                }
            } else if (RSVItem.isRSVItem(first) && RSVItem.getItem(RSVItem.getNameFromItem(first)).getRepairIng().test(second) && Utils.getDurability(first) < Utils.getMaxDurability(first)) {
                result = first.clone();
                int change = Utils.getDurability(result);
                change = (int)((double)change * (0.25 * (double)second.getAmount()));
                Utils.changeDurability(result, change, false, false, null);
                event.setResult(result);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEnchant(EnchantItemEvent event) {
        if (!event.isCancelled()) {
            Utils.updateDamageLore(event.getItem(), event.getEnchantsToAdd().entrySet());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        if (!event.isCancelled()) {
            String[] args;
            final Player player = event.getPlayer();
            String message = event.getMessage();
            if (message.length() > 1 && (args = message.substring(1).split(" "))[0].equalsIgnoreCase("enchant")) {
                new BukkitRunnable(this){

                    public void run() {
                        if (Utils.isItemReal(player.getInventory().getItemInMainHand())) {
                            Utils.updateDamageLore(player.getInventory().getItemInMainHand(), player.getInventory().getItemInMainHand().getItemMeta().getEnchants().entrySet());
                        }
                    }
                }.runTaskLater((Plugin)this.plugin, 1L);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onServerCommand(ServerCommandEvent event) {
        String[] args;
        String message;
        if (!event.isCancelled() && (message = event.getCommand()).length() > 1 && (args = message.substring(1).split(" "))[0].equalsIgnoreCase("enchant") && args.length > 1 && args[1] != null && !args[1].isEmpty()) {
            final Player player = Bukkit.getPlayer((String)args[1]);
            new BukkitRunnable(this){

                public void run() {
                    if (Utils.isItemReal(player.getInventory().getItemInMainHand())) {
                        Utils.updateDamageLore(player.getInventory().getItemInMainHand(), player.getInventory().getItemInMainHand().getItemMeta().getEnchants().entrySet());
                    }
                }
            }.runTaskLater((Plugin)this.plugin, 1L);
        }
    }
}

