/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.ntp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import me.val_mobile.data.ModuleEvents;
import me.val_mobile.data.ModuleItems;
import me.val_mobile.misc.PlayerItemAcquireEvent;
import me.val_mobile.ntp.CeramicBucketMeltTask;
import me.val_mobile.ntp.FireStarterTask;
import me.val_mobile.ntp.NtpModule;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.ToolHandler;
import me.val_mobile.utils.Utils;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Furnace;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class NtpEvents
extends ModuleEvents
implements Listener {
    private final FileConfiguration config;
    private final ModuleItems moduleItems;
    private final NtpModule module;
    private final RSVPlugin plugin;

    public NtpEvents(NtpModule module, RSVPlugin plugin) {
        super(module, plugin);
        this.module = module;
        this.plugin = plugin;
        this.config = module.getUserConfig().getConfig();
        this.moduleItems = module.getModuleItems();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        String name;
        Player player = event.getPlayer();
        if (!this.shouldEventBeRan((Entity)player)) {
            return;
        }
        ItemStack itemMainHand = player.getInventory().getItemInMainHand();
        Block block = event.getBlock();
        Material material = block.getType();
        if (this.config.getBoolean("PreventPunchingWood.Enabled") && Utils.matchMaterial(material, this.config.getStringList("PreventPunchingWood.WoodBlocks"), false) && !Utils.isHoldingAxe(player)) {
            event.setDropItems(false);
        }
        if (this.config.getBoolean("PlantFiberGathering.Enabled") && RSVItem.isRSVItem(itemMainHand) && ((name = RSVItem.getNameFromItem(itemMainHand)).contains("dagger") || name.contains("knife")) && !itemMainHand.getItemMeta().hasEnchant(Enchantment.SILK_TOUCH) && Utils.matchMaterial(material, this.config.getConfigurationSection("PlantFiberGathering.BlockDrops").getKeys(false), true)) {
            RSVItem plantFiber = RSVItem.getItem("plant_fiber");
            Utils.changeDurability(itemMainHand, -1, true, true, (Entity)player);
            Utils.dropLooting(this.config.getConfigurationSection("PlantFiberGathering.BlockDrops." + String.valueOf(material)), plantFiber, itemMainHand, block.getLocation(), true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!this.shouldEventBeRan((Entity)player)) {
            return;
        }
        ItemStack item = event.getItem();
        Action action = event.getAction();
        UUID id = player.getUniqueId();
        Block block = event.getClickedBlock();
        if (action == Action.LEFT_CLICK_BLOCK) {
            Material blockMat = block.getType();
            if (this.config.getBoolean("FlintKnapping.Enabled") && Utils.isItemReal(item) && item.getType() == Material.FLINT && !RSVItem.isRSVItem(item) && this.config.getConfigurationSection("FlintKnapping.BlockDrops").getKeys(false).contains(blockMat.toString())) {
                ItemStack flintShard = this.moduleItems.getItems().get("flint_shard");
                if (this.config.getBoolean("FlintKnapping.BlockDrops." + String.valueOf(blockMat) + ".Sound.Enabled")) {
                    Utils.playSound(player.getLocation(), this.config.getString("FlintKnapping.BlockDrops." + String.valueOf(blockMat) + ".Sound.Sound"), (float)this.config.getDouble("FlintKnapping.BlockDrops." + String.valueOf(blockMat) + ".Sound.Volume"), (float)this.config.getDouble("FlintKnapping.BlockDrops." + String.valueOf(blockMat) + ".Sound.Pitch"));
                }
                if (Utils.dropLooting(this.config.getConfigurationSection("FlintKnapping.BlockDrops." + String.valueOf(blockMat)), flintShard, null, block.getLocation().add(0.0, 0.15, 0.0), true)) {
                    if (item.getAmount() > 0) {
                        item.setAmount(item.getAmount() - 1);
                    } else {
                        item.setType(Material.AIR);
                    }
                }
            }
        } else if (action == Action.RIGHT_CLICK_BLOCK) {
            Material blockMat = block.getType();
            if (Utils.isItemReal(item) && Utils.isHoldingAxe(player)) {
                if (Tag.LOGS.isTagged((Keyed)blockMat) || blockMat.toString().equals("BAMBOO_BLOCK") || blockMat.toString().equals("STRIPPED_BAMBOO_BLOCK")) {
                    if (RSVItem.isRSVItem(item) && RSVItem.getNameFromItem(item).contains("mattock")) {
                        tool = Utils.getBestTool(blockMat);
                        switch (tool) {
                            case NONE: 
                            case SHEARS: {
                                break;
                            }
                            default: {
                                type = item.getType().toString();
                                item.setType(Material.valueOf((String)(type.substring(0, type.indexOf("_") + 1) + String.valueOf((Object)tool))));
                            }
                        }
                    }
                    blockLoc = block.getLocation();
                    pLoc = player.getLocation();
                    if (Utils.getBlockFace((LivingEntity)player) == BlockFace.UP && pLoc.distanceSquared(blockLoc) < 2.25 && Utils.roll(this.config.getDouble("Lumberjack.PlankDrops.Chance"))) {
                        ItemStack drop = new ItemStack(Utils.getRespectivePlank(blockMat));
                        Utils.dropFortune(this.config.getConfigurationSection("Lumberjack.PlankDrops"), drop, event.getItem(), block.getLocation());
                        block.setType(Material.AIR);
                        event.setCancelled(true);
                    }
                } else if (Tag.PLANKS.isTagged((Keyed)blockMat)) {
                    if (RSVItem.isRSVItem(item) && RSVItem.getNameFromItem(item).contains("mattock")) {
                        tool = Utils.getBestTool(blockMat);
                        switch (tool) {
                            case NONE: 
                            case SHEARS: {
                                break;
                            }
                            default: {
                                type = item.getType().toString();
                                item.setType(Material.valueOf((String)(type.substring(0, type.indexOf("_") + 1) + String.valueOf((Object)tool))));
                            }
                        }
                    }
                    blockLoc = block.getLocation();
                    pLoc = player.getLocation();
                    if (Utils.getBlockFace((LivingEntity)player) == BlockFace.UP && pLoc.distanceSquared(blockLoc) < 2.25 && Utils.roll(this.config.getDouble("Lumberjack.StickDrops.Chance"))) {
                        Utils.dropFortune(this.config.getConfigurationSection("Lumberjack.StickDrops"), new ItemStack(Material.STICK), item, block.getLocation());
                        block.setType(Material.AIR);
                        event.setCancelled(true);
                    }
                }
            }
            if (RSVItem.isRSVItem(item)) {
                block14 : switch (RSVItem.getNameFromItem(item)) {
                    case "copper_mattock": 
                    case "iron_mattock": 
                    case "golden_mattock": 
                    case "diamond_mattock": 
                    case "netherite_mattock": {
                        boolean isNotAxe;
                        Block b = event.getClickedBlock();
                        Material blockMaterial = b.getType();
                        String matName = item.getType().toString();
                        boolean isNotHoe = !matName.contains("HOE");
                        boolean isNotShovel = !matName.contains("SHOVEL");
                        boolean bl = isNotAxe = !matName.contains("AXE");
                        if (Tag.LOGS.isTagged((Keyed)blockMaterial) && !blockMaterial.toString().contains("STRIPPED") && isNotAxe) {
                            Utils.playSound(player.getLocation(), Sound.ITEM_AXE_STRIP.toString(), 1.0f, 1.0f);
                            b.setType(Material.valueOf((String)("STRIPPED_" + String.valueOf(blockMaterial))));
                            Utils.changeDurability(item, -1, true, true, (Entity)player);
                            break;
                        }
                        if (!isNotHoe && !isNotShovel) break;
                        if (isNotHoe && isNotShovel) {
                            switch (blockMaterial) {
                                case GRASS_BLOCK: 
                                case DIRT: {
                                    if (player.isSneaking()) {
                                        Utils.playSound(player.getLocation(), Sound.ITEM_SHOVEL_FLATTEN.toString(), 1.0f, 1.0f);
                                        b.setType(Material.DIRT_PATH);
                                    } else {
                                        Utils.playSound(player.getLocation(), Sound.ITEM_HOE_TILL.toString(), 1.0f, 1.0f);
                                        b.setType(Material.FARMLAND);
                                    }
                                    Utils.changeDurability(item, -1, true, true, (Entity)player);
                                    break block14;
                                }
                                case COARSE_DIRT: 
                                case PODZOL: 
                                case MYCELIUM: {
                                    if (player.isSneaking()) {
                                        Utils.playSound(player.getLocation(), Sound.ITEM_SHOVEL_FLATTEN.toString(), 1.0f, 1.0f);
                                        b.setType(Material.DIRT_PATH);
                                    } else {
                                        Utils.playSound(player.getLocation(), Sound.ITEM_HOE_TILL.toString(), 1.0f, 1.0f);
                                        b.setType(Material.DIRT);
                                    }
                                    Utils.changeDurability(item, -1, true, true, (Entity)player);
                                    break block14;
                                }
                                case DIRT_PATH: {
                                    Utils.playSound(player.getLocation(), Sound.ITEM_HOE_TILL.toString(), 1.0f, 1.0f);
                                    b.setType(Material.FARMLAND);
                                    Utils.changeDurability(item, -1, true, true, (Entity)player);
                                    break block14;
                                }
                                case ROOTED_DIRT: {
                                    if (player.isSneaking()) {
                                        Utils.playSound(player.getLocation(), Sound.ITEM_SHOVEL_FLATTEN.toString(), 1.0f, 1.0f);
                                        b.setType(Material.DIRT_PATH);
                                    } else {
                                        Utils.playSound(player.getLocation(), Sound.ITEM_HOE_TILL.toString(), 1.0f, 1.0f);
                                        player.getWorld().dropItemNaturally(b.getLocation(), new ItemStack(Material.HANGING_ROOTS));
                                        b.setType(Material.DIRT);
                                    }
                                    Utils.changeDurability(item, -1, true, true, (Entity)player);
                                    break block14;
                                }
                            }
                            break;
                        }
                        if (isNotHoe) {
                            switch (blockMaterial) {
                                case GRASS_BLOCK: 
                                case DIRT: {
                                    if (player.isSneaking()) {
                                        Utils.playSound(player.getLocation(), Sound.ITEM_HOE_TILL.toString(), 1.0f, 1.0f);
                                        b.setType(Material.FARMLAND);
                                    }
                                    Utils.changeDurability(item, -1, true, true, (Entity)player);
                                    break block14;
                                }
                                case COARSE_DIRT: 
                                case PODZOL: 
                                case MYCELIUM: {
                                    if (player.isSneaking()) {
                                        Utils.playSound(player.getLocation(), Sound.ITEM_SHOVEL_FLATTEN.toString(), 1.0f, 1.0f);
                                        b.setType(Material.DIRT);
                                    }
                                    Utils.changeDurability(item, -1, true, true, (Entity)player);
                                    break block14;
                                }
                                case ROOTED_DIRT: {
                                    if (player.isSneaking()) {
                                        Utils.playSound(player.getLocation(), Sound.ITEM_HOE_TILL.toString(), 1.0f, 1.0f);
                                        player.getWorld().dropItemNaturally(b.getLocation(), new ItemStack(Material.HANGING_ROOTS));
                                        b.setType(Material.DIRT);
                                    }
                                    Utils.changeDurability(item, -1, true, true, (Entity)player);
                                    break block14;
                                }
                            }
                            break;
                        }
                        switch (blockMaterial) {
                            case GRASS_BLOCK: 
                            case DIRT: 
                            case COARSE_DIRT: 
                            case PODZOL: 
                            case MYCELIUM: 
                            case ROOTED_DIRT: {
                                if (player.isSneaking()) {
                                    Utils.playSound(player.getLocation(), Sound.ITEM_SHOVEL_FLATTEN.toString(), 1.0f, 1.0f);
                                    b.setType(Material.DIRT_PATH);
                                }
                                Utils.changeDurability(item, -1, true, true, (Entity)player);
                                break block14;
                            }
                        }
                        break;
                    }
                    case "fire_starter": {
                        if (!this.config.getBoolean("FireStarter.Enabled") || !player.isSneaking()) break;
                        double maxDistance = this.config.getDouble("FireStarter.MaxDistance");
                        boolean needsFuel = this.config.getBoolean("FireStarter.Fuel.Required");
                        boolean needsKindling = this.config.getBoolean("FireStarter.Kindling.Required");
                        int requiredFuel = needsFuel ? this.config.getInt("FireStarter.Fuel.Amount") : 0;
                        int requiredKindling = needsKindling ? this.config.getInt("FireStarter.Kindling.Amount") : 0;
                        int requiredSoulItems = this.config.getInt("FireStarter.SoulItems.Amount");
                        int fuel = 0;
                        int kindling = 0;
                        int soul = 0;
                        List<Material> fuelMats = Utils.getMaterialsFromList(this.config.getStringList("FireStarter.Fuel.Materials"));
                        List<Material> kindlingMats = Utils.getMaterialsFromList(this.config.getStringList("FireStarter.Kindling.Materials"));
                        List<Material> soulMats = Utils.getMaterialsFromList(this.config.getStringList("FireStarter.SoulItems.Materials"));
                        Location loc = block.getLocation();
                        if (!block.isPassable()) {
                            loc.setY(loc.getY() + 1.0);
                        }
                        Predicate<Entity> filter = entity -> entity instanceof Item;
                        Collection entities = loc.getWorld().getNearbyEntities(loc, maxDistance, maxDistance, maxDistance, filter);
                        ArrayList<Item> ingredients = new ArrayList<Item>();
                        if (entities.size() > this.config.getInt("FireStarter.MaxItems")) break;
                        for (Entity e : entities) {
                            Item i = (Item)e;
                            ItemStack drop = i.getItemStack();
                            Material mat = drop.getType();
                            if (needsFuel && fuelMats.contains(mat)) {
                                fuel += drop.getAmount();
                                ingredients.add(i);
                            }
                            if (needsKindling && kindlingMats.contains(mat)) {
                                kindling += drop.getAmount();
                                ingredients.add(i);
                            }
                            if (!soulMats.contains(mat)) continue;
                            soul += drop.getAmount();
                            ingredients.add(i);
                        }
                        if (fuel < requiredFuel || kindling < requiredKindling || FireStarterTask.hasTask(id)) break;
                        new FireStarterTask(this.plugin, this.module, player, loc.add(0.0, 0.6, 0.0), ingredients, soul >= requiredSoulItems).start();
                        Utils.changeDurability(item, -1, true, true, (Entity)player);
                        break;
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockDamage(BlockDamageEvent event) {
        Player player = event.getPlayer();
        if (!this.shouldEventBeRan((Entity)player)) {
            return;
        }
        ItemStack item = event.getItemInHand();
        if (!(RSVItem.isRSVItem(item) && RSVItem.getModuleNameFromItem(item).equals("NoTreePunching") && RSVItem.getNameFromItem(item).contains("mattock"))) {
            return;
        }
        Block block = event.getBlock();
        Material blockMat = block.getType();
        ToolHandler.Tool tool = Utils.getBestTool(blockMat);
        switch (tool) {
            case NONE: 
            case SHEARS: {
                break;
            }
            default: {
                String type = item.getType().toString();
                item.setType(Material.valueOf((String)(type.substring(0, type.indexOf("_") + 1) + String.valueOf((Object)tool))));
            }
        }
    }

    @EventHandler
    public void onPrepareCraft(PrepareItemCraftEvent event) {
        int durability;
        Recipe recipe = event.getRecipe();
        if (!this.shouldEventBeRan((Entity)event.getView().getPlayer())) {
            return;
        }
        if (recipe != null) {
            ShapedRecipe shaped;
            NamespacedKey key;
            if (recipe instanceof ShapelessRecipe) {
                ShapelessRecipe shapeless = (ShapelessRecipe)recipe;
                key = shapeless.getKey();
                if (key.getNamespace().equals("minecraft")) {
                    switch (key.getKey()) {
                        case "acacia_planks": 
                        case "birch_planks": 
                        case "crimson_planks": 
                        case "dark_oak_planks": 
                        case "jungle_planks": 
                        case "mangrove_planks": 
                        case "oak_planks": 
                        case "spruce_planks": 
                        case "warped_planks": 
                        case "cherry_planks": 
                        case "bamboo_planks": 
                        case "pale_oak_planks": {
                            if (!this.config.getBoolean("Lumberjack.DisablePlankRecipes")) break;
                            event.getInventory().setResult(null);
                            break;
                        }
                    }
                }
            } else if (recipe instanceof ShapedRecipe && (key = (shaped = (ShapedRecipe)recipe).getKey()).getNamespace().equals("minecraft")) {
                switch (key.getKey()) {
                    case "stick": {
                        if (!this.config.getBoolean("Lumberjack.DisableStickRecipes")) break;
                        event.getInventory().setResult(null);
                        break;
                    }
                    case "campfire": 
                    case "soul_campfire": {
                        if (!this.config.getBoolean("FireStarter.DisableVanillaCampfireRecipes")) break;
                        event.getInventory().setResult(null);
                        break;
                    }
                    case "flower_pot": {
                        if (!this.config.getBoolean("Pottery.DisableFlowerPotRecipe")) break;
                        event.getInventory().setResult(null);
                        break;
                    }
                }
            }
        }
        ItemStack[] matrix = event.getInventory().getMatrix();
        int clayToolIndex = -1;
        int clayIndex = -1;
        int sawIndex = -1;
        int woodIndex = -1;
        int planksIndex = -1;
        for (int i = 0; i < matrix.length; ++i) {
            ItemStack item = matrix[i];
            if (!Utils.isItemReal(item)) continue;
            Material mat = item.getType();
            if (mat == Material.CLAY_BALL) {
                clayIndex = clayIndex == -1 ? i : -2;
                continue;
            }
            if (Tag.LOGS.isTagged((Keyed)mat)) {
                woodIndex = woodIndex == -1 ? i : -2;
                continue;
            }
            if (Tag.PLANKS.isTagged((Keyed)mat)) {
                planksIndex = planksIndex == -1 ? i : -2;
                continue;
            }
            if (!RSVItem.isRSVItem(item)) continue;
            if (RSVItem.getNameFromItem(item).equals("clay_tool")) {
                int n = clayToolIndex = clayToolIndex == -1 ? i : -2;
            }
            if (!RSVItem.getNameFromItem(item).contains("saw")) continue;
            sawIndex = sawIndex == -1 ? i : -2;
        }
        if (this.config.getBoolean("Pottery.DisableFlowerPotRecipe") && clayToolIndex > -1 && clayIndex > -1) {
            ItemStack clayTool = matrix[clayToolIndex];
            ItemStack clay = matrix[clayIndex];
            int clayAmount = clay.getAmount();
            durability = Utils.getCustomDurability(clayTool);
            RSVItem clayBrick = RSVItem.getItem("clay_brick");
            clayBrick.setAmount(durability - clayAmount < 0 ? durability : clayAmount);
            event.getInventory().setResult((ItemStack)clayBrick);
        }
        if (this.config.getBoolean("Lumberjack.EnableSawPlankRecipes") && sawIndex > -1 && woodIndex > -1) {
            ItemStack saw = matrix[sawIndex];
            ItemStack wood = matrix[woodIndex];
            int woodAmount = wood.getAmount();
            durability = Utils.getCustomDurability(saw);
            if (durability - woodAmount < 0) {
                event.getInventory().setResult(new ItemStack(Utils.getRespectivePlank(wood.getType()), durability * 4));
            } else {
                event.getInventory().setResult(new ItemStack(Utils.getRespectivePlank(wood.getType()), woodAmount * 4));
            }
        }
        if (this.config.getBoolean("Lumberjack.EnableSawStickRecipes") && sawIndex > -1 && planksIndex > -1) {
            ItemStack saw = matrix[sawIndex];
            ItemStack planks = matrix[planksIndex];
            int planksAmount = planks.getAmount();
            durability = Utils.getCustomDurability(saw);
            if (durability - planksAmount < 0) {
                event.getInventory().setResult(new ItemStack(Material.STICK, durability * 4));
            } else {
                event.getInventory().setResult(new ItemStack(Material.STICK, planksAmount * 4));
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onClick(InventoryClickEvent event) {
        CraftingInventory craftInv;
        Player player;
        block30: {
            block29: {
                player = (Player)event.getWhoClicked();
                InventoryView view = event.getView();
                Inventory top = view.getTopInventory();
                InventoryType type = top.getType();
                if (!this.shouldEventBeRan((Entity)player) || type != InventoryType.CRAFTING && type != InventoryType.WORKBENCH || !(top instanceof CraftingInventory)) break block29;
                craftInv = (CraftingInventory)top;
                if (event.getRawSlot() == 0) break block30;
            }
            return;
        }
        ItemStack temp = null;
        ItemStack tool = null;
        ItemStack[] matrix = craftInv.getMatrix();
        ItemStack result = craftInv.getResult();
        boolean hasSaw = false;
        ItemStack copy = null;
        if (Utils.isItemReal(result)) {
            if (Tag.PLANKS.isTagged((Keyed)result.getType())) {
                boolean hasLogs = false;
                for (ItemStack itemStack : matrix) {
                    if (itemStack == null) continue;
                    if (Tag.LOGS.isTagged((Keyed)itemStack.getType())) {
                        temp = itemStack;
                        hasLogs = true;
                    }
                    if (RSVItem.isRSVItem(itemStack) && RSVItem.getNameFromItem(itemStack).contains("saw")) {
                        tool = itemStack;
                        hasSaw = true;
                    }
                    if (!hasSaw || !hasLogs) continue;
                    int durability = Utils.getCustomDurability(tool);
                    if (durability - temp.getAmount() < 0) {
                        Utils.changeDurability(tool, -durability, true, true, (Entity)player);
                        temp.setAmount(temp.getAmount() - durability);
                    } else {
                        Utils.changeDurability(tool, -temp.getAmount(), true, true, (Entity)player);
                        temp.setAmount(0);
                        copy = tool;
                    }
                    break;
                }
            } else if (result.getType() == Material.STICK) {
                boolean hasPlanks = false;
                for (ItemStack itemStack : matrix) {
                    if (!Utils.isItemReal(itemStack)) continue;
                    if (Tag.PLANKS.isTagged((Keyed)itemStack.getType())) {
                        temp = itemStack;
                        hasPlanks = true;
                    }
                    if (RSVItem.isRSVItem(itemStack) && RSVItem.getNameFromItem(itemStack).contains("saw")) {
                        tool = itemStack;
                        hasSaw = true;
                    }
                    if (!hasSaw || !hasPlanks) continue;
                    int durability = Utils.getCustomDurability(tool);
                    if (durability - temp.getAmount() < 0) {
                        Utils.changeDurability(tool, -durability, true, true, (Entity)player);
                        temp.setAmount(temp.getAmount() - durability);
                    } else {
                        Utils.changeDurability(tool, -temp.getAmount(), true, true, (Entity)player);
                        temp.setAmount(0);
                        copy = tool;
                    }
                    break;
                }
            } else if (RSVItem.isRSVItem(result) && RSVItem.getNameFromItem(result).equals("clay_brick")) {
                boolean hasClayTool = false;
                boolean hasClay = false;
                for (ItemStack itemStack : matrix) {
                    int durability;
                    if (!Utils.isItemReal(itemStack)) continue;
                    if (itemStack.getType() == Material.CLAY_BALL) {
                        temp = itemStack;
                        hasClay = true;
                    }
                    if (RSVItem.isRSVItem(itemStack) && RSVItem.getNameFromItem(itemStack).equals("clay_tool")) {
                        tool = itemStack;
                        hasClayTool = true;
                    }
                    if (!hasClayTool || !hasClay) continue;
                    int n = durability = Utils.hasCustomDurability(tool) ? Utils.getCustomDurability(tool) : tool.getType().getMaxDurability() - ((Damageable)tool.getItemMeta()).getDamage();
                    if (durability - temp.getAmount() < 0) {
                        Utils.changeDurability(tool, -durability, true, true, (Entity)player);
                        temp.setAmount(temp.getAmount() - durability);
                    } else {
                        Utils.changeDurability(tool, -temp.getAmount(), true, true, (Entity)player);
                        temp.setAmount(0);
                        copy = tool;
                    }
                    break;
                }
            }
        }
        if (Utils.isItemReal(copy)) {
            ItemStack[] contents = player.getInventory().getContents();
            boolean full = true;
            for (ItemStack i : contents) {
                if (Utils.isItemReal(i)) continue;
                player.getInventory().addItem(new ItemStack[]{copy});
                full = false;
                break;
            }
            if (full) {
                player.getWorld().dropItemNaturally(player.getLocation(), copy);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBurn(FurnaceBurnEvent event) {
        if (!this.shouldEventBeRan(event.getBlock().getWorld())) {
            return;
        }
        FurnaceInventory inv = ((Furnace)event.getBlock().getState()).getSnapshotInventory();
        ItemStack smeltedItem = inv.getSmelting();
        if (Utils.isItemReal(smeltedItem) && smeltedItem.getType() == Material.CLAY_BALL && this.config.getBoolean("Pottery.DisableBrickSmeltingRecipe")) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onSmelt(FurnaceSmeltEvent event) {
        if (!this.shouldEventBeRan(event.getBlock().getWorld())) {
            return;
        }
        if (event.getResult().getType() == Material.BRICK && event.getSource().getType() == Material.CLAY_BALL && this.config.getBoolean("Pottery.DisableBrickSmeltingRecipe")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBucketInteract(final PlayerItemAcquireEvent event) {
        ItemStack origItem = event.getOriginalItem();
        if (!RSVItem.isRSVItem(origItem) || !RSVItem.getNameFromItem(origItem).contains("ceramic_")) {
            return;
        }
        switch (event.getCause()) {
            case BUCKET_EMPTY: 
            case BUCKET_FILL_LIQUID: 
            case BUCKET_FILL_MOB: 
            case FOOD_CONSUME: {
                break;
            }
            default: {
                return;
            }
        }
        final Player player = event.getPlayer();
        ItemStack result = event.getItem();
        final String realResultName = "ceramic_" + result.getType().toString().toLowerCase();
        final RSVItem realResult = RSVItem.getItem(realResultName);
        new BukkitRunnable(this){
            final /* synthetic */ NtpEvents this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (event.getLocation() == EquipmentSlot.HAND) {
                    player.getInventory().setItemInMainHand(realResult);
                } else if (event.getLocation() == EquipmentSlot.OFF_HAND) {
                    player.getInventory().setItemInOffHand(realResult);
                }
                if (realResultName.equals("ceramic_lava_bucket") && !CeramicBucketMeltTask.hasTask(player.getUniqueId())) {
                    new CeramicBucketMeltTask(this.this$0.plugin, this.this$0.module, player).start();
                }
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
    }

    @EventHandler
    public void onBucketClick(PlayerItemAcquireEvent event) {
        ItemStack item = event.getItem();
        if (!RSVItem.isRSVItem(item) || !RSVItem.getNameFromItem(item).equals("ceramic_lava_bucket")) {
            return;
        }
        if (event.getLocation() != EquipmentSlot.HAND && event.getLocation() != EquipmentSlot.OFF_HAND) {
            return;
        }
        new CeramicBucketMeltTask(this.plugin, this.module, event.getPlayer()).start();
    }
}

