/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.spartanandfire;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.val_mobile.data.RSVModule;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.spartanandfire.FrozenBlock;
import me.val_mobile.spartanandfire.UnfreezeTask;
import me.val_mobile.utils.Utils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class FreezeTask
extends BukkitRunnable {
    private static final Map<UUID, FreezeTask> tasks = new HashMap<UUID, FreezeTask>();
    private final Entity entity;
    private final RSVPlugin plugin;
    private final Collection<FrozenBlock> blocks = new ArrayList<FrozenBlock>();
    private final FileConfiguration config;
    private final boolean encaseIce;
    private final boolean playSound;
    private final PotionEffect slowness;
    private final Material frozenMaterial;
    private final String soundName;
    private final float volume;
    private final float pitch;
    private final int duration;
    private final boolean wasOriginallyFrozen;

    public FreezeTask(RSVPlugin plugin, int stage, Entity entity) {
        LivingEntity living;
        this.entity = entity;
        this.plugin = plugin;
        this.config = RSVModule.getModule("IceandFire").getUserConfig().getConfig();
        this.encaseIce = this.config.getBoolean("Dragon.IceDragon.FreezeAbility.EncaseIce.Enabled");
        this.playSound = this.config.getBoolean("Dragon.IceDragon.FreezeAbility.Sound.Enabled");
        int amplifier = this.config.getInt("Dragon.IceDragon.FreezeAbility.Slowness.Amplifier.Stage" + stage);
        int duration = this.config.getInt("Dragon.IceDragon.FreezeAbility.Duration.Amplifier.Stage" + stage);
        this.slowness = new PotionEffect(PotionEffectType.SLOW, duration, amplifier);
        this.frozenMaterial = Material.valueOf((String)this.config.getString("Dragon.IceDragon.FreezeAbility.EncaseIce.Block"));
        this.volume = (float)this.config.getDouble("Dragon.IceDragon.FreezeAbility.Sound.Volume");
        this.pitch = (float)this.config.getDouble("Dragon.IceDragon.FreezeAbility.Sound.Pitch");
        this.soundName = this.config.getString("Dragon.IceDragon.FreezeAbility.Sound.Sound");
        this.duration = this.config.getInt("Dragon.IceDragon.FreezeAbility.FrozenDuration.Stage" + stage);
        this.wasOriginallyFrozen = entity instanceof LivingEntity && !(living = (LivingEntity)entity).hasAI();
        tasks.put(entity.getUniqueId(), this);
    }

    public FreezeTask(RSVPlugin plugin, RSVModule module, String itemName, Entity entity) {
        LivingEntity living;
        this.entity = entity;
        this.plugin = plugin;
        this.config = module.getUserConfig().getConfig();
        this.encaseIce = this.config.getBoolean("Items." + itemName + ".FreezeAbility.EncaseIce.Enabled");
        this.playSound = this.config.getBoolean("Items." + itemName + ".FreezeAbility.Sound.Enabled");
        int amplifier = this.config.getInt("Items." + itemName + ".FreezeAbility.Slowness.Amplifier");
        int duration = this.config.getInt("Items." + itemName + ".FreezeAbility.Slowness.Duration");
        this.slowness = new PotionEffect(PotionEffectType.SLOW, duration, amplifier);
        this.frozenMaterial = Material.valueOf((String)this.config.getString("Items." + itemName + ".FreezeAbility.EncaseIce.Block"));
        this.volume = (float)this.config.getDouble("Items." + itemName + ".FreezeAbility.Sound.Volume");
        this.pitch = (float)this.config.getDouble("Items." + itemName + ".FreezeAbility.Sound.Pitch");
        this.soundName = this.config.getString("Items." + itemName + ".FreezeAbility.Sound.Sound");
        this.duration = this.config.getInt("Items." + itemName + ".FreezeAbility.FrozenDuration");
        this.wasOriginallyFrozen = entity instanceof LivingEntity && !(living = (LivingEntity)entity).hasAI();
        tasks.put(entity.getUniqueId(), this);
    }

    public void run() {
        Entity entity = this.entity;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.addPotionEffect(this.slowness);
            living.setAI(false);
        }
        Utils.setZeroKb(this.entity);
        Location loc = this.entity.getLocation().clone();
        double height = this.entity.getHeight();
        if (this.encaseIce) {
            this.blocks.add(new FrozenBlock(loc, this.frozenMaterial));
            int i = 0;
            while ((double)i < height - 1.0) {
                this.blocks.add(new FrozenBlock(loc.add(0.0, 1.0, 0.0), this.frozenMaterial));
                ++i;
            }
        }
        if (this.playSound) {
            Utils.playSound(loc, this.soundName, this.volume, this.pitch);
        }
        if (this.encaseIce && !UnfreezeTask.hasTask(this.entity.getUniqueId())) {
            new UnfreezeTask(this.plugin, this.entity, this.blocks, this.duration, this.wasOriginallyFrozen).start();
        }
        tasks.remove(this.entity.getUniqueId());
    }

    public void start() {
        this.runTask((Plugin)this.plugin);
    }

    public static Map<UUID, FreezeTask> getTasks() {
        return tasks;
    }

    public static boolean hasTask(UUID id) {
        return tasks.containsKey(id) && tasks.get(id) != null;
    }
}

