/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.spartanandfire;

import java.util.Map;
import me.val_mobile.data.ModuleItems;
import me.val_mobile.data.ModuleRecipes;
import me.val_mobile.data.RSVConfig;
import me.val_mobile.data.RSVModule;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.spartanandfire.SfEvents;
import me.val_mobile.utils.Utils;
import org.bukkit.configuration.file.FileConfiguration;

public class SfModule
extends RSVModule {
    private final RSVPlugin plugin;
    private SfEvents events;
    public static final String NAME = "SpartanandFire";

    public SfModule(RSVPlugin plugin) {
        super(NAME, plugin, Map.of(RSVModule.getModule("IceandFire"), "Module requires Ice and Fire to be enabled.", RSVModule.getModule("SpartanWeaponry"), "Module requires Spartan Weaponry to be enabled."), Map.of());
        this.plugin = plugin;
    }

    @Override
    public void initialize() {
        this.setUserConfig(new RSVConfig(this.plugin, "spartanandfire.yml"));
        this.setItemConfig(new RSVConfig(this.plugin, "resources/spartanandfire/items.yml"));
        this.setRecipeConfig(new RSVConfig(this.plugin, "resources/spartanandfire/recipes.yml"));
        this.setModuleItems(new ModuleItems(this));
        this.setModuleRecipes(new ModuleRecipes(this, this.plugin));
        FileConfiguration config = this.getUserConfig().getConfig();
        if (config.getBoolean("Initialize.Enabled")) {
            String message = Utils.translateMsg(config.getString("Initialize.Message"), null, Map.of("NAME", NAME));
            this.plugin.getLogger().info(message);
        }
        this.events = new SfEvents(this, this.plugin);
        this.getModuleItems().initialize();
        this.getModuleRecipes().initialize();
        this.events.initialize();
    }

    @Override
    public void shutdown() {
        FileConfiguration config = this.getUserConfig().getConfig();
        if (config.getBoolean("Shutdown.Enabled")) {
            String message = Utils.translateMsg(config.getString("Shutdown.Message"), null, Map.of("NAME", NAME));
            this.plugin.getLogger().info(message);
        }
    }

    public SfEvents getEvents() {
        return this.events;
    }
}

