/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.spartanandfire;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.spartanandfire.FrozenBlock;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class UnfreezeTask
extends BukkitRunnable {
    private static final Map<UUID, UnfreezeTask> tasks = new HashMap<UUID, UnfreezeTask>();
    private final int pause;
    private final Collection<FrozenBlock> blocks;
    private final RSVPlugin plugin;
    private final Entity entity;
    private final boolean wasOriginallyFrozen;

    public UnfreezeTask(RSVPlugin plugin, Entity entity, Collection<FrozenBlock> blocks, int pause, boolean wasOriginallyFrozen) {
        this.blocks = blocks;
        this.plugin = plugin;
        this.pause = pause;
        this.entity = entity;
        this.wasOriginallyFrozen = wasOriginallyFrozen;
        tasks.put(entity.getUniqueId(), this);
    }

    public void run() {
        this.blocks.forEach(block -> block.getBlock().remove());
        Entity entity = this.entity;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (!this.wasOriginallyFrozen) {
                living.setAI(true);
            }
        }
        tasks.remove(this.entity.getUniqueId());
    }

    public void start() {
        this.runTaskLater((Plugin)this.plugin, this.pause);
    }

    public static Map<UUID, UnfreezeTask> getTasks() {
        return tasks;
    }

    public static boolean hasTask(UUID id) {
        return tasks.containsKey(id) && tasks.get(id) != null;
    }
}

