/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import me.val_mobile.data.RSVModule;
import me.val_mobile.data.RSVPlayer;
import me.val_mobile.iceandfire.IceFireModule;
import me.val_mobile.integrations.CompatiblePlugin;
import me.val_mobile.integrations.RealisticSeasons;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.tan.TanModule;
import me.val_mobile.tan.TempManager;
import me.val_mobile.tan.ThirstManager;
import me.val_mobile.utils.CharacterValues;
import me.val_mobile.utils.RSVTask;
import me.val_mobile.utils.Utils;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DisplayTask
extends BukkitRunnable
implements RSVTask {
    private static final Map<UUID, DisplayTask> tasks = new HashMap<UUID, DisplayTask>();
    private final UUID id;
    private final FileConfiguration tanConfig;
    private final FileConfiguration ifConfig;
    private final RSVPlugin plugin;
    private final RSVPlayer player;
    private final CharacterValues characterValues;
    private boolean underSirenEffect = false;
    private boolean parasitesActive = false;
    private final TanModule tanModule;
    private final IceFireModule ifModule;
    private final RealisticSeasons rs;

    public DisplayTask(RSVPlugin plugin, RSVPlayer player) {
        this.plugin = plugin;
        this.tanModule = (TanModule)RSVModule.getModule("ToughAsNails");
        this.ifModule = (IceFireModule)RSVModule.getModule("IceandFire");
        this.tanConfig = this.tanModule.isGloballyEnabled() ? this.tanModule.getUserConfig().getConfig() : null;
        this.ifConfig = this.ifModule.isGloballyEnabled() ? this.ifModule.getUserConfig().getConfig() : null;
        this.player = player;
        this.characterValues = new CharacterValues();
        this.id = player.getPlayer().getUniqueId();
        this.rs = (RealisticSeasons)CompatiblePlugin.getPlugin("RealisticSeasons");
        tasks.put(this.id, this);
    }

    public void run() {
        Player player = this.player.getPlayer();
        if (this.globalConditionsMet((LivingEntity)player)) {
            Object actionbarText = "";
            Object titleText = "";
            if (this.ifConfig != null && this.ifModule.getAllowedWorlds().contains(player.getWorld().getName()) && !player.hasPermission("realisticsurvival.iceandfire.resistance.sirenvisual") && this.underSirenEffect && this.ifConfig.getBoolean("Siren.ChangeScreen.Enabled")) {
                titleText = (String)titleText + this.characterValues.getSirenView(player);
            }
            if (this.tanConfig != null) {
                boolean isUnderwater;
                TempManager tempManager = this.tanModule.getTempManager();
                ThirstManager thirstManager = this.tanModule.getThirstManager();
                double temperature = tempManager.getTemperature(player);
                double thirst = thirstManager.getThirst(player);
                boolean bl = isUnderwater = player.getRemainingAir() < 300 || player.getEyeLocation().getBlock().getType() == Material.WATER;
                actionbarText = tempManager.isTempEnabled(player) && thirstManager.isThirstEnabled(player) ? (String)actionbarText + this.characterValues.getTemperatureThirstActionbar(player, (int)Math.round(temperature), (int)Math.round(thirst), isUnderwater, this.parasitesActive) : (tempManager.isTempEnabled(player) ? (String)actionbarText + this.characterValues.getTemperatureOnlyActionbar(player, (int)Math.round(temperature)) : (String)actionbarText + this.characterValues.getThirstOnlyActionbar(player, (int)Math.round(thirst), isUnderwater, this.parasitesActive));
                if (temperature < 6.0 && this.tanConfig.getBoolean("Temperature.Hypothermia.ScreenTinting.Enabled") && !this.rs.disableHypothermiaTinting() && !player.hasPermission("realisticsurvival.toughasnails.resistance.cold.visual")) {
                    if (this.tanConfig.getBoolean("Temperature.Hypothermia.ScreenTinting.UseVanillaFreezeEffect")) {
                        Utils.setFreezingView(player, this.tanConfig.getInt("VisualTickPeriod") + 5);
                    } else {
                        titleText = (String)titleText + this.characterValues.getIceVignette(player, (int)Math.round(temperature));
                    }
                }
                if (temperature > 19.0 && this.tanConfig.getBoolean("Temperature.Hyperthermia.ScreenTinting") && !this.rs.disableHyperthermiaTinting() && !player.hasPermission("realisticsurvival.toughasnails.resistance.hot.visual")) {
                    titleText = (String)titleText + this.characterValues.getFireVignette(player, (int)Math.round(temperature));
                }
                if (thirst < 5.0 && this.tanConfig.getBoolean("Thirst.Dehydration.ScreenTinting") && !player.hasPermission("realisticsurvival.toughasnails.resistance.thirst.visual")) {
                    titleText = (String)titleText + this.characterValues.getThirstVignette(player, (int)Math.round(thirst));
                }
            }
            if (!((String)actionbarText).isEmpty()) {
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(Utils.translateMsg((String)actionbarText, (CommandSender)player, null)));
            }
            if (!((String)titleText).isEmpty()) {
                player.sendTitle(Utils.translateMsg((String)titleText, (CommandSender)player, null), "", 0, 70, 0);
            }
        } else {
            this.stop();
        }
    }

    @Override
    public boolean conditionsMet(@Nullable Player player) {
        return this.globalConditionsMet((LivingEntity)player);
    }

    @Override
    public void start() {
        int tickPeriod = this.tanConfig.getInt("VisualTickPeriod");
        this.runTaskTimer((Plugin)this.plugin, 0L, tickPeriod);
    }

    @Override
    public void stop() {
        tasks.remove(this.id);
        this.cancel();
    }

    public void setUnderSirenEffect(boolean underSirenEffect) {
        this.underSirenEffect = underSirenEffect;
    }

    public void setParasitesActive(boolean parasitesActive) {
        this.parasitesActive = parasitesActive;
    }

    public static boolean hasTask(UUID id) {
        return tasks.containsKey(id) && tasks.get(id) != null;
    }

    public static Map<UUID, DisplayTask> getTasks() {
        return tasks;
    }
}

