/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.utils;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.clip.placeholderapi.PlaceholderAPI;
import me.val_mobile.baubles.EndermanAlly;
import me.val_mobile.data.RSVModule;
import me.val_mobile.iceandfire.DragonVariant;
import me.val_mobile.iceandfire.FireDragon;
import me.val_mobile.iceandfire.IceDragon;
import me.val_mobile.iceandfire.LightningDragon;
import me.val_mobile.iceandfire.SeaSerpent;
import me.val_mobile.iceandfire.SeaSerpentVariant;
import me.val_mobile.iceandfire.Siren;
import me.val_mobile.integrations.CompatiblePlugin;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.spartanweaponry.KbTask;
import me.val_mobile.utils.InternalsProvider;
import me.val_mobile.utils.LorePresets;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.ToolHandler;
import me.val_mobile.utils.recipe.RSVRecipe;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class Utils {
    public static final double ATTACK_DAMAGE_CONSTANT = -1.0;
    public static final double ATTACK_SPEED_CONSTANT = -4.0;
    private static final Pattern VERSION_PATTERN = Pattern.compile("([1-9])\\.([1-9][0-9]|[1-9])(\\.([0-9]))?");
    private final RSVPlugin plugin;
    private static InternalsProvider internals;

    public Utils(RSVPlugin plugin) {
        this.plugin = plugin;
    }

    @Nonnull
    private static String format(@Nonnull String text, @Nonnull Map<String, Object> placeholders) {
        StringBuilder newTemplate = new StringBuilder(text);
        ArrayList<Object> valueList = new ArrayList<Object>();
        Matcher matcher = Pattern.compile("%(\\w+)%").matcher(text);
        while (matcher.find()) {
            String key = matcher.group(1);
            String paramName = "%" + key + "%";
            int index = newTemplate.indexOf(paramName);
            if (index == -1) continue;
            newTemplate.replace(index, index + paramName.length(), "%s");
            valueList.add(placeholders.get(key));
        }
        return String.format(newTemplate.toString(), valueList.toArray());
    }

    @Nonnull
    public static String translateMsg(@Nonnull String text, @Nullable CommandSender sender, @Nullable Map<String, Object> placeholders) {
        String translatedText = text;
        if (CompatiblePlugin.isIntegrated("PlaceholderAPI")) {
            translatedText = PlaceholderAPI.setPlaceholders((OfflinePlayer)(sender instanceof Player ? (Player)sender : (sender instanceof OfflinePlayer ? (OfflinePlayer)sender : null)), (String)translatedText);
        }
        if (placeholders != null) {
            translatedText = Utils.format(translatedText, placeholders);
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)translatedText);
    }

    @Nonnull
    public static List<String> translateMsgs(@Nonnull List<String> texts, @Nullable CommandSender sender, @Nullable Map<String, Object> placeholders) {
        List<String> translated = new ArrayList<String>(texts);
        if (CompatiblePlugin.isIntegrated("PlaceholderAPI")) {
            translated = PlaceholderAPI.setPlaceholders((OfflinePlayer)(sender instanceof Player ? (Player)sender : (sender instanceof OfflinePlayer ? (OfflinePlayer)sender : null)), translated);
        }
        for (int i = 0; i < translated.size(); ++i) {
            String temp = (String)translated.get(i);
            if (placeholders != null) {
                temp = Utils.format(temp, placeholders);
            }
            temp = ChatColor.translateAlternateColorCodes((char)'&', (String)temp);
            translated.set(i, temp);
        }
        return translated;
    }

    public static double round(double value, @Nonnegative int places) {
        BigDecimal bd = new BigDecimal(Double.toString(value));
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static double clamp(double val, double min, double max) {
        return Math.max(min, Math.min(max, val));
    }

    public static int clamp(int val, int min, int max) {
        return Math.max(min, Math.min(max, val));
    }

    @Nonnull
    public static String getMinecraftVersion(boolean impl) {
        Matcher m = VERSION_PATTERN.matcher(Bukkit.getVersion());
        if (m.find()) {
            String minor;
            String prefix = m.group(1);
            String major = m.group(2);
            String string = minor = m.group(4) == null ? "0" : m.group(4);
            return impl ? "v" + prefix + "_" + major + "_R" + (Integer.parseInt(minor) + 1) : prefix + "." + major + (String)(minor.equals("0") ? "" : "." + minor);
        }
        return "";
    }

    public static boolean isServerRunningPaper() {
        try {
            Class.forName("com.destroystokyo.paper.ParticleBuilder");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @Nonnull
    public static List<String> getAllWorldNames() {
        ArrayList<String> worldNames = new ArrayList<String>();
        for (File file : Bukkit.getServer().getWorldContainer().listFiles()) {
            if (!file.isDirectory() || !Arrays.asList(file.list()).contains("level.dat")) continue;
            worldNames.add(file.getName());
        }
        return worldNames;
    }

    @Nonnull
    public static List<Material> getMaterialsFromList(@Nonnull List<String> list) {
        ArrayList<Material> mats = new ArrayList<Material>();
        for (String s : list) {
            if (s == null || s.isEmpty()) continue;
            if (s.contains("Tag.")) {
                mats.addAll(Utils.getTag(s.substring(4)).getValues());
                continue;
            }
            if (Utils.isTag(s)) {
                mats.addAll(Utils.getTag(s).getValues());
                continue;
            }
            mats.add(Material.valueOf((String)s));
        }
        return mats;
    }

    public static void randomTpSafely(@Nonnull Entity entity, @Nonnegative double radius) {
        World world = entity.getWorld();
        Location loc = entity.getLocation().clone();
        boolean isShort = entity.getHeight() <= 2.0;
        for (int i = 0; i < 16; ++i) {
            int x = (int)Utils.getRandomNum(-1.0 * radius, radius);
            int y = (int)Utils.getRandomNum(-1.0 * radius, radius);
            int z = (int)Utils.getRandomNum(-1.0 * radius, radius);
            double actualX = loc.getX() + (double)x;
            actualX = Math.floor(actualX) + Utils.clamp(actualX - (double)((int)actualX), 0.45, 0.55);
            double actualZ = loc.getZ() + (double)z;
            actualZ = Math.floor(actualZ) + Utils.clamp(actualZ - (double)((int)actualZ), 0.45, 0.55);
            double actualY = Utils.clamp(loc.getY() + (double)y, (double)world.getMinHeight(), (double)world.getMaxHeight());
            Block block = world.getBlockAt((int)Math.round(actualX), (int)Math.round(actualY), (int)Math.round(actualZ));
            Block below = world.getBlockAt(block.getX(), block.getY() - 1, block.getZ());
            Block highestBlock = world.getHighestBlockAt(block.getX(), block.getZ());
            Block aboveBlock = world.getBlockAt(block.getX(), block.getY() + 1, block.getZ());
            Block thirdBlock = world.getBlockAt(block.getX(), block.getY() + 1, block.getZ());
            if (below.isPassable() || !block.isPassable() || !aboveBlock.isPassable() || highestBlock.isEmpty() || block.isLiquid() || aboveBlock.isLiquid() || highestBlock.isLiquid() || (!thirdBlock.isPassable() || thirdBlock.isLiquid()) && !isShort) continue;
            loc.setX(actualX);
            loc.setY((double)highestBlock.getY() + 1.0);
            loc.setZ(actualZ);
            entity.teleport(loc);
            break;
        }
    }

    @Nonnull
    public static String toLowercaseAttributeName(@Nonnull Attribute atr) {
        return switch (atr) {
            default -> throw new MatchException(null, null);
            case Attribute.GENERIC_ATTACK_DAMAGE -> "generic.attack_damage";
            case Attribute.GENERIC_ATTACK_SPEED -> "generic.attack_speed";
            case Attribute.GENERIC_ATTACK_KNOCKBACK -> "generic.attack_knockback";
            case Attribute.GENERIC_ARMOR -> "generic.armor";
            case Attribute.GENERIC_ARMOR_TOUGHNESS -> "generic.armor_toughness";
            case Attribute.GENERIC_FLYING_SPEED -> "generic.flying_speed";
            case Attribute.GENERIC_FOLLOW_RANGE -> "generic.follow_range";
            case Attribute.GENERIC_KNOCKBACK_RESISTANCE -> "generic.knockback_resistance";
            case Attribute.GENERIC_LUCK -> "generic.luck";
            case Attribute.GENERIC_MAX_HEALTH -> "generic.max_health";
            case Attribute.GENERIC_MOVEMENT_SPEED -> "generic.movement_speed";
            case Attribute.HORSE_JUMP_STRENGTH -> "horse.jump_strength";
            case Attribute.ZOMBIE_SPAWN_REINFORCEMENTS -> "zombie.spawn_reinforcements";
        };
    }

    public static double getCorrectAttributeValue(@Nonnull Attribute attribute, double requestedValue) {
        return switch (attribute) {
            case Attribute.GENERIC_ATTACK_DAMAGE -> requestedValue + -1.0;
            case Attribute.GENERIC_ATTACK_SPEED -> requestedValue + -4.0;
            case Attribute.GENERIC_ARMOR, Attribute.GENERIC_ARMOR_TOUGHNESS -> requestedValue;
            default -> 0.0;
        };
    }

    public static boolean isHelmet(@Nonnull Material material) {
        return switch (material) {
            case Material.CHAINMAIL_HELMET, Material.DIAMOND_HELMET, Material.GOLDEN_HELMET, Material.IRON_HELMET, Material.LEATHER_HELMET, Material.NETHERITE_HELMET, Material.TURTLE_HELMET -> true;
            default -> false;
        };
    }

    public static boolean isChestplate(@Nonnull Material material) {
        return switch (material) {
            case Material.CHAINMAIL_CHESTPLATE, Material.DIAMOND_CHESTPLATE, Material.GOLDEN_CHESTPLATE, Material.IRON_CHESTPLATE, Material.LEATHER_CHESTPLATE, Material.NETHERITE_CHESTPLATE -> true;
            default -> false;
        };
    }

    public static boolean isLeggings(@Nonnull Material material) {
        return switch (material) {
            case Material.CHAINMAIL_LEGGINGS, Material.DIAMOND_LEGGINGS, Material.GOLDEN_LEGGINGS, Material.IRON_LEGGINGS, Material.LEATHER_LEGGINGS, Material.NETHERITE_LEGGINGS -> true;
            default -> false;
        };
    }

    public static boolean isBoots(@Nonnull Material material) {
        return switch (material) {
            case Material.CHAINMAIL_BOOTS, Material.DIAMOND_BOOTS, Material.GOLDEN_BOOTS, Material.IRON_BOOTS, Material.LEATHER_BOOTS, Material.NETHERITE_BOOTS -> true;
            default -> false;
        };
    }

    public static EquipmentSlot getEquipmentSlotFromMaterial(@Nonnull Material material) {
        if (Utils.isHelmet(material)) {
            return EquipmentSlot.HEAD;
        }
        if (Utils.isChestplate(material)) {
            return EquipmentSlot.CHEST;
        }
        if (Utils.isLeggings(material)) {
            return EquipmentSlot.LEGS;
        }
        if (Utils.isBoots(material)) {
            return EquipmentSlot.FEET;
        }
        return EquipmentSlot.HAND;
    }

    public static boolean isArmor(@Nonnull Material material) {
        return Utils.isHelmet(material) || Utils.isChestplate(material) || Utils.isLeggings(material) || Utils.isBoots(material);
    }

    public static void updateDamageLore(@Nonnull ItemStack item, @Nullable Set<Map.Entry<Enchantment, Integer>> entrySet) {
        ItemMeta meta;
        if (RSVItem.isRSVItem(item) && (meta = item.getItemMeta()) != null && meta.hasAttributeModifiers() && meta.hasLore()) {
            List lore = meta.getLore();
            Collection modifiers = meta.getAttributeModifiers(Attribute.GENERIC_ATTACK_DAMAGE);
            if (modifiers != null && !modifiers.isEmpty() && lore != null) {
                int lvl = 0;
                if (entrySet != null && !entrySet.isEmpty()) {
                    for (Map.Entry<Enchantment, Integer> entry : entrySet) {
                        if (!entry.getKey().equals((Object)Enchantment.DAMAGE_ALL)) continue;
                        lvl = Math.max(lvl, entry.getValue());
                    }
                }
                double baseDmg = 0.0;
                for (AttributeModifier modifier : modifiers) {
                    if (modifier.getSlot() != EquipmentSlot.HAND) continue;
                    baseDmg += modifier.getAmount() - -1.0;
                }
                double extraDmg = 0.5 * (double)Math.max(0, lvl - 1) + 1.0;
                double newDmg = baseDmg + extraDmg;
                int len = lore.size();
                int index = -1;
                for (int i = 0; i < len; ++i) {
                    if (!((String)lore.get(i)).contains("Attack Damage")) continue;
                    index = i;
                    break;
                }
                if (index != -1) {
                    ArrayList<String> before = new ArrayList<String>(lore.subList(0, index));
                    LorePresets.addGearStats(before, Attribute.GENERIC_ATTACK_DAMAGE, newDmg);
                    if (index + 1 < len) {
                        before.addAll(lore.subList(index + 1, lore.size()));
                    }
                    meta.setLore(before);
                    item.setItemMeta(meta);
                }
            }
        }
    }

    @Nullable
    public static EquipmentSlot getCorrectEquipmentSlot(@Nonnull Attribute attribute, @Nonnull Material material) {
        switch (attribute) {
            case GENERIC_ATTACK_DAMAGE: 
            case GENERIC_ATTACK_SPEED: {
                return EquipmentSlot.HAND;
            }
            case GENERIC_ARMOR: 
            case GENERIC_ARMOR_TOUGHNESS: {
                if (Utils.isHelmet(material)) {
                    return EquipmentSlot.HEAD;
                }
                if (Utils.isChestplate(material)) {
                    return EquipmentSlot.CHEST;
                }
                if (Utils.isLeggings(material)) {
                    return EquipmentSlot.LEGS;
                }
                if (!Utils.isBoots(material)) break;
                return EquipmentSlot.FEET;
            }
        }
        return null;
    }

    @Nonnull
    public static Attribute translateInformalAttributeName(@Nonnull String name) {
        return switch (name) {
            case "AttackDamage" -> Attribute.GENERIC_ATTACK_DAMAGE;
            case "AttackKnockback" -> Attribute.GENERIC_ATTACK_KNOCKBACK;
            case "AttackSpeed" -> Attribute.GENERIC_ATTACK_SPEED;
            case "Armor" -> Attribute.GENERIC_ARMOR;
            case "Toughness" -> Attribute.GENERIC_ARMOR_TOUGHNESS;
            case "FlyingSpeed" -> Attribute.GENERIC_FLYING_SPEED;
            case "FollowRange" -> Attribute.GENERIC_FOLLOW_RANGE;
            case "KnockbackResistance" -> Attribute.GENERIC_KNOCKBACK_RESISTANCE;
            case "Luck" -> Attribute.GENERIC_LUCK;
            case "MaxHealth" -> Attribute.GENERIC_MAX_HEALTH;
            case "MovementSpeed" -> Attribute.GENERIC_MOVEMENT_SPEED;
            case "HorseJumpStrength" -> Attribute.HORSE_JUMP_STRENGTH;
            case "ZombieSpawnReinforcements" -> Attribute.ZOMBIE_SPAWN_REINFORCEMENTS;
            default -> Attribute.valueOf((String)name);
        };
    }

    @Nullable
    public static String getMinecraftEnchName(@Nonnull String keyName) {
        return switch (keyName) {
            case "ARROW_DAMAGE" -> "power";
            case "ARROW_FIRE" -> "flame";
            case "ARROW_INFINITE" -> "infinity";
            case "ARROW_KNOCKBACK" -> "punch";
            case "BINDING_CURSE" -> "binding_curse";
            case "DAMAGE_ALL" -> "sharpness";
            case "DAMAGE_ARTHROPODS" -> "bane_of_arthropods";
            case "DAMAGE_UNDEAD" -> "smite";
            case "DEPTH_STRIDER" -> "depth_strider";
            case "DIG_SPEED" -> "efficiency";
            case "DURABILITY" -> "unbreaking";
            case "FIRE_ASPECT" -> "fire_aspect";
            case "FROST_WALKER" -> "frost_walker";
            case "KNOCKBACK" -> "knockback";
            case "LOOT_BONUS_BLOCKS" -> "fortune";
            case "LOOT_BONUS_MOBS" -> "looting";
            case "LUCK" -> "luck_of_the_sea";
            case "LURE" -> "lure";
            case "MENDING" -> "mending";
            case "OXYGEN" -> "respiration";
            case "PROTECTION_ENVIRONMENTAL" -> "protection";
            case "PROTECTION_EXPLOSIONS" -> "blast_protection";
            case "PROTECTION_FALL" -> "feather_falling";
            case "PROTECTION_FIRE" -> "fire_protection";
            case "PROTECTION_PROJECTILE" -> "projectile_protection";
            case "SILK_TOUCH" -> "silk_touch";
            case "SWEEPING_EDGE" -> "sweeping_edge";
            case "THORNS" -> "thorns";
            case "VANISHING_CURSE" -> "vanishing_cursh";
            case "WATER_WORKER" -> "aqua_affinity";
            case "SOUL_SPEED" -> "soul_speed";
            case "PIERCING" -> "piercing";
            case "QUICK_CHARGE" -> "quick_charge";
            case "SWIFT_SNEAK" -> "swift_sneak";
            case "MULTISHOT" -> "multishot";
            case "CHANNELING" -> "channeling";
            case "RIPTIDE" -> "riptide";
            case "IMPALING" -> "impaling";
            case "LOYALTY" -> "loyalty";
            default -> null;
        };
    }

    public static <E extends Enum<E>> boolean isInEnum(String value, Class<E> enumClass) {
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            if (!e.name().equals(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isHoldingAxe(@Nonnull Player player) {
        ItemStack itemMainHand = player.getInventory().getItemInMainHand();
        if (Utils.isItemReal(itemMainHand)) {
            Material mat = itemMainHand.getType();
            switch (mat) {
                case DIAMOND_AXE: 
                case IRON_AXE: 
                case WOODEN_AXE: 
                case STONE_AXE: 
                case GOLDEN_AXE: 
                case NETHERITE_AXE: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static boolean hasArmor(@Nonnull Entity entity) {
        LivingEntity living;
        EntityEquipment equipment;
        if (entity instanceof LivingEntity && (equipment = (living = (LivingEntity)entity).getEquipment()) != null) {
            ItemStack[] armor;
            for (ItemStack item : armor = equipment.getArmorContents()) {
                if (!Utils.isItemReal(item)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasChestplate(@Nonnull Entity entity) {
        LivingEntity living;
        EntityEquipment equipment;
        if (entity instanceof LivingEntity && (equipment = (living = (LivingEntity)entity).getEquipment()) != null) {
            ItemStack chestplate = equipment.getChestplate();
            return Utils.isItemReal(chestplate);
        }
        return false;
    }

    @Nullable
    public static Color valueOfColor(@Nonnull String color) {
        return switch (color) {
            case "AQUA" -> Color.AQUA;
            case "BLACK" -> Color.BLACK;
            case "BLUE" -> Color.BLUE;
            case "FUCHSIA" -> Color.FUCHSIA;
            case "GRAY" -> Color.GRAY;
            case "GREEN" -> Color.GREEN;
            case "LIME" -> Color.LIME;
            case "MAROON" -> Color.MAROON;
            case "NAVY" -> Color.NAVY;
            case "OLIVE" -> Color.OLIVE;
            case "ORANGE" -> Color.ORANGE;
            case "PURPLE" -> Color.PURPLE;
            case "RED" -> Color.RED;
            case "SILVER" -> Color.SILVER;
            case "TEAL" -> Color.TEAL;
            case "WHITE" -> Color.WHITE;
            case "YELLOW" -> Color.YELLOW;
            default -> null;
        };
    }

    public static boolean isItemReal(@Nullable ItemStack item) {
        return item != null && item.getType() != Material.AIR && item.getAmount() >= 1;
    }

    public static void damageEntity(@Nonnull org.bukkit.entity.Damageable entity, double damage, @Nullable Entity attacker) {
        double points = 0.0;
        double toughness = 0.0;
        int resistance = 0;
        int epf = 0;
        if (entity instanceof LivingEntity) {
            PotionEffect effect;
            LivingEntity living = (LivingEntity)entity;
            AttributeInstance armor = living.getAttribute(Attribute.GENERIC_ARMOR);
            AttributeInstance armorToughness = living.getAttribute(Attribute.GENERIC_ARMOR_TOUGHNESS);
            EntityEquipment equipment = living.getEquipment();
            if (armor != null) {
                points = armor.getValue();
            }
            if (armorToughness != null) {
                toughness = armorToughness.getValue();
            }
            int n = resistance = (effect = living.getPotionEffect(PotionEffectType.DAMAGE_RESISTANCE)) == null ? 0 : effect.getAmplifier();
            if (equipment != null) {
                epf = Utils.getEPF(equipment);
            }
        }
        entity.damage(Utils.calculateDamageApplied(damage, points, toughness, resistance, epf), attacker);
    }

    public static double calculateDamageApplied(double damage, double points, double toughness, int resistance, int epf) {
        double withArmorAndToughness = damage * (1.0 - Math.min(20.0, Math.max(points / 5.0, points - damage / (2.0 + toughness / 4.0))) / 25.0);
        double withResistance = withArmorAndToughness * (1.0 - (double)resistance * 0.2);
        return withResistance * (1.0 - Math.min(20.0, (double)epf) / 25.0);
    }

    public static int getEPF(@Nonnull EntityEquipment inv) {
        ItemStack helm = inv.getHelmet();
        ItemStack chest = inv.getChestplate();
        ItemStack legs = inv.getLeggings();
        ItemStack boot = inv.getBoots();
        return (helm != null ? helm.getEnchantmentLevel(Enchantment.PROTECTION_ENVIRONMENTAL) : 0) + (chest != null ? chest.getEnchantmentLevel(Enchantment.PROTECTION_ENVIRONMENTAL) : 0) + (legs != null ? legs.getEnchantmentLevel(Enchantment.PROTECTION_ENVIRONMENTAL) : 0) + (boot != null ? boot.getEnchantmentLevel(Enchantment.PROTECTION_ENVIRONMENTAL) : 0);
    }

    public static void setFreezingView(@Nonnull Player player, int ticks) {
        internals.setFreezingView(player, ticks);
    }

    public static <T> void addNbtTag(@Nonnull Entity entity, @Nonnull String key, @Nonnull T value, @Nonnull PersistentDataType<T, T> type) {
        RSVPlugin.getUtil().addInternalNbtTag(entity, key, value, type);
    }

    public static <T> void addNbtTag(@Nonnull ItemStack item, @Nonnull String key, @Nonnull T value, @Nonnull PersistentDataType<T, T> type) {
        RSVPlugin.getUtil().addInternalNbtTag(item, key, value, type);
    }

    @Nullable
    public static <T> T getNbtTag(@Nonnull Entity entity, @Nonnull String key, @Nonnull PersistentDataType<T, T> type) {
        return RSVPlugin.getUtil().getInternalNbtTag(entity, key, type);
    }

    @Nullable
    public static <T> T getNbtTag(@Nonnull ItemStack item, @Nonnull String key, @Nonnull PersistentDataType<T, T> type) {
        return RSVPlugin.getUtil().getInternalNbtTag(item, key, type);
    }

    public static boolean hasNbtTag(@Nonnull Entity entity, @Nonnull String key) {
        return RSVPlugin.getUtil().hasInternalNbtTag(entity, key);
    }

    public static boolean hasNbtTag(@Nonnull ItemStack item, @Nonnull String key) {
        return RSVPlugin.getUtil().hasInternalNbtTag(item, key);
    }

    public static int getMaxDurability(@Nonnull ItemStack item) {
        return Utils.hasCustomDurability(item) ? Utils.getMaxCustomDurability(item) : Utils.getMaxVanillaDurability(item);
    }

    public static int getMaxCustomDurability(@Nonnull ItemStack item) {
        return (Integer)Utils.getNbtTag(item, "rsvmaxdurability", PersistentDataType.INTEGER);
    }

    public static int getMaxVanillaDurability(@Nonnull ItemStack item) {
        return item.getType().getMaxDurability();
    }

    public static int getDurability(@Nonnull ItemStack item) {
        return Utils.hasCustomDurability(item) ? Utils.getCustomDurability(item) : Utils.getVanillaDurability(item);
    }

    public static int getVanillaDurability(@Nonnull ItemStack item) {
        return Utils.getMaxVanillaDurability(item) - ((Damageable)item.getItemMeta()).getDamage();
    }

    public static int getCustomDurability(@Nonnull ItemStack item) {
        return (Integer)Utils.getNbtTag(item, "rsvdurability", PersistentDataType.INTEGER);
    }

    public static boolean hasCustomDurability(@Nonnull ItemStack item) {
        return Utils.hasNbtTag(item, "rsvdurability") && Utils.hasNbtTag(item, "rsvmaxdurability");
    }

    public static void setKbMultiplier(@Nonnull Entity entity, double multiplier) {
        RSVPlugin.getUtil().setInternalKbMultiplier(entity, multiplier);
    }

    public static void setZeroKb(@Nonnull Entity entity) {
        RSVPlugin.getUtil().setInternalZeroKb(entity);
    }

    public static boolean doublesEquals(double v, double v1) {
        double tolerance = 1.0E-4;
        return Math.abs(v - v1) <= tolerance;
    }

    public static boolean doublesEquals(double v, double v1, @Nonnegative double tolerance) {
        return Math.abs(v - v1) <= tolerance;
    }

    public static boolean isUndead(@Nonnull Entity entity) {
        return internals.isUndead(entity);
    }

    public static boolean isNetheriteRecipe(@Nonnull SmithingInventory inv) {
        return internals.isNetheriteRecipe(inv);
    }

    public static boolean isTag(@Nonnull String name) {
        try {
            internals.getTag(name);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static int getRandomNum(int min, int max) {
        return (int)(Math.random() * (double)(max - min + 1)) + min;
    }

    public static double getRandomNum(double min, double max) {
        return Math.random() * (max - min) + min;
    }

    public static boolean roll(double chance) {
        return Math.random() <= chance;
    }

    public static boolean areCriticalHitConditionsMet(@Nonnull Player player, double baseDamage, double finalDamage) {
        return player.getFallDistance() > 0.0f && player.isOnGround() && !player.getLocation().getBlock().isLiquid() && !Tag.CLIMBABLE.isTagged((Keyed)player.getLocation().getBlock().getType()) && !player.hasPotionEffect(PotionEffectType.BLINDNESS) && player.getVehicle() == null && !player.isSprinting() && finalDamage > 0.848 * baseDamage;
    }

    @Nullable
    public static Tag<Material> getTag(@Nonnull String name) {
        return internals.getTag(name);
    }

    public static boolean isSourceLiquid(@Nonnull Block block) {
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Levelled) {
            return ((Levelled)blockData).getLevel() == 0;
        }
        return false;
    }

    public static boolean isExposedToSky(@Nonnull Player player) {
        Location loc = player.getLocation();
        int highestY = loc.getWorld().getHighestBlockYAt(loc);
        return loc.getY() >= (double)highestY;
    }

    public static void discoverRecipe(@Nonnull Player player, @Nonnull Recipe recipe) {
        Keyed keyed;
        NamespacedKey key;
        if (recipe instanceof Keyed && !player.hasDiscoveredRecipe(key = (keyed = (Keyed)recipe).getKey())) {
            player.discoverRecipe(key);
        }
    }

    public static boolean dropFortune(@Nonnull ConfigurationSection section, @Nonnull ItemStack drop, @Nullable ItemStack tool, @Nonnull Location loc) {
        int lvl = 0;
        if (Utils.isItemReal(tool)) {
            lvl = tool.getEnchantmentLevel(Enchantment.LOOT_BONUS_BLOCKS);
        }
        switch (section.getString("Type").toUpperCase()) {
            case "RARE": 
            case "COMMON": {
                double chance = section.getDouble("Chance");
                double rawAmount = (1.0 / ((double)lvl + 2.0) + ((double)lvl + 1.0) / 2.0) * chance;
                int actualAmount = (int)Math.floor(rawAmount);
                double dif = rawAmount - (double)actualAmount;
                if (Utils.roll(dif)) {
                    ++actualAmount;
                }
                if (actualAmount <= 0) break;
                drop.setAmount(actualAmount);
                loc.getWorld().dropItemNaturally(loc, drop);
                return true;
            }
            case "RANGE": {
                int min = section.getInt("MinAmount");
                int max = section.getInt("MaxAmount");
                int amount = Utils.getRandomNum(min, max);
                if (amount <= 0) break;
                drop.setAmount(amount);
                loc.getWorld().dropItemNaturally(loc, drop);
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static EquipmentSlot getSlotContainingRsvItem(@Nonnull Player player, @Nonnull String rsvName) {
        PlayerInventory inv = player.getInventory();
        ItemStack helmet = inv.getHelmet();
        ItemStack chestplate = inv.getChestplate();
        ItemStack leggings = inv.getLeggings();
        ItemStack boots = inv.getBoots();
        ItemStack mainHand = inv.getItemInMainHand();
        ItemStack offHand = inv.getItemInOffHand();
        if (RSVItem.isRSVItem(mainHand) && RSVItem.getNameFromItem(mainHand).equals(rsvName)) {
            return EquipmentSlot.HAND;
        }
        if (RSVItem.isRSVItem(offHand) && RSVItem.getNameFromItem(offHand).equals(rsvName)) {
            return EquipmentSlot.OFF_HAND;
        }
        if (RSVItem.isRSVItem(helmet) && RSVItem.getNameFromItem(helmet).equals(rsvName)) {
            return EquipmentSlot.HEAD;
        }
        if (RSVItem.isRSVItem(chestplate) && RSVItem.getNameFromItem(chestplate).equals(rsvName)) {
            return EquipmentSlot.CHEST;
        }
        if (RSVItem.isRSVItem(leggings) && RSVItem.getNameFromItem(leggings).equals(rsvName)) {
            return EquipmentSlot.LEGS;
        }
        if (RSVItem.isRSVItem(boots) && RSVItem.getNameFromItem(boots).equals(rsvName)) {
            return EquipmentSlot.FEET;
        }
        return null;
    }

    @Nullable
    public static ItemStack getMobLoot(@Nonnull ConfigurationSection section, @Nonnull ItemStack drop, @Nullable ItemStack tool, boolean checkLooting) {
        int lvl = 0;
        if (Utils.isItemReal(tool) && checkLooting) {
            lvl = tool.getEnchantmentLevel(Enchantment.LOOT_BONUS_MOBS);
        }
        switch (section.getString("Type").toUpperCase()) {
            case "RARE": {
                double chance = section.getDouble("Chance") + (double)lvl * 0.01;
                if (Utils.roll(chance)) {
                    return drop;
                }
                if (!Utils.roll((double)lvl / ((double)lvl + 1.0) / 100.0)) break;
                return drop;
            }
            case "COMMON": {
                double chance = section.getDouble("Chance");
                if (!Utils.roll(chance + (double)lvl * 0.01)) break;
                int maxAmount = lvl + 1;
                double rawAmount = chance * (double)maxAmount;
                int actualAmount = (int)Math.floor(rawAmount);
                double dif = rawAmount - (double)actualAmount;
                if (Utils.roll(dif)) {
                    ++actualAmount;
                }
                if (actualAmount <= 0) break;
                drop.setAmount(actualAmount);
                return drop;
            }
            case "RANGE": {
                int min = section.getInt("MinAmount");
                int max = section.getInt("MaxAmount");
                int amount = Utils.getRandomNum(min, max);
                if (amount <= 0) break;
                drop.setAmount(amount);
                return drop;
            }
        }
        return null;
    }

    public static boolean dropLooting(@Nonnull ConfigurationSection section, @Nonnull ItemStack drop, @Nullable ItemStack tool, @Nonnull Location loc, boolean checkLooting) {
        ItemStack item = Utils.getMobLoot(section, drop, tool, checkLooting);
        if (Utils.isItemReal(item)) {
            loc.getWorld().dropItemNaturally(loc, item);
            return true;
        }
        return false;
    }

    @Nullable
    public static Set<Material> getVanillaRepairMaterials(@Nonnull Material material) {
        return switch (material) {
            case Material.NETHERITE_HELMET, Material.NETHERITE_CHESTPLATE, Material.NETHERITE_LEGGINGS, Material.NETHERITE_BOOTS, Material.NETHERITE_AXE, Material.NETHERITE_PICKAXE, Material.NETHERITE_SWORD, Material.NETHERITE_SHOVEL, Material.NETHERITE_HOE -> Set.of(Material.NETHERITE_INGOT);
            case Material.DIAMOND_HELMET, Material.DIAMOND_CHESTPLATE, Material.DIAMOND_LEGGINGS, Material.DIAMOND_BOOTS, Material.DIAMOND_AXE, Material.DIAMOND_PICKAXE, Material.DIAMOND_SWORD, Material.DIAMOND_SHOVEL, Material.DIAMOND_HOE -> Set.of(Material.DIAMOND);
            case Material.CHAINMAIL_HELMET, Material.IRON_HELMET, Material.CHAINMAIL_CHESTPLATE, Material.IRON_CHESTPLATE, Material.CHAINMAIL_LEGGINGS, Material.IRON_LEGGINGS, Material.CHAINMAIL_BOOTS, Material.IRON_BOOTS, Material.IRON_AXE, Material.IRON_PICKAXE, Material.IRON_SWORD, Material.IRON_SHOVEL, Material.IRON_HOE -> Set.of(Material.IRON_INGOT);
            case Material.GOLDEN_HELMET, Material.GOLDEN_CHESTPLATE, Material.GOLDEN_LEGGINGS, Material.GOLDEN_BOOTS, Material.GOLDEN_AXE, Material.GOLDEN_PICKAXE, Material.GOLDEN_SWORD, Material.GOLDEN_SHOVEL, Material.GOLDEN_HOE -> Set.of(Material.GOLD_INGOT);
            case Material.STONE_AXE, Material.STONE_PICKAXE, Material.STONE_SWORD, Material.STONE_SHOVEL, Material.STONE_HOE -> Set.of(Material.COBBLESTONE, Material.BLACKSTONE);
            case Material.WOODEN_AXE, Material.WOODEN_PICKAXE, Material.WOODEN_SWORD, Material.WOODEN_SHOVEL, Material.WOODEN_HOE, Material.SHIELD -> Tag.PLANKS.getValues();
            case Material.LEATHER_HELMET, Material.LEATHER_CHESTPLATE, Material.LEATHER_LEGGINGS, Material.LEATHER_BOOTS -> Set.of(Material.LEATHER);
            case Material.TURTLE_HELMET -> Set.of(Material.SCUTE);
            default -> null;
        };
    }

    public static boolean isNetherite(@Nonnull Material material) {
        return switch (material) {
            case Material.NETHERITE_HELMET, Material.NETHERITE_CHESTPLATE, Material.NETHERITE_LEGGINGS, Material.NETHERITE_BOOTS, Material.NETHERITE_AXE, Material.NETHERITE_PICKAXE, Material.NETHERITE_SWORD, Material.NETHERITE_SHOVEL, Material.NETHERITE_HOE -> true;
            default -> false;
        };
    }

    public static boolean isDiamond(@Nonnull Material material) {
        return switch (material) {
            case Material.DIAMOND_HELMET, Material.DIAMOND_CHESTPLATE, Material.DIAMOND_LEGGINGS, Material.DIAMOND_BOOTS, Material.DIAMOND_AXE, Material.DIAMOND_PICKAXE, Material.DIAMOND_SWORD, Material.DIAMOND_SHOVEL, Material.DIAMOND_HOE -> true;
            default -> false;
        };
    }

    @Nullable
    public static Material getRespectivePlank(@Nonnull Material wood) {
        return switch (wood.toString()) {
            case "OAK_WOOD", "OAK_LOG", "STRIPPED_OAK_LOG", "STRIPPED_OAK_WOOD" -> Material.OAK_PLANKS;
            case "BIRCH_WOOD", "BIRCH_LOG", "STRIPPED_BIRCH_LOG", "STRIPPED_BIRCH_WOOD" -> Material.BIRCH_PLANKS;
            case "SPRUCE_WOOD", "SPRUCE_LOG", "STRIPPED_SPRUCE_LOG", "STRIPPED_SPRUCE_WOOD" -> Material.SPRUCE_PLANKS;
            case "ACACIA_WOOD", "ACACIA_LOG", "STRIPPED_ACACIA_LOG", "STRIPPED_ACACIA_WOOD" -> Material.ACACIA_PLANKS;
            case "JUNGLE_WOOD", "JUNGLE_LOG", "STRIPPED_JUNGLE_LOG", "STRIPPED_JUNGLE_WOOD" -> Material.JUNGLE_PLANKS;
            case "CRIMSON_STEM", "CRIMSON_HYPHAE", "STRIPPED_CRIMSON_HYPHAE", "STRIPPED_CRIMSON_STEM" -> Material.CRIMSON_PLANKS;
            case "WARPED_STEM", "WARPED_HYPHAE", "STRIPPED_WARPED_HYPHAE", "STRIPPED_WARPED_STEM" -> Material.WARPED_PLANKS;
            case "DARK_OAK_WOOD", "DARK_OAK_LOG", "STRIPPED_DARK_OAK_LOG", "STRIPPED_DARK_OAK_WOOD" -> Material.DARK_OAK_PLANKS;
            case "MANGROVE_WOOD", "MANGROVE_LOG", "STRIPPED_MANGROVE_LOG", "STRIPPED_MANGROVE_WOOD" -> Material.valueOf((String)"MANGROVE_PLANKS");
            case "BAMBOO_BLOCK", "STRIPPED_BAMBOO_BLOCK" -> Material.valueOf((String)"BAMBOO_PLANKS");
            case "CHERRY_WOOD", "CHERRY_LOG", "STRIPPED_CHERRY_WOOD", "STRIPPED_CHERRY_LOG" -> Material.valueOf((String)"CHERRY_PLANKS");
            case "PALE_OAK_WOOD", "PALE_OAK_LOG", "STRIPPED_PALE_OAK_WOOD", "STRIPPED_PALE_OAK_LOG" -> Material.valueOf((String)"PALE_OAK_PLANKS");
            default -> null;
        };
    }

    public static boolean matchMaterial(@Nullable Material mat, @Nullable String key, boolean ignoreTags) {
        if (mat == null || key == null) {
            return false;
        }
        if (ignoreTags) {
            return mat.toString().equals(key);
        }
        RecipeChoice choice = RSVRecipe.getRecipeChoice(key);
        return choice != null && choice.test(new ItemStack(mat));
    }

    public static boolean matchMaterial(@Nullable Material mat, @Nullable Collection<String> keys, boolean ignoreTags) {
        if (mat == null || keys == null) {
            return false;
        }
        if (ignoreTags) {
            for (String key : keys) {
                if (!mat.toString().equals(key)) continue;
                return true;
            }
            return false;
        }
        ItemStack item = null;
        try {
            item = new ItemStack(mat);
        }
        catch (IllegalArgumentException ignored) {
            return false;
        }
        for (String key : keys) {
            RecipeChoice choice = RSVRecipe.getRecipeChoice(key);
            if (choice == null || !choice.test(item)) continue;
            return true;
        }
        return false;
    }

    public static void attack(@Nonnull LivingEntity attacker, @Nonnull Entity defender) {
        internals.attack(attacker, defender);
    }

    public static void changeDurability(@Nonnull ItemStack item, int change, boolean shouldBreak, boolean playBreakSound, @Nullable Entity user) {
        Player player;
        ItemMeta meta = item.getItemMeta();
        if (user instanceof Player && (player = (Player)user).getGameMode() == GameMode.CREATIVE && change < 0) {
            return;
        }
        int lvl = meta.hasEnchant(Enchantment.DURABILITY) ? meta.getEnchantLevel(Enchantment.DURABILITY) : 0;
        boolean hasCustomDurability = Utils.hasCustomDurability(item);
        int actualChange = change;
        if (change < 0 && lvl > 0) {
            for (int i = 0; i < -change; ++i) {
                if (!Utils.roll(1.0 / ((double)lvl + 1.0))) continue;
                ++actualChange;
            }
        }
        short maxMcDurability = item.getType().getMaxDurability();
        if (hasCustomDurability) {
            int rsvDurability = Utils.getCustomDurability(item);
            int rsvMaxDurability = Utils.getMaxCustomDurability(item);
            rsvDurability += actualChange;
            if (maxMcDurability > 0) {
                int mcDurability = (int)Math.ceil((double)rsvDurability / (double)rsvMaxDurability * (double)maxMcDurability);
                ((Damageable)meta).setDamage(maxMcDurability - mcDurability);
            }
            if (rsvDurability < 0 && shouldBreak) {
                item.setAmount(0);
                item.setType(Material.AIR);
                if (playBreakSound && user != null) {
                    Utils.playSound(user.getLocation(), Sound.ENTITY_ITEM_BREAK.toString(), 1.0f, 1.0f);
                }
            } else {
                item.setItemMeta(meta);
                Utils.addNbtTag(item, "rsvdurability", Integer.valueOf(Math.min(rsvDurability, rsvMaxDurability)), PersistentDataType.INTEGER);
                Utils.updateLore(item, Math.min(rsvDurability, rsvMaxDurability));
            }
        } else if (maxMcDurability > 0) {
            int mcDurability = maxMcDurability - ((Damageable)meta).getDamage();
            ((Damageable)meta).setDamage(maxMcDurability - (mcDurability += actualChange));
            if (mcDurability < 0 && shouldBreak) {
                item.setAmount(0);
                item.setType(Material.AIR);
                if (playBreakSound && user != null) {
                    Utils.playSound(user.getLocation(), Sound.ENTITY_ITEM_BREAK.toString(), 1.0f, 1.0f);
                }
            }
            item.setItemMeta(meta);
        }
    }

    public static boolean canRain(@Nonnull Location loc) {
        double biomeTemp = loc.getWorld().getTemperature((int)loc.getX(), (int)loc.getY(), (int)loc.getZ());
        return biomeTemp >= 0.15 && biomeTemp <= 0.95 && loc.getWorld().getEnvironment() == World.Environment.NORMAL;
    }

    public static boolean isInLava(@Nonnull Entity entity) {
        return entity.getLocation().getBlock().getType() == Material.LAVA;
    }

    public static void updateItem(@Nonnull ItemStack item) {
        RSVPlugin.getUtil().updateInternalItem(item);
    }

    @Nonnull
    public static ItemStack getNetheriteRSVWeapon(@Nonnull ItemStack item) {
        return RSVPlugin.getUtil().getInternalNetheriteRSVWeapon(item);
    }

    @Nonnull
    public static EndermanAlly spawnEndermanAlly(@Nonnull Player owner, @Nonnull Location loc) {
        return internals.spawnEndermanAlly(owner, loc);
    }

    @Nonnull
    public static FireDragon spawnFireDragon(@Nonnull Location loc) {
        return internals.spawnFireDragon(loc);
    }

    @Nonnull
    public static FireDragon spawnFireDragon(@Nonnull Location loc, int stage) {
        return internals.spawnFireDragon(loc, stage);
    }

    @Nonnull
    public static FireDragon spawnFireDragon(@Nonnull Location loc, @Nonnull DragonVariant variant) {
        return internals.spawnFireDragon(loc, variant);
    }

    public static FireDragon spawnFireDragon(@Nonnull Location loc, @Nonnull DragonVariant variant, int stage) {
        return internals.spawnFireDragon(loc, variant, stage);
    }

    @Nonnull
    public static IceDragon spawnIceDragon(@Nonnull Location loc) {
        return internals.spawnIceDragon(loc);
    }

    @Nonnull
    public static IceDragon spawnIceDragon(@Nonnull Location loc, int stage) {
        return internals.spawnIceDragon(loc, stage);
    }

    @Nonnull
    public static IceDragon spawnIceDragon(@Nonnull Location loc, @Nonnull DragonVariant variant) {
        return internals.spawnIceDragon(loc, variant);
    }

    @Nonnull
    public static IceDragon spawnIceDragon(@Nonnull Location loc, @Nonnull DragonVariant variant, int stage) {
        return internals.spawnIceDragon(loc, variant, stage);
    }

    @Nonnull
    public static LightningDragon spawnLightningDragon(@Nonnull Location loc) {
        return internals.spawnLightningDragon(loc);
    }

    @Nonnull
    public static LightningDragon spawnLightningDragon(@Nonnull Location loc, int stage) {
        return internals.spawnLightningDragon(loc, stage);
    }

    @Nonnull
    public static LightningDragon spawnLightningDragon(@Nonnull Location loc, @Nonnull DragonVariant variant) {
        return internals.spawnLightningDragon(loc, variant);
    }

    @Nonnull
    public static LightningDragon spawnLightningDragon(@Nonnull Location loc, @Nonnull DragonVariant variant, int stage) {
        return internals.spawnLightningDragon(loc, variant, stage);
    }

    @Nonnull
    public static SeaSerpent spawnSeaSerpent(@Nonnull Location loc) {
        return internals.spawnSeaSerpent(loc);
    }

    @Nonnull
    public static SeaSerpent spawnSeaSerpent(@Nonnull Location loc, @Nonnull SeaSerpentVariant variant) {
        return internals.spawnSeaSerpent(loc, variant);
    }

    @Nonnull
    public static Siren spawnSiren(@Nonnull Location loc) {
        return internals.spawnSiren(loc);
    }

    public static boolean hasItemModel(@Nonnull ItemMeta meta) {
        return internals.hasItemModel(meta);
    }

    public static NamespacedKey getItemModel(@Nonnull ItemMeta meta) {
        return internals.getItemModel(meta);
    }

    public static void setItemModel(@Nonnull ItemMeta meta, @Nullable NamespacedKey key) {
        internals.setItemModel(meta, key);
    }

    public static boolean hasEquippableComponentModel(@Nonnull ItemMeta meta) {
        return internals.hasEquippableComponentModel(meta);
    }

    public static NamespacedKey getEquippableComponentModel(@Nonnull ItemMeta meta) {
        return internals.getEquippableComponentModel(meta);
    }

    public static void setEquippableComponentModel(@Nonnull ItemMeta meta, @Nullable NamespacedKey key, @Nonnull EquipmentSlot slot) {
        internals.setEquippableComponentModel(meta, key, slot);
    }

    public static boolean isBestTool(@Nonnull Block block, @Nullable ItemStack tool) {
        ToolHandler.Tool bestTool = Utils.getBestTool(block.getType());
        if (Utils.isItemReal(tool)) {
            return tool.getType().toString().contains(bestTool.toString()) || bestTool == ToolHandler.Tool.NONE;
        }
        return bestTool == ToolHandler.Tool.NONE;
    }

    public static boolean hasSilkTouch(@Nonnull ItemStack item) {
        if (Utils.isItemReal(item)) {
            return !item.getItemMeta().hasEnchant(Enchantment.SILK_TOUCH);
        }
        return true;
    }

    @Nonnull
    public static ToolHandler.Tool getBestTool(@Nonnull Material mat) {
        return RSVPlugin.getUtil().getInternalBestTool(mat);
    }

    public static void registerEntities() {
        internals.registerEntities();
    }

    @Nonnull
    public static EulerAngle setRightArmAngle(@Nonnull ArmorStand armorStand, int x, int y, int z) {
        double armorStandX = armorStand.getRightArmPose().getX();
        double armorStandY = armorStand.getRightArmPose().getY();
        double armorStandZ = armorStand.getRightArmPose().getZ();
        return new EulerAngle(armorStandX + Math.toRadians(x), armorStandY + Math.toRadians(y), armorStandZ + Math.toRadians(z));
    }

    public static void playSound(@Nonnull Location loc, @Nonnull String soundName, float volume, float pitch) {
        if (soundName.contains("_")) {
            if (StringUtils.isAllUpperCase((String)soundName.substring(0, soundName.indexOf("_")))) {
                loc.getWorld().playSound(loc, Sound.valueOf((String)soundName), volume, pitch);
            } else {
                loc.getWorld().playSound(loc, soundName, volume, pitch);
            }
        } else if (soundName.equals(soundName.toUpperCase())) {
            loc.getWorld().playSound(loc, Sound.valueOf((String)soundName), volume, pitch);
        } else {
            loc.getWorld().playSound(loc, soundName, volume, pitch);
        }
    }

    @Nonnull
    public static ItemStack updateLore(@Nonnull ItemStack item, int newDurability) {
        ItemMeta meta;
        List lore;
        if (Utils.hasCustomDurability(item) && (lore = (meta = item.getItemMeta()).getLore()) != null && !lore.isEmpty()) {
            int maxDurability = Utils.getMaxCustomDurability(item);
            boolean changedDurability = false;
            boolean isJuice = Utils.hasNbtTag(item, "rsvdrink");
            boolean changedJuice = false;
            for (int i = 0; i < lore.size(); ++i) {
                if (((String)lore.get(i)).contains("Durability:")) {
                    lore.set(i, String.valueOf(ChatColor.GRAY) + "Durability: " + newDurability + "/" + maxDurability);
                    changedDurability = true;
                }
                if (isJuice && ((String)lore.get(i)).contains("Drink: ")) {
                    lore.set(i, String.valueOf(ChatColor.GRAY) + "Drink: " + (String)Utils.getNbtTag(item, "rsvdrink", PersistentDataType.STRING));
                    changedJuice = true;
                }
                if (isJuice ? changedJuice && changedDurability : changedDurability) break;
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    @Nonnegative
    public static int addItemToInventory(@Nonnull Inventory inv, @Nonnull ItemStack item, @Nonnegative int amount) {
        item = item.clone();
        int maxStackSize = item.getMaxStackSize();
        int leftover = 0;
        while (amount >= maxStackSize) {
            if (inv.firstEmpty() == -1) {
                return leftover += amount;
            }
            item.setAmount(maxStackSize);
            int excess = inv.addItem(new ItemStack[]{item}).keySet().stream().mapToInt(Integer::intValue).sum();
            amount += excess;
            amount -= maxStackSize;
        }
        int remainder = amount % maxStackSize;
        if (remainder > 0) {
            if (inv.firstEmpty() == -1) {
                leftover += remainder;
            } else {
                item.setAmount(remainder);
                inv.addItem(new ItemStack[]{item});
            }
        }
        return leftover;
    }

    public static void addItemToInventory(@Nonnull Inventory inv, @Nonnull ItemStack item, @Nonnegative int amount, @Nonnull Location loc) {
        int leftover;
        item = item.clone();
        int maxStackSize = item.getMaxStackSize();
        int remainder = leftover % maxStackSize;
        for (leftover = Utils.addItemToInventory(inv, item, amount); leftover > maxStackSize; leftover -= maxStackSize) {
            item.setAmount(maxStackSize);
            loc.getWorld().dropItemNaturally(loc, item);
        }
        if (remainder > 0) {
            item.setAmount(remainder);
            loc.getWorld().dropItemNaturally(loc, item);
        }
    }

    @Nonnull
    public static String toRomanNumeral(int num) {
        int[] values = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        String[] romanLetters = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        StringBuilder roman = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            while (num >= values[i]) {
                num -= values[i];
                roman.append(romanLetters[i]);
            }
        }
        return roman.toString();
    }

    public static boolean wasBackstabbed(@Nonnull Entity attacker, @Nonnull Entity defender) {
        Vector victimDirection;
        Location attackerLoc = attacker.getLocation();
        Location defenderLoc = defender.getLocation();
        Vector attackerDirection = attackerLoc.getDirection();
        return attackerDirection.dot(victimDirection = defenderLoc.getDirection()) > 0.0;
    }

    @Nullable
    public static BlockFace getBlockFace(@Nonnull LivingEntity entity) {
        List lastTwoTargetBlocks = entity.getLastTwoTargetBlocks(null, 100);
        if (lastTwoTargetBlocks.size() != 2 || !((Block)lastTwoTargetBlocks.get(1)).getType().isOccluding()) {
            return null;
        }
        Block targetBlock = (Block)lastTwoTargetBlocks.get(1);
        Block adjacentBlock = (Block)lastTwoTargetBlocks.get(0);
        return targetBlock.getFace(adjacentBlock);
    }

    public <T> void addInternalNbtTag(@Nonnull Entity entity, @Nonnull String key, @Nonnull T value, @Nonnull PersistentDataType<T, T> type) {
        NamespacedKey nkey = new NamespacedKey((Plugin)this.plugin, key);
        entity.getPersistentDataContainer().set(nkey, type, value);
    }

    public <T> void addInternalNbtTag(@Nonnull ItemStack item, @Nonnull String key, @Nonnull T value, @Nonnull PersistentDataType<T, T> type) {
        NamespacedKey nkey = new NamespacedKey((Plugin)this.plugin, key);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.getPersistentDataContainer().set(nkey, type, value);
        item.setItemMeta(itemMeta);
    }

    @Nullable
    public <T> T getInternalNbtTag(@Nonnull Entity entity, @Nonnull String key, @Nonnull PersistentDataType<T, T> type) {
        NamespacedKey nkey = new NamespacedKey((Plugin)this.plugin, key);
        PersistentDataContainer container = entity.getPersistentDataContainer();
        if (container.getKeys().contains(nkey)) {
            return (T)container.get(nkey, type);
        }
        return null;
    }

    @Nullable
    public <T> T getInternalNbtTag(@Nonnull ItemStack item, @Nonnull String key, @Nonnull PersistentDataType<T, T> type) {
        NamespacedKey nkey = new NamespacedKey((Plugin)this.plugin, key);
        PersistentDataContainer container = item.getItemMeta().getPersistentDataContainer();
        if (container.getKeys().contains(nkey)) {
            return (T)container.get(nkey, type);
        }
        return null;
    }

    public boolean hasInternalNbtTag(@Nonnull Entity entity, @Nonnull String key) {
        NamespacedKey nkey = new NamespacedKey((Plugin)this.plugin, key);
        return entity.getPersistentDataContainer().getKeys().contains(nkey);
    }

    public boolean hasInternalNbtTag(@Nonnull ItemStack item, @Nonnull String key) {
        NamespacedKey nkey = new NamespacedKey((Plugin)this.plugin, key);
        ItemMeta itemMeta = item.getItemMeta();
        return itemMeta.getPersistentDataContainer().getKeys().contains(nkey);
    }

    public void setInternalKbMultiplier(@Nonnull Entity entity, double multiplier) {
        new KbTask(this.plugin, entity, multiplier).start();
    }

    public void setInternalZeroKb(@Nonnull Entity entity) {
        Utils.setKbMultiplier(entity, 0.0);
    }

    public void updateInternalItem(@Nonnull ItemStack item) {
        FileConfiguration config = this.plugin.getCommandsConfig();
        if (RSVItem.isRSVItem(item)) {
            RSVItem rsvItem = RSVItem.getItem(RSVItem.getNameFromItem(item));
            ItemMeta rsvMeta = rsvItem.getItemMeta();
            if (config.getBoolean("UpdateItem.Material")) {
                item.setType(rsvItem.getType());
            }
            if (config.getBoolean("UpdateItem.MaterialData")) {
                item.setData(rsvItem.getData());
            }
            ItemMeta meta = item.getItemMeta();
            if (config.getBoolean("UpdateItem.DisplayName") && rsvMeta.hasDisplayName()) {
                meta.setDisplayName(rsvMeta.getDisplayName());
            }
            if (config.getBoolean("UpdateItem.Lore") && rsvMeta.hasLore()) {
                meta.setLore(rsvMeta.getLore());
            }
            if (config.getBoolean("UpdateItem.Unbreakability")) {
                meta.setUnbreakable(rsvMeta.isUnbreakable());
            }
            if (config.getBoolean("UpdateItem.AttributeModifiers") && rsvMeta.hasAttributeModifiers()) {
                meta.setAttributeModifiers(rsvMeta.getAttributeModifiers());
            }
            if (config.getBoolean("UpdateItem.AttributeModifiers") && rsvMeta.hasLocalizedName()) {
                meta.setLocalizedName(rsvMeta.getLocalizedName());
            }
            if (config.getBoolean("UpdateItem.CustomModelData") && rsvMeta.hasCustomModelData()) {
                meta.setCustomModelData(Integer.valueOf(rsvMeta.getCustomModelData()));
            }
            if (config.getBoolean("UpdateItem.ItemModel") && internals.hasItemModel(rsvMeta)) {
                internals.setItemModel(meta, internals.getItemModel(rsvMeta));
            }
            if (config.getBoolean("UpdateItem.EquippableComponent") && internals.hasEquippableComponentModel(rsvMeta)) {
                internals.setEquippableComponentModel(meta, internals.getEquippableComponentModel(rsvMeta), Utils.getEquipmentSlotFromMaterial(item.getType()));
            }
            if (config.getBoolean("UpdateItem.Enchants.Enabled")) {
                Map map = meta.getEnchants();
                if (!config.getBoolean("UpdateItem.Enchants.PreserveExistingEnchants")) {
                    Set enchants = map.keySet();
                    for (Enchantment ench : enchants) {
                        meta.removeEnchant(ench);
                    }
                }
                if (rsvMeta.hasEnchants()) {
                    Map rsvMap = rsvMeta.getEnchants();
                    Set entries = rsvMap.entrySet();
                    for (Map.Entry entry : entries) {
                        meta.addEnchant((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue(), true);
                    }
                }
            }
            if (config.getBoolean("UpdateItem.ItemFlags.Enabled")) {
                Set flags = meta.getItemFlags();
                Set rsvFlags = rsvMeta.getItemFlags();
                if (!config.getBoolean("UpdateItem.ItemFlags.PreserveExistingItemFlags")) {
                    for (ItemFlag flag : flags) {
                        if (flag == null) continue;
                        meta.removeItemFlags(new ItemFlag[]{flag});
                    }
                }
                for (ItemFlag flag : rsvFlags) {
                    if (flag == null) continue;
                    meta.addItemFlags(new ItemFlag[]{flag});
                }
            }
            if (config.getBoolean("UpdateItem.VanillaDurability") && rsvItem.getType().getMaxDurability() > 0) {
                ((Damageable)meta).setDamage(((Damageable)rsvMeta).getDamage());
            }
            item.setItemMeta(meta);
            Utils.updateDamageLore(item, meta.getEnchants().entrySet());
            if (config.getBoolean("UpdateItem.NbtTags.Enabled")) {
                if (config.getBoolean("UpdateItem.NbtTags.Module")) {
                    Utils.addNbtTag(item, "rsvmodule", RSVItem.getModuleNameFromItem(rsvItem), PersistentDataType.STRING);
                }
                if (config.getBoolean("UpdateItem.NbtTags.CustomDurability") && Utils.hasCustomDurability(rsvItem)) {
                    Utils.addNbtTag(item, "rsvdurability", Integer.valueOf(Utils.getCustomDurability(rsvItem)), PersistentDataType.INTEGER);
                    Utils.addNbtTag(item, "rsvmaxdurability", Integer.valueOf(Utils.getMaxCustomDurability(rsvItem)), PersistentDataType.INTEGER);
                }
            }
        }
    }

    @Nonnull
    public ItemStack getInternalNetheriteRSVWeapon(@Nonnull ItemStack item) {
        ItemStack clone = item.clone();
        FileConfiguration config = RSVModule.getModule(RSVItem.getModuleNameFromItem(clone)).getUserConfig().getConfig();
        if (config.getBoolean("UpdateNetheriteItems.Enabled") && RSVItem.isRSVItem(clone)) {
            RSVItem rsvItem = RSVItem.getItem(RSVItem.getNameFromItem(clone).replace("diamond", "netherite"));
            ItemMeta rsvMeta = rsvItem.getItemMeta();
            if (config.getBoolean("UpdateNetheriteItems.UpdateMaterial")) {
                clone.setType(rsvItem.getType());
            }
            if (config.getBoolean("UpdateNetheriteItems.UpdateMaterialData")) {
                clone.setData(rsvItem.getData());
            }
            ItemMeta meta = clone.getItemMeta();
            if (config.getBoolean("UpdateNetheriteItems.UpdateDisplayName") && rsvMeta.hasDisplayName()) {
                meta.setDisplayName(rsvMeta.getDisplayName());
            }
            if (config.getBoolean("UpdateNetheriteItems.UpdateLore") && rsvMeta.hasLore()) {
                meta.setLore(rsvMeta.getLore());
            }
            if (config.getBoolean("UpdateNetheriteItems.UpdateUnbreakability")) {
                meta.setUnbreakable(rsvMeta.isUnbreakable());
            }
            if (config.getBoolean("UpdateNetheriteItems.UpdateAttributeModifiers") && rsvMeta.hasAttributeModifiers()) {
                meta.setAttributeModifiers(rsvMeta.getAttributeModifiers());
            }
            if (config.getBoolean("UpdateNetheriteItems.UpdateAttributeModifiers") && rsvMeta.hasLocalizedName()) {
                meta.setLocalizedName(rsvMeta.getLocalizedName());
            }
            if (config.getBoolean("UpdateNetheriteItems.UpdateCustomModelData") && rsvMeta.hasCustomModelData()) {
                meta.setCustomModelData(Integer.valueOf(rsvMeta.getCustomModelData()));
            }
            if (config.getBoolean("UpdateNetheriteItems.UpdateItemModel") && internals.hasItemModel(rsvMeta)) {
                internals.setItemModel(meta, internals.getItemModel(rsvMeta));
            }
            if (config.getBoolean("UpdateNetheriteItems.UpdateEquippableComponent") && internals.hasEquippableComponentModel(rsvMeta)) {
                internals.setEquippableComponentModel(meta, internals.getEquippableComponentModel(rsvMeta), Utils.getEquipmentSlotFromMaterial(item.getType()));
            }
            if (config.getBoolean("UpdateNetheriteItems.UpdateEnchants.Enabled")) {
                Map map = meta.getEnchants();
                if (!config.getBoolean("UpdateNetheriteItems.UpdateEnchants.PreserveExistingEnchants")) {
                    Set enchants = map.keySet();
                    for (Enchantment ench : enchants) {
                        meta.removeEnchant(ench);
                    }
                }
                if (rsvMeta.hasEnchants()) {
                    Map rsvMap = rsvMeta.getEnchants();
                    Set entries = rsvMap.entrySet();
                    for (Map.Entry entry : entries) {
                        meta.addEnchant((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue(), true);
                    }
                }
            }
            if (config.getBoolean("UpdateNetheriteItems.UpdateItemFlags.Enabled")) {
                Set flags = meta.getItemFlags();
                Set rsvFlags = rsvMeta.getItemFlags();
                if (!config.getBoolean("UpdateNetheriteItems.UpdateItemFlags.PreserveExistingItemFlags")) {
                    for (ItemFlag flag : flags) {
                        if (flag == null) continue;
                        meta.removeItemFlags(new ItemFlag[]{flag});
                    }
                }
                for (ItemFlag flag : rsvFlags) {
                    if (flag == null) continue;
                    meta.addItemFlags(new ItemFlag[]{flag});
                }
            }
            if (config.getBoolean("UpdateNetheriteItems.UpdateVanillaDurability") && rsvItem.getType().getMaxDurability() > 0) {
                ((Damageable)meta).setDamage(((Damageable)rsvMeta).getDamage());
            }
            clone.setItemMeta(meta);
            Utils.updateDamageLore(item, meta.getEnchants().entrySet());
            Utils.addNbtTag(clone, "rsvitem", RSVItem.getNameFromItem(rsvItem), PersistentDataType.STRING);
            if (config.getBoolean("UpdateNetheriteItems.UpdateNbtTags.Enabled")) {
                if (config.getBoolean("UpdateNetheriteItems.UpdateNbtTags.UpdateModule")) {
                    Utils.addNbtTag(clone, "rsvmodule", RSVItem.getModuleNameFromItem(rsvItem), PersistentDataType.STRING);
                }
                if (config.getBoolean("UpdateNetheriteItems.UpdateNbtTags.UpdateCustomDurability") && Utils.hasCustomDurability(rsvItem)) {
                    Utils.addNbtTag(clone, "rsvdurability", Integer.valueOf(Utils.getCustomDurability(rsvItem)), PersistentDataType.INTEGER);
                    Utils.addNbtTag(clone, "rsvmaxdurability", Integer.valueOf(Utils.getMaxCustomDurability(rsvItem)), PersistentDataType.INTEGER);
                }
            }
        }
        return clone;
    }

    @Nonnull
    public ToolHandler.Tool getInternalBestTool(@Nonnull Material mat) {
        return this.plugin.getToolHandler().getBestToolType(mat);
    }

    static {
        try {
            String packageName = Utils.class.getPackage().getName();
            internals = (InternalsProvider)Class.forName(packageName + "." + Utils.getMinecraftVersion(true)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            Bukkit.getLogger().log(Level.SEVERE, "NMS Util could not find a valid implementation for this server version.");
        }
    }
}

