/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.utils.recipe;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.recipe.RSVBrewingRecipe;
import org.bukkit.Material;
import org.bukkit.block.BrewingStand;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BrewClock
extends BukkitRunnable {
    private final BrewerInventory inventory;
    private final RSVBrewingRecipe recipe;
    private final ItemStack[] before;
    private final BrewingStand stand;
    private int current;

    public BrewClock(@Nonnull RSVBrewingRecipe recipe, @Nonnull BrewerInventory inventory, @Nonnegative int time, @Nonnull RSVPlugin plugin) {
        this.recipe = recipe;
        this.inventory = inventory;
        this.stand = inventory.getHolder();
        this.before = inventory.getContents();
        this.current = time;
        this.runTaskTimer((Plugin)plugin, 0L, 1L);
    }

    public void run() {
        if (this.current == 0) {
            if (this.inventory.getIngredient().getAmount() > 1) {
                ItemStack is = this.inventory.getIngredient();
                is.setAmount(this.inventory.getIngredient().getAmount() - 1);
                this.inventory.setIngredient(is);
            } else {
                this.inventory.setIngredient(new ItemStack(Material.AIR));
            }
            ItemStack newFuel = this.recipe.getFuel();
            if (this.recipe.getFuel() != null && this.recipe.getFuel().getType() != Material.AIR && this.recipe.getFuel().getAmount() > 0) {
                int count = 0;
                while (this.inventory.getFuel().getAmount() > 0 && this.stand.getFuelLevel() + this.recipe.fuelCharge < 100) {
                    this.stand.setFuelLevel(this.stand.getFuelLevel() + this.recipe.fuelPower);
                    ++count;
                }
                if (this.inventory.getFuel().getAmount() == 0) {
                    newFuel = new ItemStack(Material.AIR);
                } else {
                    this.stand.setFuelLevel(100);
                    newFuel.setAmount(this.inventory.getFuel().getAmount() - count);
                }
            } else {
                newFuel = new ItemStack(Material.AIR);
            }
            this.inventory.setFuel(newFuel);
            for (int i = 0; i < 3; ++i) {
                if (this.inventory.getItem(i) == null || this.inventory.getItem(i).getType() == Material.AIR) continue;
                this.inventory.setItem(i, this.recipe.result);
            }
            this.stand.setFuelLevel(this.stand.getFuelLevel() - this.recipe.fuelCharge);
            this.cancel();
            return;
        }
        if (this.searchChanged(this.before, this.inventory.getContents(), this.recipe.perfect)) {
            this.cancel();
            return;
        }
        --this.current;
        this.stand.setBrewingTime(this.current);
        this.stand.update(true);
    }

    public boolean searchChanged(@Nonnull ItemStack[] before, @Nonnull ItemStack[] after, boolean mode) {
        for (int i = 0; i < before.length; ++i) {
            if (before[i] != null && after[i] == null || before[i] == null && after[i] != null) {
                return false;
            }
            if (mode && !before[i].isSimilar(after[i])) {
                return false;
            }
            if (mode || before[i].getType() == after[i].getType()) continue;
            return false;
        }
        return true;
    }
}

