/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.utils.recipe;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.Ingredient;
import me.val_mobile.utils.recipe.RSVRecipe;
import me.val_mobile.utils.recipe.RecipeIngredient;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;

public class RSVShapedRecipe
extends ShapedRecipe
implements RSVRecipe {
    private final Map<Character, RecipeIngredient> ingredients = new HashMap<Character, RecipeIngredient>();

    public RSVShapedRecipe(@Nonnull FileConfiguration config, @Nonnull String name, @Nonnull RSVPlugin plugin) {
        super(new NamespacedKey((Plugin)plugin, name), RSVRecipe.getResult(config, name));
        String ingredientsPath = name + ".Ingredients";
        List ingredients = config.getStringList(ingredientsPath);
        RecipeIngredient[][] grid = new RecipeIngredient[3][3];
        for (int i = 0; i < ingredients.size(); ++i) {
            String raw = (String)ingredients.get(i);
            RecipeIngredient[] items = this.getItems(raw);
            for (int j = 0; j < items.length; ++j) {
                if (items[j] == null) continue;
                grid[i][j] = items[j];
            }
        }
        if (grid[0][2] != null || grid[1][2] != null || grid[2][2] != null || grid[2][0] != null || grid[2][1] != null) {
            chars = this.getChars(grid, 3);
            this.shape(new String[]{chars[0][0].toString() + chars[0][1] + chars[0][2], chars[1][0].toString() + chars[1][1] + chars[1][2], chars[2][0].toString() + chars[2][1] + chars[2][2]});
        } else if (grid[0][1] != null || grid[1][0] != null || grid[1][1] != null) {
            chars = this.getChars(grid, 2);
            this.shape(new String[]{chars[0][0].toString() + chars[0][1], chars[1][0].toString() + chars[1][1]});
        } else {
            chars = this.getChars(grid, 1);
            this.shape(new String[]{chars[0][0].toString()});
        }
        for (Map.Entry<Character, RecipeIngredient> entry : this.ingredients.entrySet()) {
            this.setIngredient(entry.getKey().charValue(), entry.getValue().getRecipeChoice());
        }
    }

    public RecipeIngredient[] getItems(String text) {
        RecipeIngredient[] items = new RecipeIngredient[3];
        int firstIndex = text.indexOf("|");
        int lastIndex = text.lastIndexOf("|");
        if (firstIndex == -1) {
            if (Ingredient.isValid(text)) {
                items[0] = new RecipeIngredient(text);
            }
            return items;
        }
        if (firstIndex == lastIndex) {
            String secondItem;
            String firstItem;
            if (firstIndex != 0 && Ingredient.isValid(firstItem = text.substring(0, firstIndex))) {
                items[0] = new RecipeIngredient(firstItem);
            }
            if (Ingredient.isValid(secondItem = text.substring(firstIndex + 1))) {
                items[1] = new RecipeIngredient(secondItem);
            }
        } else {
            String firstItem;
            if (firstIndex != 0 && Ingredient.isValid(firstItem = text.substring(0, firstIndex))) {
                items[0] = new RecipeIngredient(firstItem);
            }
            String secondItem = text.substring(firstIndex + 1, lastIndex);
            String thirdItem = text.substring(lastIndex + 1);
            if (Ingredient.isValid(secondItem)) {
                items[1] = new RecipeIngredient(secondItem);
            }
            if (Ingredient.isValid(thirdItem)) {
                items[2] = new RecipeIngredient(thirdItem);
            }
        }
        return items;
    }

    public Character[][] getChars(RecipeIngredient[][] items, int len) {
        Character[][] characters = new Character[len][len];
        char label = 'A';
        for (int i = 0; i < len; ++i) {
            block1: for (int j = 0; j < len; ++j) {
                if (items[i][j] == null) {
                    characters[i][j] = Character.valueOf(' ');
                    continue;
                }
                if (this.ingredients.containsValue(items[i][j])) {
                    for (Map.Entry<Character, RecipeIngredient> entry : this.ingredients.entrySet()) {
                        if (!Objects.equals(entry.getValue(), items[i][j])) continue;
                        characters[i][j] = entry.getKey();
                        continue block1;
                    }
                    continue;
                }
                this.ingredients.put(Character.valueOf(label), items[i][j]);
                characters[i][j] = Character.valueOf(label);
                label = (char)(label + '\u0001');
            }
        }
        return characters;
    }
}

