/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import me.val_mobile.data.RSVModule;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.Utils;
import org.bukkit.configuration.file.FileConfiguration;

public class ItemManager {
    private final FileConfiguration itemConfig;
    private final FileConfiguration userConfig;
    private final Map<String, RSVItem> items = new HashMap<String, RSVItem>();
    private final RSVModule module;

    public ItemManager(RSVModule module) {
        this.itemConfig = module.getItemConfig().getConfig();
        this.userConfig = module.getUserConfig().getConfig();
        this.module = module;
        this.initialize();
    }

    public ItemManager(FileConfiguration itemConfig) {
        this.itemConfig = itemConfig;
        this.userConfig = null;
        this.module = null;
        this.initialize();
    }

    public void initialize() {
        Set keys = this.itemConfig.getKeys(false);
        keys.remove("ConfigId");
        for (String key : keys) {
            RSVItem item;
            if (this.userConfig == null) {
                item = new RSVItem(null, this.itemConfig, key);
                this.items.putIfAbsent(key, item);
                continue;
            }
            if (this.userConfig.getBoolean("Items." + key + ".Enabled.EnableAllVersions")) {
                item = new RSVItem(this.module, this.itemConfig, key);
                this.items.putIfAbsent(key, item);
                continue;
            }
            if (this.userConfig.contains("Items." + key + ".Enabled.Versions." + Utils.getMinecraftVersion(true))) {
                if (!this.userConfig.getBoolean("Items." + key + ".Enabled.Versions." + Utils.getMinecraftVersion(true))) continue;
                item = new RSVItem(this.module, this.itemConfig, key);
                this.items.putIfAbsent(key, item);
                continue;
            }
            item = new RSVItem(this.module, this.itemConfig, key);
            this.items.putIfAbsent(key, item);
        }
    }

    public RSVModule getModule() {
        return this.module;
    }

    public Map<String, RSVItem> getItems() {
        return this.items;
    }

    public RSVItem getItem(String name) {
        return this.items.get(name);
    }
}

