/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.data;

import java.io.IOException;
import java.util.Set;
import javax.annotation.Nullable;
import me.val_mobile.data.RSVModule;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.Utils;
import me.val_mobile.utils.recipe.RSVAnvilRecipe;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public abstract class ModuleEvents
implements Listener {
    private final RSVPlugin plugin;
    private final RSVModule module;
    private final FileConfiguration config;

    public ModuleEvents(RSVModule module, RSVPlugin plugin) {
        this.module = module;
        this.plugin = plugin;
        this.config = module.getUserConfig().getConfig();
    }

    public void initialize() {
        PluginManager pm = this.plugin.getServer().getPluginManager();
        pm.registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockDrop(BlockBreakEvent event) {
        if (!event.isCancelled()) {
            Block block = event.getBlock();
            String mat = block.getType().toString();
            if (this.shouldEventBeRan(block.getWorld())) {
                ItemStack itemMainHand = event.getPlayer().getInventory().getItemInMainHand();
                ConfigurationSection blockDrops = this.config.getConfigurationSection("BlockDrops");
                if (blockDrops != null && blockDrops.getKeys(false).contains(mat)) {
                    Set drops = blockDrops.getConfigurationSection(mat).getKeys(false);
                    for (String drop : drops) {
                        boolean checkSilkTouch;
                        boolean conditionsMet = true;
                        boolean checkTool = blockDrops.getBoolean(mat + "." + drop + ".RequireRightTool");
                        boolean bl = checkSilkTouch = !blockDrops.getBoolean(mat + "." + drop + ".IgnoreSilkTouchEnchant");
                        if (checkTool || checkSilkTouch) {
                            conditionsMet = checkTool && checkSilkTouch ? Utils.isBestTool(block, itemMainHand) && Utils.hasSilkTouch(itemMainHand) : (checkTool ? Utils.isBestTool(block, itemMainHand) : Utils.hasSilkTouch(itemMainHand));
                        }
                        if (!conditionsMet) continue;
                        if (this.config.getBoolean("BlockDrops." + mat + "." + drop + ".ReplaceDefaultDrop")) {
                            event.setDropItems(false);
                        }
                        Utils.dropFortune(this.config.getConfigurationSection("BlockDrops." + mat + "." + drop), RSVItem.getItem(drop), itemMainHand, block.getLocation());
                    }
                }
            }
        }
    }

    @EventHandler
    public void onMobDrop(EntityDeathEvent event) {
        Set mobKeys;
        ConfigurationSection mobDrops;
        LivingEntity entity = event.getEntity();
        if (this.shouldEventBeRan((Entity)entity) && (mobDrops = this.config.getConfigurationSection("MobDrops")) != null && (mobKeys = mobDrops.getKeys(false)).contains(entity.getType().toString()) && entity.getType().toString() != null) {
            ConfigurationSection section = this.config.getConfigurationSection("MobDrops." + String.valueOf(entity.getType()));
            Set itemKeys = section.getKeys(false);
            ItemStack tool = entity.getKiller() == null ? null : entity.getKiller().getInventory().getItemInMainHand();
            for (String item : itemKeys) {
                if (!RSVItem.isRSVItem(item)) continue;
                Utils.dropLooting(section.getConfigurationSection(item), RSVItem.getItem(item), tool, entity.getLocation(), true);
            }
        }
    }

    @EventHandler
    public void onAnvil(PrepareAnvilEvent event) {
        AnvilInventory inv = event.getInventory();
        Set<RSVAnvilRecipe> anvilRecipes = this.module.getModuleRecipes().getAnvilRecipes();
        if (this.shouldEventBeRan((Entity)event.getView().getPlayer())) {
            for (RSVAnvilRecipe recipe : anvilRecipes) {
                if (!recipe.isValidRecipe(inv)) continue;
                recipe.useRecipe(event);
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onRecipeCraftCancel(PrepareItemCraftEvent event) {
        Recipe recipe;
        Player player = (Player)event.getView().getPlayer();
        if (!this.shouldEventBeRan((Entity)player) && (recipe = event.getRecipe()) instanceof Keyed) {
            Keyed keyed = (Keyed)recipe;
            if (this.module.getModuleRecipes().getRecipeKeys().contains(keyed.getKey())) {
                event.getInventory().setResult(null);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onRecipeDiscover(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        if (this.shouldEventBeRan((Entity)event.getPlayer())) {
            if (!this.shouldEventBeRan(event.getFrom())) {
                Set<NamespacedKey> keys = this.module.getModuleRecipes().getRecipeKeys();
                for (NamespacedKey key : keys) {
                    if (!this.config.getBoolean("Recipes." + key.getKey() + ".Unlock")) continue;
                    Utils.discoverRecipe(player, Bukkit.getRecipe((NamespacedKey)key));
                }
            }
        } else if (this.shouldEventBeRan(event.getFrom())) {
            player.undiscoverRecipes(this.module.getModuleRecipes().getRecipeKeys());
        }
    }

    @EventHandler
    public void onWorldInit(WorldInitEvent event) {
        String path;
        FileConfiguration pluginConfig;
        String name = event.getWorld().getName();
        if (!this.module.getAllowedWorlds().contains(name) && !(pluginConfig = this.plugin.getConfig()).contains(path = this.module.getName() + ".Worlds." + name)) {
            pluginConfig.createSection(path);
            pluginConfig.set(path, (Object)true);
            this.module.getAllowedWorlds().add(name);
            try {
                pluginConfig.save(this.plugin.getConfigFile());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @EventHandler
    public void onWorldLoad(WorldLoadEvent event) {
        String path;
        FileConfiguration pluginConfig;
        String name = event.getWorld().getName();
        if (!this.module.getAllowedWorlds().contains(name) && !(pluginConfig = this.plugin.getConfig()).contains(path = this.module.getName() + ".Worlds." + name)) {
            pluginConfig.createSection(path);
            pluginConfig.set(path, (Object)true);
            this.module.getAllowedWorlds().add(name);
            try {
                pluginConfig.save(this.plugin.getConfigFile());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @EventHandler
    public void onWorldUnload(WorldUnloadEvent event) {
        String path;
        FileConfiguration pluginConfig;
        String name = event.getWorld().getName();
        if (!this.module.getAllowedWorlds().contains(name) && !(pluginConfig = this.plugin.getConfig()).contains(path = this.module.getName() + ".Worlds." + name)) {
            pluginConfig.createSection(path);
            pluginConfig.set(path, (Object)true);
            this.module.getAllowedWorlds().add(name);
            try {
                pluginConfig.save(this.plugin.getConfigFile());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @EventHandler
    public void onWorldSave(WorldSaveEvent event) {
        String path;
        FileConfiguration pluginConfig;
        String name = event.getWorld().getName();
        if (!this.module.getAllowedWorlds().contains(name) && !(pluginConfig = this.plugin.getConfig()).contains(path = this.module.getName() + ".Worlds." + name)) {
            pluginConfig.createSection(path);
            pluginConfig.set(path, (Object)true);
            this.module.getAllowedWorlds().add(name);
            try {
                pluginConfig.save(this.plugin.getConfigFile());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean shouldEventBeRan(@Nullable Entity e) {
        return e != null && this.module.getAllowedWorlds().contains(e.getWorld().getName());
    }

    public boolean shouldEventBeRan(@Nullable World world) {
        return world != null && this.module.getAllowedWorlds().contains(world.getName());
    }

    public RSVModule getModule() {
        return this.module;
    }
}

