/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.data;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.val_mobile.data.RSVModule;
import me.val_mobile.data.baubles.DataModule;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class RSVPlayer {
    private final UUID uuid;
    private final me.val_mobile.data.toughasnails.DataModule tanDataModule;
    private final DataModule baubleDataModule;
    private static final Map<UUID, RSVPlayer> players = new HashMap<UUID, RSVPlayer>();

    public RSVPlayer(Player player) {
        this.uuid = player.getUniqueId();
        this.baubleDataModule = RSVModule.getModule("Baubles").isGloballyEnabled() ? new DataModule(player) : null;
        this.tanDataModule = RSVModule.getModule("ToughAsNails").isGloballyEnabled() ? new me.val_mobile.data.toughasnails.DataModule(player) : null;
        players.put(this.uuid, this);
    }

    @Nonnull
    public static Map<UUID, RSVPlayer> getPlayers() {
        return players;
    }

    @Nullable
    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.uuid);
    }

    public void retrieveData() {
        if (this.tanDataModule != null) {
            this.tanDataModule.retrieveData();
        }
        if (this.baubleDataModule != null) {
            this.baubleDataModule.retrieveData();
        }
    }

    public void saveData() {
        if (this.tanDataModule != null) {
            this.tanDataModule.saveData();
        }
        if (this.baubleDataModule != null) {
            this.baubleDataModule.saveData();
        }
    }

    @Nullable
    public me.val_mobile.data.toughasnails.DataModule getTanDataModule() {
        return this.tanDataModule;
    }

    @Nullable
    public DataModule getBaubleDataModule() {
        return this.baubleDataModule;
    }

    public static boolean isValidPlayer(@Nullable Player player) {
        return player != null && RSVPlayer.isValidPlayer(player.getUniqueId());
    }

    public static boolean isValidPlayer(@Nullable UUID id) {
        return id != null && players.containsKey(id) && players.get(id) != null;
    }
}

