/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.data.baubles;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import me.val_mobile.baubles.BaubleModule;
import me.val_mobile.data.RSVConfig;
import me.val_mobile.data.RSVDataModule;
import me.val_mobile.data.RSVModule;
import me.val_mobile.data.baubles.BaubleInventory;
import me.val_mobile.data.baubles.BaubleSlot;
import me.val_mobile.utils.RSVItem;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class DataModule
implements RSVDataModule {
    private final RSVConfig config;
    private final BaubleInventory baubleBag;
    private final UUID id;

    public DataModule(Player player) {
        this.baubleBag = new BaubleInventory(player);
        this.config = ((BaubleModule)RSVModule.getModule("Baubles")).getPlayerDataConfig();
        this.id = player.getUniqueId();
    }

    public BaubleInventory getBaubleBag() {
        return this.baubleBag;
    }

    public boolean hasBauble(String name) {
        return this.baubleBag.hasBauble(name);
    }

    public int getBaubleAmount(String name) {
        return this.baubleBag.getBaubleAmount(name);
    }

    @Override
    public void retrieveData() {
        FileConfiguration config = this.config.getConfig();
        ConfigurationSection section = config.getConfigurationSection(String.valueOf(this.id) + ".Items");
        Set keys = section == null ? new HashSet() : section.getKeys(false);
        Inventory inv = this.baubleBag.getInventory();
        int dataVersion = Bukkit.getUnsafe().getDataVersion();
        for (String key : keys) {
            if (config.getInt(String.valueOf(this.id) + ".Items." + key + ".v") != dataVersion) {
                config.set(String.valueOf(this.id) + ".Items." + key + ".v", (Object)dataVersion);
            }
            int k = Integer.parseInt(key);
            ItemStack item = ItemStack.deserialize((Map)config.getConfigurationSection(String.valueOf(this.id) + ".Items." + key).getValues(true));
            inv.setItem(k, item);
        }
        this.saveFile(config);
        this.baubleBag.fillDefaultItems();
    }

    @Override
    public void saveData() {
        FileConfiguration config = this.config.getConfig();
        Inventory inv = this.baubleBag.getInventory();
        BaubleSlot[] values = BaubleSlot.values();
        Pattern pattern = Pattern.compile("^(charm|body|ring|belt|amulet|head)_slot$");
        for (BaubleSlot slot : values) {
            for (int i : slot.getValues()) {
                ItemStack item = inv.getItem(i);
                if (RSVItem.isRSVItem(item) && !pattern.matcher(RSVItem.getNameFromItem(item)).find()) {
                    config.set(String.valueOf(this.id) + ".Items." + i, (Object)item.serialize());
                    continue;
                }
                config.set(String.valueOf(this.id) + ".Items." + i, null);
            }
        }
        this.saveFile(config);
    }

    public void saveFile(FileConfiguration config) {
        try {
            config.save(this.config.getFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

