/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.iceandfire;

import java.util.ArrayList;
import java.util.Collection;
import me.val_mobile.data.RSVModule;
import me.val_mobile.iceandfire.DragonBreed;
import me.val_mobile.iceandfire.DragonGender;
import me.val_mobile.iceandfire.DragonVariant;
import me.val_mobile.iceandfire.FireBreath;
import me.val_mobile.iceandfire.FireExplosionAttack;
import me.val_mobile.iceandfire.IceBreath;
import me.val_mobile.iceandfire.IceExplosionAttack;
import me.val_mobile.iceandfire.LightningBreath;
import me.val_mobile.iceandfire.LightningExplosionAttack;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.spartanandfire.BurnTask;
import me.val_mobile.spartanandfire.ElectrocuteTask;
import me.val_mobile.spartanandfire.FreezeTask;
import me.val_mobile.utils.LorePresets;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.RSVMob;
import me.val_mobile.utils.Utils;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;

public class DragonUtils {
    private static final FileConfiguration CONFIG = RSVModule.getModule("IceandFire").getUserConfig().getConfig();

    public static void convertToDragon(EnderDragon dragon, DragonBreed breed) {
        int stage = Utils.getRandomNum(1, 5);
        Utils.addNbtTag((Entity)dragon, "rsvmob", breed.toString().toLowerCase() + "_dragon", PersistentDataType.STRING);
        Utils.addNbtTag((Entity)dragon, "rsvdragonstage", Integer.valueOf(stage), PersistentDataType.INTEGER);
        Utils.addNbtTag((Entity)dragon, "rsvdragonage", Integer.valueOf(Utils.getRandomNum(stage * 100, stage * 100 + 99)), PersistentDataType.INTEGER);
        Utils.addNbtTag((Entity)dragon, "rsvdragonvariant", DragonVariant.getEnabledVariants(breed).get(Utils.getRandomNum(0, DragonVariant.getEnabledVariants(breed).size() - 1)).toString(), PersistentDataType.STRING);
        Utils.addNbtTag((Entity)dragon, "rsvdragonbreed", breed.toString(), PersistentDataType.STRING);
        Utils.addNbtTag((Entity)dragon, "rsvdragongender", (Utils.getRandomNum(0, 1) == 1 ? DragonGender.MALE : DragonGender.FEMALE).toString(), PersistentDataType.STRING);
    }

    public static void convertToFireDragon(EnderDragon dragon) {
        DragonUtils.convertToDragon(dragon, DragonBreed.FIRE);
    }

    public static void convertToIceDragon(EnderDragon dragon) {
        DragonUtils.convertToDragon(dragon, DragonBreed.ICE);
    }

    public static void convertToLightningDragon(EnderDragon dragon) {
        DragonUtils.convertToDragon(dragon, DragonBreed.LIGHTNING);
    }

    public static void performMeleeAttack(EnderDragon dragon, LivingEntity defender) {
        if (RSVMob.isMob((Entity)dragon)) {
            switch (RSVMob.getMob((Entity)dragon)) {
                case "fire_dragon": {
                    DragonUtils.performMeleeFireAbility(dragon, defender);
                    break;
                }
                case "ice_dragon": {
                    DragonUtils.performMeleeIceAbility(dragon, defender);
                    break;
                }
                case "lightning_dragon": {
                    DragonUtils.performMeleeLightningAbility(dragon, defender);
                    break;
                }
            }
        }
    }

    public static void performSpecialAbility(EnderDragon dragon, LivingEntity defender) {
        if (RSVMob.isMob((Entity)dragon)) {
            switch (RSVMob.getMob((Entity)dragon)) {
                case "fire_dragon": {
                    DragonUtils.performSpecialFireAbility(dragon, defender);
                    break;
                }
                case "ice_dragon": {
                    DragonUtils.performSpecialIceAbility(dragon, defender);
                    break;
                }
                case "lightning_dragon": {
                    DragonUtils.performSpecialLightningAbility(dragon, defender);
                    break;
                }
            }
        }
    }

    public static void performMeleeFireAbility(EnderDragon dragon, LivingEntity defender) {
        defender.damage(CONFIG.getDouble("Dragon.FireDragon.MeleeAttack.Stage" + DragonUtils.getStage(dragon) + ".Damage"), (Entity)dragon);
    }

    public static void performMeleeIceAbility(EnderDragon dragon, LivingEntity defender) {
        defender.damage(CONFIG.getDouble("Dragon.IceDragon.MeleeAttack.Stage" + DragonUtils.getStage(dragon) + ".Damage"), (Entity)dragon);
    }

    public static void performMeleeLightningAbility(EnderDragon dragon, LivingEntity defender) {
        defender.damage(CONFIG.getDouble("Dragon.LightningDragon.MeleeAttack.Stage" + DragonUtils.getStage(dragon) + ".Damage"), (Entity)dragon);
    }

    public static void performSpecialFireAbility(EnderDragon dragon, LivingEntity defender) {
        if (!BurnTask.hasTask(defender.getUniqueId())) {
            new BurnTask(RSVPlugin.getPlugin(), (Entity)defender, CONFIG.getInt("Dragon.FireDragon.InfernoAbility.Stage" + DragonUtils.getStage(dragon)), CONFIG.getInt("Dragon.FireDragon.InfernoAbility.TickPeriod")).start();
        }
    }

    public static void performSpecialIceAbility(EnderDragon dragon, LivingEntity defender) {
        if (!FreezeTask.hasTask(defender.getUniqueId())) {
            new FreezeTask(RSVPlugin.getPlugin(), DragonUtils.getStage(dragon), (Entity)defender).start();
        }
    }

    public static void performSpecialLightningAbility(EnderDragon dragon, LivingEntity defender) {
        Location loc = defender.getLocation();
        if (CONFIG.getBoolean("Dragon.LightningDragon.ElectrocuteAbility.SummonCosmeticLightning")) {
            loc.getWorld().strikeLightningEffect(loc);
        } else {
            loc.getWorld().strikeLightning(loc);
        }
        if (!ElectrocuteTask.hasTask(defender.getUniqueId())) {
            new ElectrocuteTask(RSVPlugin.getPlugin(), DragonUtils.getStage(dragon), (Damageable)defender).start();
        }
    }

    public static void triggerBreathAttack(EnderDragon dragon, Location target) {
        if (RSVMob.isMob((Entity)dragon)) {
            switch (RSVMob.getMob((Entity)dragon)) {
                case "fire_dragon": {
                    DragonUtils.triggerBreathFireAttack(dragon, target);
                    break;
                }
                case "ice_dragon": {
                    DragonUtils.triggerBreathIceAttack(dragon, target);
                    break;
                }
                case "lightning_dragon": {
                    DragonUtils.triggerBreathLightningAttack(dragon, target);
                    break;
                }
            }
        }
    }

    public static void triggerExplosionAttack(EnderDragon dragon, Location target) {
        if (RSVMob.isMob((Entity)dragon)) {
            switch (RSVMob.getMob((Entity)dragon)) {
                case "fire_dragon": {
                    DragonUtils.triggerExplosionFireAttack(dragon, target);
                    break;
                }
                case "ice_dragon": {
                    DragonUtils.triggerExplosionIceAttack(dragon, target);
                    break;
                }
                case "lightning_dragon": {
                    DragonUtils.triggerExplosionLightningAttack(dragon, target);
                    break;
                }
            }
        }
    }

    public static void triggerBreathFireAttack(EnderDragon dragon, Location target) {
        new FireBreath(dragon, target, RSVPlugin.getPlugin()).start();
    }

    public static void triggerBreathIceAttack(EnderDragon dragon, Location target) {
        new IceBreath(dragon, target, RSVPlugin.getPlugin()).start();
    }

    public static void triggerBreathLightningAttack(EnderDragon dragon, Location target) {
        new LightningBreath(dragon, target, RSVPlugin.getPlugin()).start();
    }

    public static void triggerExplosionFireAttack(EnderDragon dragon, Location target) {
        new FireExplosionAttack(dragon, target, RSVPlugin.getPlugin()).start();
    }

    public static void triggerExplosionIceAttack(EnderDragon dragon, Location target) {
        new IceExplosionAttack(dragon, target, RSVPlugin.getPlugin()).start();
    }

    public static void triggerExplosionLightningAttack(EnderDragon dragon, Location target) {
        new LightningExplosionAttack(dragon, target, RSVPlugin.getPlugin()).start();
    }

    public static Collection<ItemStack> generateLoot(EnderDragon dragon) {
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        int stage = DragonUtils.getStage(dragon);
        DragonBreed breed = DragonUtils.getBreed(dragon);
        DragonVariant variant = DragonUtils.getVariant(dragon);
        String lowercaseBreed = breed.toString().toLowerCase();
        RSVItem heart = RSVItem.getItem("dragon_heart_" + lowercaseBreed);
        RSVItem skull = RSVItem.getItem("dragon_skull_" + lowercaseBreed);
        RSVItem scales = RSVItem.getItem("dragonscale_" + variant.toString().toLowerCase());
        RSVItem blood = RSVItem.getItem("dragon_blood_" + lowercaseBreed);
        RSVItem flesh = RSVItem.getItem("dragon_flesh_" + lowercaseBreed);
        RSVItem bones = RSVItem.getItem("dragonbone");
        LorePresets.addDragonSkullLore(skull, stage, breed.toString());
        ConfigurationSection section = CONFIG.getConfigurationSection("Dragon.LootTable");
        ItemStack tool = dragon.getKiller() == null ? null : dragon.getKiller().getInventory().getItemInMainHand();
        loot.add(Utils.getMobLoot(section.getConfigurationSection("Dragonscales.Stage" + stage), scales, tool, true));
        loot.add(Utils.getMobLoot(section.getConfigurationSection("Heart.Stage" + stage), heart, tool, true));
        loot.add(Utils.getMobLoot(section.getConfigurationSection("Skull.Stage" + stage), skull, tool, true));
        loot.add(Utils.getMobLoot(section.getConfigurationSection("Dragonbones.Stage" + stage), bones, tool, true));
        loot.add(Utils.getMobLoot(section.getConfigurationSection("Blood.Stage" + stage), blood, tool, true));
        loot.add(Utils.getMobLoot(section.getConfigurationSection("Flesh.Stage" + stage), flesh, tool, true));
        return loot;
    }

    public static boolean isDragon(Entity entity) {
        if (RSVMob.isMob(entity)) {
            return switch (RSVMob.getMob(entity)) {
                case "fire_dragon", "ice_dragon", "lightning_dragon" -> true;
                default -> false;
            };
        }
        return false;
    }

    public static int getStage(EnderDragon dragon) {
        return (Integer)Utils.getNbtTag((Entity)dragon, "rsvdragonstage", PersistentDataType.INTEGER);
    }

    public static int getAge(EnderDragon dragon) {
        return (Integer)Utils.getNbtTag((Entity)dragon, "rsvdragonage", PersistentDataType.INTEGER);
    }

    public static DragonVariant getVariant(EnderDragon dragon) {
        return DragonVariant.valueOf(((String)Utils.getNbtTag((Entity)dragon, "rsvdragonvariant", PersistentDataType.STRING)).toUpperCase());
    }

    public static DragonBreed getBreed(EnderDragon dragon) {
        return DragonBreed.valueOf(((String)Utils.getNbtTag((Entity)dragon, "rsvdragonbreed", PersistentDataType.STRING)).toUpperCase());
    }

    public static DragonGender getGender(EnderDragon dragon) {
        return DragonGender.valueOf(((String)Utils.getNbtTag((Entity)dragon, "rsvdragongender", PersistentDataType.STRING)).toUpperCase());
    }
}

