/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.iceandfire;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.val_mobile.data.ModuleItems;
import me.val_mobile.data.ModuleRecipes;
import me.val_mobile.data.RSVConfig;
import me.val_mobile.data.RSVModule;
import me.val_mobile.iceandfire.IceFireEvents;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.spartanandfire.BurnTask;
import me.val_mobile.spartanandfire.ElectrocuteTask;
import me.val_mobile.spartanandfire.FreezeTask;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.Utils;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;

public class IceFireModule
extends RSVModule {
    private final RSVPlugin plugin;
    public static final String NAME = "IceandFire";
    private IceFireEvents events;

    public IceFireModule(RSVPlugin plugin) {
        super(NAME, plugin, Map.of(), Map.of());
        this.plugin = plugin;
    }

    @Override
    public void initialize() {
        this.setUserConfig(new RSVConfig(this.plugin, "iceandfire.yml"));
        this.setItemConfig(new RSVConfig(this.plugin, "resources/iceandfire/items.yml"));
        this.setRecipeConfig(new RSVConfig(this.plugin, "resources/iceandfire/recipes.yml"));
        this.setModuleItems(new ModuleItems(this));
        this.setModuleRecipes(new ModuleRecipes(this, this.plugin));
        FileConfiguration config = this.getUserConfig().getConfig();
        if (config.getBoolean("Initialize.Enabled")) {
            String message = Utils.translateMsg(config.getString("Initialize.Message"), null, Map.of("NAME", NAME));
            this.plugin.getLogger().info(message);
        }
        this.events = new IceFireEvents(this, this.plugin);
        this.getModuleItems().initialize();
        this.getModuleRecipes().initialize();
        this.events.initialize();
    }

    @Override
    public void shutdown() {
        FileConfiguration config = this.getUserConfig().getConfig();
        if (config.getBoolean("Shutdown.Enabled")) {
            String message = Utils.translateMsg(config.getString("Shutdown.Message"), null, Map.of("NAME", NAME));
            this.plugin.getLogger().info(message);
        }
    }

    public IceFireEvents getEvents() {
        return this.events;
    }

    public static double applyDragonItemBonusDamage(@Nullable Entity defender, @Nullable ItemStack item, double origDamage, @Nonnull RSVModule compare) {
        if (!RSVItem.isRSVItem(item) || !RSVItem.getModuleNameFromItem(item).equals(compare.getName())) {
            return origDamage;
        }
        return IceFireModule.applyDragonItemBonusDamage(defender, RSVItem.getNameFromItem(item), origDamage, compare);
    }

    public static double applyDragonItemBonusDamage(@Nullable Entity defender, @Nullable String name, double origDamage, @Nonnull RSVModule compare) {
        String prefix;
        if (compare.getUserConfig() == null || defender == null || name == null || name.isEmpty() || name.startsWith("_") || name.endsWith("_")) {
            return origDamage;
        }
        if (!RSVItem.isRSVItem(name) || !compare.getName().equals(RSVItem.getModuleNameFromItem(RSVItem.getItem(name)))) {
            return origDamage;
        }
        FileConfiguration config = compare.getUserConfig().getConfig();
        String type = name.substring(0, name.lastIndexOf("_"));
        String weaponType = name.substring(name.lastIndexOf("_") + 1);
        if (weaponType.equals("longbow") || weaponType.equals("crossbow")) {
            origDamage *= config.getDouble("Items." + name + ".AttackDamageMultiplier");
        }
        switch (type) {
            case "dragonbone_flamed": {
                String string = "fire";
                break;
            }
            case "dragonbone_iced": {
                String string = "ice";
                break;
            }
            case "dragonbone_lightning": {
                String string = "lightning";
                break;
            }
            default: {
                String string = prefix = null;
            }
        }
        if (prefix == null) {
            return origDamage;
        }
        if (Utils.hasNbtTag(defender, "rsvmob") && !((String)Utils.getNbtTag(defender, "rsvmob", PersistentDataType.STRING)).equals(prefix + "_dragon")) {
            origDamage += config.getDouble("Items." + name + ".DragonBonusDamage");
        }
        return origDamage;
    }

    public static void applyDragonItemEffect(@Nullable Entity defender, @Nullable ItemStack item, @Nonnull RSVModule compare) {
        if (!RSVItem.isRSVItem(item) || !RSVItem.getModuleNameFromItem(item).equals(compare.getName())) {
            return;
        }
        IceFireModule.applyDragonItemEffect(defender, RSVItem.getNameFromItem(item), compare);
    }

    public static void applyDragonItemEffect(@Nullable Entity defender, @Nullable String name, @Nonnull RSVModule compare) {
        String type;
        if (compare.getUserConfig() == null || defender == null || name == null || name.isEmpty() || name.startsWith("_") || name.endsWith("_")) {
            return;
        }
        if (!RSVItem.isRSVItem(name) || !compare.getName().equals(RSVItem.getModuleNameFromItem(RSVItem.getItem(name)))) {
            return;
        }
        FileConfiguration config = compare.getUserConfig().getConfig();
        RSVPlugin plugin = RSVPlugin.getPlugin();
        switch (type = name.substring(0, name.lastIndexOf("_"))) {
            case "dragonbone_flamed": 
            case "dragonsteel_fire": {
                if (BurnTask.hasTask(defender.getUniqueId())) break;
                int fireTicks = config.getInt("Items." + name + ".InfernoAbility.FireTicks");
                int tickPeriod = config.getInt("Items." + name + ".InfernoAbility.TickPeriod");
                new BurnTask(plugin, defender, fireTicks, tickPeriod).start();
                break;
            }
            case "dragonbone_iced": 
            case "dragonsteel_ice": {
                if (FreezeTask.hasTask(defender.getUniqueId()) || config.getString("Items." + name + ".FreezeAbility.EncaseIce.Block") == null) break;
                new FreezeTask(plugin, compare, name, defender).start();
                break;
            }
            case "dragonbone_lightning": 
            case "dragonsteel_lightning": {
                if (config.getBoolean("Items." + name + ".ElectrocuteAbility.SummonLightning.Enabled")) {
                    Location loc = defender.getLocation();
                    if (config.getBoolean("Items." + name + ".ElectrocuteAbility.SummonLightning.Cosmetic")) {
                        loc.getWorld().strikeLightningEffect(loc);
                    } else {
                        loc.getWorld().strikeLightning(loc);
                    }
                }
                if (!(defender instanceof Damageable)) break;
                Damageable damageable = (Damageable)defender;
                if (ElectrocuteTask.hasTask(defender.getUniqueId())) break;
                new ElectrocuteTask(plugin, compare, name, damageable).start();
                break;
            }
        }
    }
}

