/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.iceandfire;

import javax.annotation.Nonnull;
import me.val_mobile.iceandfire.Breath;
import me.val_mobile.iceandfire.Dragon;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.Utils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.EnderDragon;

public class LightningBreath
extends Breath {
    public LightningBreath(EnderDragon dragon, Location target, RSVPlugin plugin) {
        super(dragon, target, plugin);
    }

    public LightningBreath(Dragon dragon, Location target, RSVPlugin plugin) {
        super(dragon, target, plugin);
    }

    @Override
    public void grief(Location center, int radius) {
        World world = center.getWorld();
        for (int x = -radius; x < radius; ++x) {
            for (int y = -radius; y < radius; ++y) {
                for (int z = -radius; z < radius; ++z) {
                    if (Math.hypot(Math.hypot(x, y), z) > (double)radius) continue;
                    Location loc = center.clone().add((double)x, (double)y, (double)z);
                    Location secondLoc = center.clone().add((double)x, (double)(y - 1), (double)z);
                    Block block = loc.getBlock();
                    Material blockMaterial = block.getType();
                    Block secondBlock = secondLoc.getBlock();
                    if (block.isEmpty() || !blockMaterial.isOccluding()) {
                        if (this.immuneBlocks.contains(blockMaterial.toString()) || secondBlock.isEmpty()) continue;
                        world.getBlockAt(loc).setType(this.getElectrocutedMaterial(blockMaterial, Material.valueOf((String)this.config.getString("Dragon.LightningDragon.BreathAttack.LayerBlock"))));
                        continue;
                    }
                    if (this.immuneBlocks.contains(blockMaterial.toString()) || secondBlock.isEmpty()) continue;
                    world.getBlockAt(loc).setType(this.getElectrocutedMaterial(blockMaterial, Material.valueOf((String)this.config.getString("Dragon.LightningDragon.BreathAttack.ElectrifiedBlock"))));
                }
            }
        }
    }

    @Nonnull
    public Material getElectrocutedMaterial(@Nonnull Material material, @Nonnull Material defaultMaterial) {
        if (this.specialBlocks.containsKey(material.toString())) {
            String[] mats = (String[])this.specialBlocks.get(material.toString());
            return Material.valueOf((String)mats[Utils.getRandomNum(0, mats.length - 1)]);
        }
        return defaultMaterial;
    }
}

