/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.iceandfire;

import java.util.ArrayList;
import java.util.Collection;
import me.val_mobile.data.RSVModule;
import me.val_mobile.iceandfire.SeaSerpentVariant;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.RSVMob;
import me.val_mobile.utils.Utils;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ElderGuardian;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;

public class SeaSerpentUtils {
    private static final FileConfiguration CONFIG = RSVModule.getModule("IceandFire").getUserConfig().getConfig();

    public static void convertToSeaSerpent(ElderGuardian elderGuardian) {
        Utils.addNbtTag((Entity)elderGuardian, "rsvmob", "sea_serpent", PersistentDataType.STRING);
        Utils.addNbtTag((Entity)elderGuardian, "rsvseaserpentvariant", SeaSerpentVariant.getEnabledVariants().get(Utils.getRandomNum(0, SeaSerpentVariant.getEnabledVariants().size() - 1)).toString(), PersistentDataType.STRING);
    }

    public static Collection<ItemStack> generateLoot(ElderGuardian seaSerpent) {
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        RSVItem scales = RSVItem.getItem("sea_serpent_scale_" + SeaSerpentUtils.getVariant(seaSerpent).toString().toLowerCase());
        ItemStack item = seaSerpent.getKiller() == null ? null : seaSerpent.getKiller().getInventory().getItemInMainHand();
        Utils.getMobLoot(CONFIG.getConfigurationSection("SeaSerpent.LootTable.Scales"), scales, item, true);
        loot.add(scales);
        return loot;
    }

    public static boolean isSeaSerpent(Entity entity) {
        if (RSVMob.isMob(entity)) {
            return RSVMob.getMob(entity).equals("sea_serpent");
        }
        return false;
    }

    public static SeaSerpentVariant getVariant(ElderGuardian seaSerpent) {
        return SeaSerpentVariant.valueOf(((String)Utils.getNbtTag((Entity)seaSerpent, "rsvseaserpentvariant", PersistentDataType.STRING)).toUpperCase());
    }
}

