/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.misc;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.val_mobile.misc.EntityItemAcquireEvent;
import me.val_mobile.misc.PlayerItemAcquireEvent;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.Utils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDispenseArmorEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.CauldronLevelChangeEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketEntityEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.plugin.PluginManager;

public class ItemAcquireEvents
implements Listener {
    private final RSVPlugin plugin;
    private final PluginManager pm;

    public ItemAcquireEvents(RSVPlugin plugin) {
        this.plugin = plugin;
        this.pm = Bukkit.getServer().getPluginManager();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!player.isOnline()) {
            return;
        }
        PlayerInventory inv = player.getInventory();
        ItemStack mainHand = inv.getItemInMainHand();
        ItemStack offHand = inv.getItemInOffHand();
        ItemStack helmet = inv.getHelmet();
        ItemStack chest = inv.getChestplate();
        ItemStack legs = inv.getLeggings();
        ItemStack boots = inv.getBoots();
        if (Utils.isItemReal(mainHand)) {
            this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, mainHand, EntityItemAcquireEvent.ItemAcquireCause.PLAYER_JOIN, EquipmentSlot.HAND, null));
        }
        if (Utils.isItemReal(offHand)) {
            this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, offHand, EntityItemAcquireEvent.ItemAcquireCause.PLAYER_JOIN, EquipmentSlot.OFF_HAND, null));
        }
        if (Utils.isItemReal(helmet)) {
            this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, helmet, EntityItemAcquireEvent.ItemAcquireCause.PLAYER_JOIN, EquipmentSlot.HEAD, null));
        }
        if (Utils.isItemReal(chest)) {
            this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, chest, EntityItemAcquireEvent.ItemAcquireCause.PLAYER_JOIN, EquipmentSlot.CHEST, null));
        }
        if (Utils.isItemReal(legs)) {
            this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, legs, EntityItemAcquireEvent.ItemAcquireCause.PLAYER_JOIN, EquipmentSlot.LEGS, null));
        }
        if (Utils.isItemReal(boots)) {
            this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, boots, EntityItemAcquireEvent.ItemAcquireCause.PLAYER_JOIN, EquipmentSlot.FEET, null));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (!player.isOnline()) {
            return;
        }
        PlayerInventory inv = player.getInventory();
        ItemStack mainHand = inv.getItemInMainHand();
        ItemStack offHand = inv.getItemInOffHand();
        ItemStack helmet = inv.getHelmet();
        ItemStack chest = inv.getChestplate();
        ItemStack legs = inv.getLeggings();
        ItemStack boots = inv.getBoots();
        if (Utils.isItemReal(mainHand)) {
            this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, mainHand, EntityItemAcquireEvent.ItemAcquireCause.PLAYER_RESPAWN, EquipmentSlot.HAND, null));
        }
        if (Utils.isItemReal(offHand)) {
            this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, offHand, EntityItemAcquireEvent.ItemAcquireCause.PLAYER_RESPAWN, EquipmentSlot.OFF_HAND, null));
        }
        if (Utils.isItemReal(helmet)) {
            this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, helmet, EntityItemAcquireEvent.ItemAcquireCause.PLAYER_RESPAWN, EquipmentSlot.HEAD, null));
        }
        if (Utils.isItemReal(chest)) {
            this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, chest, EntityItemAcquireEvent.ItemAcquireCause.PLAYER_RESPAWN, EquipmentSlot.CHEST, null));
        }
        if (Utils.isItemReal(legs)) {
            this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, legs, EntityItemAcquireEvent.ItemAcquireCause.PLAYER_RESPAWN, EquipmentSlot.LEGS, null));
        }
        if (Utils.isItemReal(boots)) {
            this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, boots, EntityItemAcquireEvent.ItemAcquireCause.PLAYER_RESPAWN, EquipmentSlot.FEET, null));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntitySpawn(EntitySpawnEvent event) {
        LivingEntity entity;
        Entity entity2 = event.getEntity();
        if (!(entity2 instanceof LivingEntity) || (entity = (LivingEntity)entity2).getEquipment() == null) {
            return;
        }
        EntityEquipment inv = entity.getEquipment();
        ItemStack mainHand = inv.getItemInMainHand();
        ItemStack offHand = inv.getItemInOffHand();
        ItemStack helmet = inv.getHelmet();
        ItemStack chest = inv.getChestplate();
        ItemStack legs = inv.getLeggings();
        ItemStack boots = inv.getBoots();
        if (Utils.isItemReal(mainHand)) {
            this.pm.callEvent((Event)new EntityItemAcquireEvent(entity, mainHand, EntityItemAcquireEvent.ItemAcquireCause.ENTITY_SPAWN, EquipmentSlot.HAND, null));
        }
        if (Utils.isItemReal(offHand)) {
            this.pm.callEvent((Event)new EntityItemAcquireEvent(entity, offHand, EntityItemAcquireEvent.ItemAcquireCause.ENTITY_SPAWN, EquipmentSlot.OFF_HAND, null));
        }
        if (Utils.isItemReal(helmet)) {
            this.pm.callEvent((Event)new EntityItemAcquireEvent(entity, helmet, EntityItemAcquireEvent.ItemAcquireCause.ENTITY_SPAWN, EquipmentSlot.HEAD, null));
        }
        if (Utils.isItemReal(chest)) {
            this.pm.callEvent((Event)new EntityItemAcquireEvent(entity, chest, EntityItemAcquireEvent.ItemAcquireCause.ENTITY_SPAWN, EquipmentSlot.CHEST, null));
        }
        if (Utils.isItemReal(legs)) {
            this.pm.callEvent((Event)new EntityItemAcquireEvent(entity, legs, EntityItemAcquireEvent.ItemAcquireCause.ENTITY_SPAWN, EquipmentSlot.LEGS, null));
        }
        if (Utils.isItemReal(boots)) {
            this.pm.callEvent((Event)new EntityItemAcquireEvent(entity, boots, EntityItemAcquireEvent.ItemAcquireCause.ENTITY_SPAWN, EquipmentSlot.FEET, null));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onItemHeld(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItem(event.getNewSlot());
        if (Utils.isItemReal(item)) {
            this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, item, EntityItemAcquireEvent.ItemAcquireCause.ITEM_HELD, EquipmentSlot.HAND, null));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onItemSwap(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        ItemStack mainHand = event.getMainHandItem();
        ItemStack offHand = event.getOffHandItem();
        if (Utils.isItemReal(mainHand)) {
            this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, mainHand, EntityItemAcquireEvent.ItemAcquireCause.SWAP_HANDS, EquipmentSlot.HAND, null));
        }
        if (Utils.isItemReal(offHand)) {
            this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, offHand, EntityItemAcquireEvent.ItemAcquireCause.SWAP_HANDS, EquipmentSlot.OFF_HAND, null));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onItemPickup(EntityPickupItemEvent event) {
        LivingEntity entity = event.getEntity();
        ItemStack item = event.getItem().getItemStack();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            PlayerInventory inv = player.getInventory();
            int slot = inv.getHeldItemSlot();
            boolean acquireMainHand = false;
            for (int i = 0; i <= 9; ++i) {
                if (Utils.isItemReal(inv.getItem(i))) continue;
                if (slot != i) break;
                acquireMainHand = true;
                break;
            }
            if (acquireMainHand) {
                this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, item, EntityItemAcquireEvent.ItemAcquireCause.ITEM_PICKUP, EquipmentSlot.HAND, null));
            }
        } else {
            this.pm.callEvent((Event)new EntityItemAcquireEvent(entity, item, EntityItemAcquireEvent.ItemAcquireCause.ITEM_PICKUP, this.getLocFromMaterial(item.getType()), null));
        }
    }

    @Nonnull
    private EquipmentSlot getLocFromMaterial(@Nonnull Material mat) {
        if (mat == Material.SHIELD) {
            return EquipmentSlot.OFF_HAND;
        }
        if (Utils.isHelmet(mat)) {
            return EquipmentSlot.HEAD;
        }
        if (Utils.isChestplate(mat)) {
            return EquipmentSlot.CHEST;
        }
        if (Utils.isLeggings(mat)) {
            return EquipmentSlot.LEGS;
        }
        if (Utils.isBoots(mat)) {
            return EquipmentSlot.FEET;
        }
        return EquipmentSlot.HAND;
    }

    @Nullable
    private EquipmentSlot getLocFromRawSlot(@Nonnegative int rawSlot, @Nullable Inventory topInv) {
        if (topInv != null && !(topInv instanceof CraftingInventory)) {
            return null;
        }
        return switch (rawSlot) {
            case 45 -> EquipmentSlot.OFF_HAND;
            case 5 -> EquipmentSlot.HEAD;
            case 6 -> EquipmentSlot.CHEST;
            case 7 -> EquipmentSlot.LEGS;
            case 8 -> EquipmentSlot.FEET;
            default -> null;
        };
    }

    private boolean compareLocs(@Nullable ItemStack item, @Nullable EquipmentSlot slot) {
        if (!Utils.isItemReal(item)) {
            return false;
        }
        return this.getLocFromMaterial(item.getType()) == slot;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onClick(InventoryClickEvent event) {
        Inventory top = event.getView().getTopInventory();
        Inventory bottom = event.getView().getBottomInventory();
        if (!(bottom instanceof PlayerInventory)) {
            return;
        }
        PlayerInventory inv = (PlayerInventory)bottom;
        Player player = (Player)event.getWhoClicked();
        int rawSlot = event.getRawSlot();
        switch (event.getAction()) {
            case PLACE_ALL: 
            case PLACE_ONE: 
            case PLACE_SOME: 
            case SWAP_WITH_CURSOR: {
                ItemStack cursor = event.getCursor();
                if (!Utils.isItemReal(cursor)) break;
                if (inv.getHeldItemSlot() == event.getSlot()) {
                    this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, cursor, EntityItemAcquireEvent.ItemAcquireCause.INVENTORY_CLICK, EquipmentSlot.HAND, null));
                    break;
                }
                EquipmentSlot slot = this.getLocFromRawSlot(rawSlot, top);
                if (slot == null) break;
                this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, cursor, EntityItemAcquireEvent.ItemAcquireCause.INVENTORY_CLICK, slot, null));
                break;
            }
            case HOTBAR_SWAP: 
            case HOTBAR_MOVE_AND_READD: {
                EquipmentSlot slot;
                ItemStack current = event.getCurrentItem();
                if (!Utils.isItemReal(current) && rawSlot >= 1 && rawSlot <= 4) {
                    return;
                }
                if (event.getHotbarButton() == -1 && top instanceof CraftingInventory) {
                    ItemStack offHand = inv.getItemInOffHand();
                    EquipmentSlot offHandSlot = this.getLocFromMaterial(offHand.getType());
                    if (Utils.isItemReal(current) && rawSlot != 45) {
                        if (rawSlot >= 5 && rawSlot <= 8) {
                            if (this.compareLocs(offHand, this.getLocFromRawSlot(rawSlot, top))) {
                                this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, current, EntityItemAcquireEvent.ItemAcquireCause.INVENTORY_CLICK, EquipmentSlot.OFF_HAND, null));
                            }
                        } else {
                            this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, current, EntityItemAcquireEvent.ItemAcquireCause.INVENTORY_CLICK, EquipmentSlot.OFF_HAND, null));
                        }
                    }
                    if (Utils.isItemReal(offHand)) {
                        if (rawSlot >= 5 && rawSlot <= 8 && Utils.isArmor(offHand.getType()) && this.compareLocs(offHand, this.getLocFromRawSlot(rawSlot, top))) {
                            this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, offHand, EntityItemAcquireEvent.ItemAcquireCause.INVENTORY_CLICK, offHandSlot, null));
                        }
                        if (event.getSlot() == inv.getHeldItemSlot()) {
                            this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, offHand, EntityItemAcquireEvent.ItemAcquireCause.INVENTORY_CLICK, EquipmentSlot.HAND, null));
                        }
                    }
                    return;
                }
                ItemStack hotbarItem = inv.getItem(event.getHotbarButton());
                if (Utils.isItemReal(current) && inv.getHeldItemSlot() == event.getHotbarButton()) {
                    this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, current, EntityItemAcquireEvent.ItemAcquireCause.INVENTORY_CLICK, EquipmentSlot.HAND, null));
                }
                if (Utils.isItemReal(hotbarItem) && event.getSlot() < 9 && event.getSlot() != event.getHotbarButton()) {
                    this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, hotbarItem, EntityItemAcquireEvent.ItemAcquireCause.INVENTORY_CLICK, EquipmentSlot.HAND, null));
                }
                if (!Utils.isItemReal(hotbarItem) || (slot = this.getLocFromRawSlot(event.getRawSlot(), top)) == null) break;
                this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, hotbarItem, EntityItemAcquireEvent.ItemAcquireCause.INVENTORY_CLICK, slot, null));
                break;
            }
            case MOVE_TO_OTHER_INVENTORY: {
                ItemStack current = event.getCurrentItem();
                if (!Utils.isItemReal(current)) break;
                if (top instanceof CraftingInventory) {
                    boolean nonHotbarFilled;
                    EquipmentSlot slot = this.getLocFromMaterial(current.getType());
                    if (player.getEquipment() == null) {
                        slot = null;
                    } else {
                        switch (slot) {
                            case HEAD: {
                                if (!Utils.isItemReal(player.getEquipment().getHelmet())) break;
                                slot = null;
                                break;
                            }
                            case CHEST: {
                                if (!Utils.isItemReal(player.getEquipment().getChestplate())) break;
                                slot = null;
                                break;
                            }
                            case LEGS: {
                                if (!Utils.isItemReal(player.getEquipment().getLeggings())) break;
                                slot = null;
                                break;
                            }
                            case FEET: {
                                if (!Utils.isItemReal(player.getEquipment().getBoots())) break;
                                slot = null;
                                break;
                            }
                            case OFF_HAND: {
                                if (!Utils.isItemReal(player.getEquipment().getItemInOffHand())) break;
                                slot = null;
                                break;
                            }
                            default: {
                                slot = null;
                            }
                        }
                    }
                    if (slot != null) {
                        this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, current, EntityItemAcquireEvent.ItemAcquireCause.INVENTORY_CLICK, slot, null));
                        break;
                    }
                    if (inv.getHeldItemSlot() != this.getFirstEmptyHotbarSlot(inv) || rawSlot >= 36 && rawSlot <= 44 || (!(nonHotbarFilled = this.isNonHotbarFilled(event.getView())) || rawSlot > 8 && rawSlot != 45) && (nonHotbarFilled || rawSlot <= 8 || rawSlot == 45)) break;
                    this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, current, EntityItemAcquireEvent.ItemAcquireCause.INVENTORY_CLICK, EquipmentSlot.HAND, null));
                    break;
                }
                if (event.getClickedInventory() instanceof PlayerInventory || inv.getHeldItemSlot() != this.getLastEmptyHotbarSlot(inv)) break;
                this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, current, EntityItemAcquireEvent.ItemAcquireCause.INVENTORY_CLICK, EquipmentSlot.HAND, null));
                break;
            }
        }
    }

    public boolean isNonHotbarFilled(@Nonnull InventoryView view) {
        for (int i = 9; i <= 35; ++i) {
            if (Utils.isItemReal(view.getItem(i))) continue;
            return false;
        }
        return true;
    }

    public int getFirstEmptyHotbarSlot(@Nonnull PlayerInventory inv) {
        for (int i = 0; i <= 8; ++i) {
            if (Utils.isItemReal(inv.getItem(i))) continue;
            return i;
        }
        return -1;
    }

    public int getLastEmptyHotbarSlot(@Nonnull PlayerInventory inv) {
        for (int i = 8; i >= 0; --i) {
            if (Utils.isItemReal(inv.getItem(i))) continue;
            return i;
        }
        return -1;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDrag(InventoryDragEvent event) {
        Inventory inventory = event.getView().getBottomInventory();
        if (!(inventory instanceof PlayerInventory)) {
            return;
        }
        PlayerInventory bottom = (PlayerInventory)inventory;
        Player player = (Player)event.getWhoClicked();
        Map<Integer, ItemStack> slotMap = event.getNewItems().entrySet().stream().collect(Collectors.toMap(entry -> event.getView().convertSlot(((Integer)entry.getKey()).intValue()), Map.Entry::getValue));
        ItemStack changedHeldItem = slotMap.get(bottom.getHeldItemSlot());
        if (Utils.isItemReal(changedHeldItem)) {
            this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, changedHeldItem, EntityItemAcquireEvent.ItemAcquireCause.DRAG_CLICK, EquipmentSlot.HAND, null));
        }
        for (Map.Entry entry2 : event.getNewItems().entrySet()) {
            EquipmentSlot slot = this.getLocFromRawSlot((Integer)entry2.getKey(), event.getView().getTopInventory());
            if (slot == null) continue;
            this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, (ItemStack)entry2.getValue(), EntityItemAcquireEvent.ItemAcquireCause.DRAG_CLICK, slot, null));
        }
    }

    private boolean isFilledBucket(@Nonnull Material mat) {
        return mat.toString().contains("BUCKET") && !mat.toString().equals("BUCKET");
    }

    private boolean isPotionMilkBucket(@Nonnull Material mat) {
        return mat == Material.MILK_BUCKET || mat == Material.POTION;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onConsume(PlayerItemConsumeEvent event) {
        ItemStack result;
        Player player = event.getPlayer();
        if (!this.isPotionMilkBucket(event.getItem().getType()) || player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        EquipmentSlot slot = Utils.isItemReal(mainHand) && this.isPotionMilkBucket(mainHand.getType()) ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND;
        ItemStack prev = event.getItem();
        switch (prev.getType()) {
            case MILK_BUCKET: {
                ItemStack itemStack = new ItemStack(Material.BUCKET);
                break;
            }
            case POTION: 
            case HONEY_BOTTLE: {
                ItemStack itemStack = new ItemStack(Material.GLASS_BOTTLE);
                break;
            }
            default: {
                ItemStack itemStack = result = null;
            }
        }
        if (Utils.isItemReal(result)) {
            this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, result, EntityItemAcquireEvent.ItemAcquireCause.FOOD_CONSUME, slot, prev));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBucketEmpty(PlayerBucketEmptyEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        ItemStack offHand = player.getInventory().getItemInOffHand();
        EquipmentSlot slot = Utils.isItemReal(mainHand) && this.isFilledBucket(mainHand.getType()) ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND;
        ItemStack prev = Utils.isItemReal(mainHand) && this.isFilledBucket(mainHand.getType()) ? mainHand : offHand;
        ItemStack result = event.getItemStack();
        if (Utils.isItemReal(result)) {
            this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, result, EntityItemAcquireEvent.ItemAcquireCause.BUCKET_EMPTY, slot, prev));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBucketFill(PlayerBucketFillEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        ItemStack offHand = player.getInventory().getItemInOffHand();
        EquipmentSlot slot = Utils.isItemReal(mainHand) && mainHand.getType() == Material.BUCKET ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND;
        ItemStack prev = Utils.isItemReal(mainHand) && mainHand.getType() == Material.BUCKET ? mainHand : offHand;
        ItemStack result = event.getItemStack();
        if (Utils.isItemReal(result)) {
            this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, result, EntityItemAcquireEvent.ItemAcquireCause.BUCKET_FILL_LIQUID, slot, prev));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBucketEntityFill(PlayerBucketEntityEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        ItemStack offHand = player.getInventory().getItemInOffHand();
        EquipmentSlot slot = Utils.isItemReal(mainHand) && mainHand.getType() == Material.WATER_BUCKET ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND;
        ItemStack prev = Utils.isItemReal(mainHand) && mainHand.getType() == Material.WATER_BUCKET ? mainHand : offHand;
        ItemStack result = event.getEntityBucket();
        this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, result, EntityItemAcquireEvent.ItemAcquireCause.BUCKET_FILL_MOB, slot, prev));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onArmorEquip(PlayerInteractEvent event) {
        ItemStack item = event.getItem();
        if (Utils.isItemReal(item) && Utils.isArmor(item.getType()) && (event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) && event.getPlayer().getOpenInventory().getTopInventory() instanceof CraftingInventory) {
            this.pm.callEvent((Event)new PlayerItemAcquireEvent(event.getPlayer(), item, EntityItemAcquireEvent.ItemAcquireCause.ARMOR_RIGHT_CLICK, this.getLocFromMaterial(item.getType()), null));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDispenseArmor(BlockDispenseArmorEvent event) {
        EntityItemAcquireEvent thrown;
        ItemStack item = event.getItem();
        if (!Utils.isArmor(event.getItem().getType())) {
            return;
        }
        LivingEntity livingEntity = event.getTargetEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            thrown = new PlayerItemAcquireEvent(player, item, EntityItemAcquireEvent.ItemAcquireCause.ARMOR_DISPENSE, this.getLocFromMaterial(item.getType()), null);
        } else {
            thrown = new EntityItemAcquireEvent(event.getTargetEntity(), item, EntityItemAcquireEvent.ItemAcquireCause.ARMOR_DISPENSE, this.getLocFromMaterial(item.getType()), null);
        }
        this.pm.callEvent((Event)thrown);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onArmorStandInteract(PlayerArmorStandManipulateEvent event) {
        ItemStack playerItem = event.getPlayerItem();
        ItemStack asItem = event.getArmorStandItem();
        if (Utils.isItemReal(asItem)) {
            this.pm.callEvent((Event)new PlayerItemAcquireEvent(event.getPlayer(), asItem, EntityItemAcquireEvent.ItemAcquireCause.ARMOR_STAND, event.getSlot(), null));
        }
        if (Utils.isItemReal(playerItem)) {
            this.pm.callEvent((Event)new EntityItemAcquireEvent((LivingEntity)event.getRightClicked(), playerItem, EntityItemAcquireEvent.ItemAcquireCause.ARMOR_STAND, event.getSlot(), null));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        String message = event.getMessage();
        String[] args = message.substring(1).split(" ");
        if (args.length < 3) {
            return;
        }
        boolean isVanillaGive = args[0].equalsIgnoreCase("give");
        if (!isVanillaGive && !args[0].equalsIgnoreCase("rsv")) {
            return;
        }
        String givePerm = "minecraft.command.give";
        String rsvPerm = "realisticsurvival.command.give";
        if (!(player.isOp() || isVanillaGive && player.hasPermission(givePerm) || !isVanillaGive && player.hasPermission(rsvPerm))) {
            return;
        }
        if (!(isVanillaGive || args.length != 3 && args[1].equalsIgnoreCase("give"))) {
            return;
        }
        String string = isVanillaGive ? args[1] : args[2];
        Set affected = Bukkit.selectEntities((CommandSender)player, (String)string).stream().filter(Player.class::isInstance).map(Player.class::cast).collect(Collectors.toSet());
        if (affected.isEmpty()) {
            return;
        }
        Matcher matcher = java.util.regex.Pattern.compile(isVanillaGive ? "(?:minecraft:)?([a-z_]+)" : "([a-zA-Z_]*)").matcher(isVanillaGive ? args[2] : args[3]);
        if (!matcher.find()) {
            return;
        }
        String itemName = matcher.group(1);
        if (!Utils.isInEnum(itemName.toUpperCase(), Material.class) && !RSVItem.isRSVItem(itemName.toLowerCase())) {
            return;
        }
        int amount = 1;
        if (isVanillaGive && args.length > 3 && StringUtils.isNumeric((String)args[3]) || !isVanillaGive && args.length > 4 && StringUtils.isNumeric((String)args[4])) {
            amount = isVanillaGive ? Integer.parseInt(args[3]) : Integer.parseInt(args[4]);
        }
        ItemStack totalAdded = isVanillaGive ? new ItemStack(Material.valueOf((String)itemName.toUpperCase())) : RSVItem.getItem(itemName.toLowerCase());
        for (Player p : affected) {
            if (Utils.isItemReal(p.getInventory().getItemInMainHand())) continue;
            Inventory simulate = Bukkit.createInventory(null, (InventoryType)InventoryType.PLAYER);
            simulate.setContents(p.getInventory().getContents());
            Utils.addItemToInventory(simulate, totalAdded, amount);
            ItemStack added = simulate.getItem(p.getInventory().getHeldItemSlot());
            if (!Utils.isItemReal(added)) continue;
            this.pm.callEvent((Event)new PlayerItemAcquireEvent(p, added, EntityItemAcquireEvent.ItemAcquireCause.GIVE_COMMAND, EquipmentSlot.HAND, null));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onServerCommand(ServerCommandEvent event) {
        CommandSender player = event.getSender();
        String message = event.getCommand();
        String[] args = message.substring(1).split(" ");
        if (args.length < 3) {
            return;
        }
        boolean isVanillaGive = args[0].equalsIgnoreCase("give");
        if (!isVanillaGive && !args[0].equalsIgnoreCase("rsv")) {
            return;
        }
        String givePerm = "minecraft.command.give";
        String rsvPerm = "realisticsurvival.command.give";
        if (!(player.isOp() || isVanillaGive && player.hasPermission(givePerm) || !isVanillaGive && player.hasPermission(rsvPerm))) {
            return;
        }
        if (!(isVanillaGive || args.length != 3 && args[1].equalsIgnoreCase("give"))) {
            return;
        }
        String string = isVanillaGive ? args[1] : args[2];
        Set affected = Bukkit.selectEntities((CommandSender)player, (String)string).stream().filter(Player.class::isInstance).map(Player.class::cast).collect(Collectors.toSet());
        if (affected.isEmpty()) {
            return;
        }
        Matcher matcher = java.util.regex.Pattern.compile(isVanillaGive ? "(?:minecraft:)?([a-z_]+)" : "([a-zA-Z_]*)").matcher(isVanillaGive ? args[2] : args[3]);
        if (!matcher.find()) {
            return;
        }
        String itemName = matcher.group(1);
        if (!Utils.isInEnum(itemName.toUpperCase(), Material.class) && !RSVItem.isRSVItem(itemName.toLowerCase())) {
            return;
        }
        int amount = 1;
        if (isVanillaGive && args.length > 3 && StringUtils.isNumeric((String)args[3]) || !isVanillaGive && args.length > 4 && StringUtils.isNumeric((String)args[4])) {
            amount = isVanillaGive ? Integer.parseInt(args[3]) : Integer.parseInt(args[4]);
        }
        ItemStack totalAdded = isVanillaGive ? new ItemStack(Material.valueOf((String)itemName.toUpperCase())) : RSVItem.getItem(itemName.toLowerCase());
        for (Player p : affected) {
            if (Utils.isItemReal(p.getInventory().getItemInMainHand())) continue;
            Inventory simulate = Bukkit.createInventory(null, (InventoryType)InventoryType.PLAYER);
            simulate.setContents(p.getInventory().getContents());
            Utils.addItemToInventory(simulate, totalAdded, amount);
            ItemStack added = simulate.getItem(p.getInventory().getHeldItemSlot());
            if (!Utils.isItemReal(added)) continue;
            this.pm.callEvent((Event)new PlayerItemAcquireEvent(p, added, EntityItemAcquireEvent.ItemAcquireCause.GIVE_COMMAND, EquipmentSlot.HAND, null));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPowderSnowPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        ItemStack prev = event.getItemInHand();
        if (event.getBlockPlaced().getType() != Material.POWDER_SNOW || prev.getType() != Material.POWDER_SNOW_BUCKET || player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        ItemStack result = new ItemStack(Material.BUCKET);
        this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, result, EntityItemAcquireEvent.ItemAcquireCause.BUCKET_EMPTY, event.getHand(), prev));
    }

    public boolean isDyedLeatherArmor(@Nullable ItemStack item) {
        ItemMeta itemMeta;
        if (!(Utils.isItemReal(item) && Utils.isArmor(item.getType()) && (itemMeta = item.getItemMeta()) instanceof LeatherArmorMeta)) {
            return false;
        }
        LeatherArmorMeta itemMeta2 = (LeatherArmorMeta)itemMeta;
        Color color = itemMeta2.getColor();
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        Color defaultColor = Bukkit.getServer().getItemFactory().getDefaultLeatherColor();
        int defaultR = defaultColor.getRed();
        int defaultG = defaultColor.getGreen();
        int defaultB = defaultColor.getBlue();
        return r == defaultR && g == defaultG && b == defaultB;
    }

    @Nullable
    public ItemStack resetLeatherArmorColor(@Nullable ItemStack item) {
        if (!this.isDyedLeatherArmor(item)) {
            return null;
        }
        item = item.clone();
        LeatherArmorMeta meta = (LeatherArmorMeta)item.getItemMeta();
        meta.setColor(Bukkit.getServer().getItemFactory().getDefaultLeatherColor());
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    public boolean isCustomizedBanner(@Nullable ItemStack item) {
        ItemMeta itemMeta;
        if (!(Utils.isItemReal(item) && Utils.isArmor(item.getType()) && (itemMeta = item.getItemMeta()) instanceof BannerMeta)) {
            return false;
        }
        BannerMeta itemMeta2 = (BannerMeta)itemMeta;
        List patterns = itemMeta2.getPatterns();
        return patterns.size() != 1 || ((Pattern)patterns.get(0)).getPattern() != PatternType.BASE;
    }

    @Nullable
    public ItemStack resetBanner(@Nullable ItemStack item) {
        if (!this.isCustomizedBanner(item)) {
            return null;
        }
        item = item.clone();
        BannerMeta meta = (BannerMeta)item.getItemMeta();
        DyeColor color = null;
        for (Pattern p : meta.getPatterns()) {
            if (p.getPattern() != PatternType.BASE) continue;
            color = p.getColor();
            break;
        }
        if (color == null) {
            return null;
        }
        meta.setPatterns(List.of(new Pattern(color, PatternType.BASE)));
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    public boolean isDyedShulkerBox(@Nullable ItemStack item) {
        return Utils.isItemReal(item) && item.getType().toString().endsWith("_SHULKER_BOX") && item.getType() != Material.PURPLE_SHULKER_BOX;
    }

    @Nullable
    public ItemStack resetShulkerBoxColor(@Nullable ItemStack item) {
        if (!this.isDyedShulkerBox(item)) {
            return null;
        }
        item = item.clone();
        item.setType(Material.PURPLE_SHULKER_BOX);
        return item;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCauldronLevelChange(CauldronLevelChangeEvent event) {
        EntityItemAcquireEvent.ItemAcquireCause cause;
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Material prevCauldron = event.getBlock().getType();
        Material resultCauldron = event.getNewState().getType();
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        ItemStack offHand = player.getInventory().getItemInOffHand();
        ItemStack prev = null;
        ItemStack result = null;
        EquipmentSlot loc = null;
        switch (event.getReason()) {
            case BOTTLE_EMPTY: {
                if (player.getGameMode() == GameMode.CREATIVE) {
                    return;
                }
                prev = Utils.isItemReal(mainHand) && mainHand.getType() == Material.POTION ? mainHand : offHand;
                result = new ItemStack(Material.GLASS_BOTTLE);
                cause = EntityItemAcquireEvent.ItemAcquireCause.BOTTLE_EMPTY;
                loc = Utils.isItemReal(mainHand) && mainHand.getType() == Material.POTION ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND;
                break;
            }
            case BOTTLE_FILL: {
                if (player.getGameMode() == GameMode.CREATIVE) {
                    return;
                }
                prev = Utils.isItemReal(mainHand) && mainHand.getType() == Material.GLASS_BOTTLE ? mainHand : offHand;
                result = RSVItem.getItem("potion_water");
                cause = EntityItemAcquireEvent.ItemAcquireCause.BOTTLE_FILL;
                loc = Utils.isItemReal(mainHand) && mainHand.getType() == Material.GLASS_BOTTLE ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND;
                break;
            }
            case BUCKET_EMPTY: {
                if (player.getGameMode() == GameMode.CREATIVE) {
                    return;
                }
                if (resultCauldron == Material.LAVA_CAULDRON) {
                    prev = Utils.isItemReal(mainHand) && mainHand.getType() == Material.LAVA_BUCKET ? mainHand : offHand;
                    loc = Utils.isItemReal(mainHand) && mainHand.getType() == Material.LAVA_BUCKET ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND;
                } else if (resultCauldron == Material.WATER_CAULDRON) {
                    prev = Utils.isItemReal(mainHand) && mainHand.getType() == Material.WATER_BUCKET ? mainHand : offHand;
                    loc = Utils.isItemReal(mainHand) && mainHand.getType() == Material.WATER_BUCKET ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND;
                } else if (resultCauldron == Material.POWDER_SNOW_CAULDRON) {
                    prev = Utils.isItemReal(mainHand) && mainHand.getType() == Material.POWDER_SNOW_BUCKET ? mainHand : offHand;
                    loc = Utils.isItemReal(mainHand) && mainHand.getType() == Material.POWDER_SNOW_BUCKET ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND;
                }
                result = new ItemStack(Material.BUCKET);
                cause = EntityItemAcquireEvent.ItemAcquireCause.BUCKET_EMPTY;
                break;
            }
            case BUCKET_FILL: {
                if (player.getGameMode() == GameMode.CREATIVE) {
                    return;
                }
                if (prevCauldron == Material.LAVA_CAULDRON) {
                    result = new ItemStack(Material.LAVA_BUCKET);
                } else if (prevCauldron == Material.WATER_CAULDRON) {
                    result = new ItemStack(Material.WATER_BUCKET);
                } else if (prevCauldron == Material.POWDER_SNOW_CAULDRON) {
                    result = new ItemStack(Material.POWDER_SNOW_BUCKET);
                }
                prev = Utils.isItemReal(mainHand) && mainHand.getType() == Material.BUCKET ? mainHand : offHand;
                cause = EntityItemAcquireEvent.ItemAcquireCause.BUCKET_FILL_LIQUID;
                loc = Utils.isItemReal(mainHand) && mainHand.getType() == Material.BUCKET ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND;
                break;
            }
            case ARMOR_WASH: {
                prev = this.isDyedLeatherArmor(mainHand) ? mainHand : offHand;
                result = this.resetLeatherArmorColor(prev);
                cause = EntityItemAcquireEvent.ItemAcquireCause.LEATHER_ARMOR_WASH;
                loc = this.isDyedLeatherArmor(mainHand) ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND;
                break;
            }
            case BANNER_WASH: {
                prev = this.isCustomizedBanner(mainHand) ? mainHand : offHand;
                result = this.resetBanner(prev);
                cause = EntityItemAcquireEvent.ItemAcquireCause.BANNER_WASH;
                loc = this.isCustomizedBanner(mainHand) ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND;
                break;
            }
            case SHULKER_WASH: {
                prev = this.isDyedShulkerBox(mainHand) ? mainHand : offHand;
                result = this.resetShulkerBoxColor(prev);
                cause = EntityItemAcquireEvent.ItemAcquireCause.SHULKER_BOX_WASH;
                loc = this.isDyedShulkerBox(mainHand) ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND;
                break;
            }
            default: {
                return;
            }
        }
        if (result != null && loc != null) {
            this.pm.callEvent((Event)new PlayerItemAcquireEvent(player, result, cause, loc, prev));
        }
    }
}

