/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.misc;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Logger;
import me.val_mobile.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Consumer;

public class UpdateChecker {
    private final JavaPlugin plugin;
    private final int resourceId;

    public UpdateChecker(JavaPlugin plugin, int resourceId) {
        this.plugin = plugin;
        this.resourceId = resourceId;
    }

    public void getVersion(Consumer<String> consumer) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (InputStream inputStream = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.resourceId).openStream();
                 Scanner scanner = new Scanner(inputStream);){
                if (scanner.hasNext()) {
                    consumer.accept((Object)scanner.next());
                }
            }
            catch (IOException exception) {
                this.plugin.getLogger().info(Utils.translateMsg("&cCannot look for updates: " + exception.getMessage(), null, null));
            }
        });
    }

    public void checkUpdate() {
        Logger logger = this.plugin.getLogger();
        this.getVersion((Consumer<String>)((Consumer)latestVersion -> {
            String currentVersion = this.plugin.getDescription().getVersion();
            int compareTo = currentVersion.compareTo((String)latestVersion);
            List messages = compareTo == 0 ? this.plugin.getConfig().getStringList("CorrectVersion") : (compareTo < 0 ? this.plugin.getConfig().getStringList("OutdatedVersion") : this.plugin.getConfig().getStringList("DeveloperBuildVersion"));
            for (String message : messages) {
                logger.info(Utils.translateMsg(message, null, null));
            }
        }));
    }
}

