/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.tan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import me.val_mobile.data.RSVPlayer;
import me.val_mobile.integrations.CompatiblePlugin;
import me.val_mobile.integrations.RealisticSeasons;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.tan.TanModule;
import me.val_mobile.utils.RSVTask;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class HypothermiaTask
extends BukkitRunnable
implements RSVTask {
    private static final Map<UUID, HypothermiaTask> tasks = new HashMap<UUID, HypothermiaTask>();
    private final TanModule module;
    private final FileConfiguration config;
    private final RSVPlugin plugin;
    private final RSVPlayer player;
    private final UUID id;
    private final Collection<String> allowedWorlds;
    private final RealisticSeasons rs;
    private final boolean damageEnabled;
    private final double damageCutoff;
    private final double damage;
    private final boolean potionEffectsEnabled;
    private final double maxTemperature;
    private final Collection<PotionEffect> potionEffects = new ArrayList<PotionEffect>();

    public HypothermiaTask(TanModule module, RSVPlugin plugin, RSVPlayer player) {
        this.plugin = plugin;
        this.module = module;
        this.config = module.getUserConfig().getConfig();
        this.player = player;
        this.id = player.getPlayer().getUniqueId();
        this.allowedWorlds = module.getAllowedWorlds();
        this.damageEnabled = this.config.getBoolean("Temperature.Hypothermia.Damage.Enabled");
        this.damageCutoff = this.config.getDouble("Temperature.Hypothermia.Damage.Cutoff");
        this.damage = this.config.getDouble("Temperature.Hypothermia.Damage.Amount");
        this.potionEffectsEnabled = this.config.getBoolean("Temperature.Hypothermia.PotionEffects.Enabled");
        this.maxTemperature = this.config.getDouble("Temperature.Hypothermia.Temperature");
        this.rs = (RealisticSeasons)CompatiblePlugin.getPlugin("RealisticSeasons");
        ConfigurationSection section = this.config.getConfigurationSection("Temperature.Hypothermia.PotionEffects.Effects");
        Set keys = section.getKeys(false);
        for (String key : keys) {
            int dur = section.getInt(key + ".Duration");
            int amp = section.getInt(key + ".Amplifier");
            this.potionEffects.add(new PotionEffect(PotionEffectType.getByName((String)key), dur, amp));
        }
        tasks.put(this.id, this);
    }

    public void run() {
        Player player = this.player.getPlayer();
        if (this.conditionsMet(player)) {
            if (!player.hasPermission("realisticsurvival.toughasnails.resistance.cold.damage") && this.damageEnabled && !this.rs.disableHypothermiaDamage() && player.getHealth() >= this.damageCutoff) {
                if (player.getHealth() - this.damage <= 0.0) {
                    this.module.getHypothermiaDeath().add(this.id);
                }
                player.damage(this.damage);
            }
            if (!player.hasPermission("realisticsurvival.toughasnails.resistance.cold.potioneffects") && this.potionEffectsEnabled && !this.rs.disableHypothermiaPotions()) {
                player.addPotionEffects(this.potionEffects);
            }
        } else {
            this.stop();
        }
    }

    @Override
    public boolean conditionsMet(@Nullable Player player) {
        return this.globalConditionsMet((LivingEntity)player) && !player.isDead() && this.allowedWorlds.contains(player.getWorld().getName()) && this.module.getTempManager().getTemperature(player) < this.maxTemperature;
    }

    @Override
    public void start() {
        int tickPeriod = this.config.getInt("Temperature.Hypothermia.TickPeriod");
        this.runTaskTimer((Plugin)this.plugin, 0L, tickPeriod);
    }

    @Override
    public void stop() {
        tasks.remove(this.id);
        this.cancel();
    }

    public static boolean hasTask(UUID id) {
        if (tasks.containsKey(id)) {
            return tasks.get(id) != null;
        }
        return false;
    }

    public static Map<UUID, HypothermiaTask> getTasks() {
        return tasks;
    }
}

